/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.platform.Jsonifier;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.Method;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import com.helpshift.crypto.CryptoDM;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class AuthDataProvider {
    final String appId;
    final String apiKey;
    final String route;
    final CryptoDM cryptoDM;
    final NetworkRequestDAO networkRequestDAO;
    final Jsonifier jsonifier;

    public AuthDataProvider(Domain domain, Platform platform, String route) {
        this.apiKey = platform.getAPIKey();
        this.appId = platform.getAppId();
        this.route = route;
        this.cryptoDM = domain.getCryptoDM();
        this.networkRequestDAO = platform.getNetworkRequestDAO();
        this.jsonifier = platform.getJsonifier();
    }

    public Map<String, String> getAuthData(Method method, Map<String, String> data) throws GeneralSecurityException {
        if (data == null || StringUtils.isEmpty(data.get("uri"))) {
            throw new IllegalArgumentException("No value for uri in auth data.");
        }
        data.put("platform-id", this.appId);
        data.put("method", method.name());
        data.put("timestamp", NetworkDataRequestUtil.getAdjustedTimestamp(this.networkRequestDAO));
        data.put("sm", this.jsonifier.jsonify(NetworkDataRequestUtil.getSdkMeta()));
        ArrayList<String> mapKeys = new ArrayList<String>(data.keySet());
        Collections.sort(mapKeys);
        ArrayList<String> dataList = new ArrayList<String>();
        for (String key : mapKeys) {
            if (key.equals("screenshot") || key.equals("meta") || key.equals("originalFileName")) continue;
            dataList.add(key + "=" + data.get(key));
        }
        data.put("signature", this.cryptoDM.getSignature(StringUtils.join("&", dataList), this.apiKey));
        data.remove("method");
        data.remove("uri");
        return data;
    }
}

