/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;

public class AuthenticationFailureNetwork
implements Network {
    private static final String REASON_AUTH_TOKEN_NOT_PROVIDED = "missing user auth token";
    private static final String REASON_INVALID_AUTH_TOKEN = "invalid user auth token";
    private final Network network;

    public AuthenticationFailureNetwork(Network network) {
        this.network = network;
    }

    @Override
    public Response makeRequest(RequestData data) {
        Response response = this.network.makeRequest(data);
        int status = response.status;
        if (status == NetworkErrorCodes.UNAUTHORIZED_ACCESS && !StringUtils.isEmpty(response.responseString)) {
            if (REASON_AUTH_TOKEN_NOT_PROVIDED.equalsIgnoreCase(response.responseString)) {
                NetworkException exception = NetworkException.AUTH_TOKEN_NOT_PROVIDED;
                exception.serverStatusCode = NetworkErrorCodes.AUTH_TOKEN_NOT_PROVIDED;
                throw RootAPIException.wrap(null, exception);
            }
            if (REASON_INVALID_AUTH_TOKEN.equalsIgnoreCase(response.responseString)) {
                NetworkException exception = NetworkException.INVALID_AUTH_TOKEN;
                exception.serverStatusCode = NetworkErrorCodes.INVALID_AUTH_TOKEN;
                throw RootAPIException.wrap(null, exception);
            }
        }
        return response;
    }
}

