/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.AuthDataProvider;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkConstants;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Device;
import com.helpshift.common.platform.Jsonifier;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.HTTPTransport;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.common.platform.network.Method;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import com.helpshift.common.platform.network.Request;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;
import com.helpshift.crypto.CryptoDM;
import com.helpshift.localeprovider.domainmodel.LocaleProviderDM;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

abstract class BaseNetwork
implements Network {
    final String route;
    final NetworkRequestDAO networkRequestDAO;
    private final HTTPTransport transport;
    private final String apiKey;
    private final LocaleProviderDM localeProviderDM;
    private final CryptoDM cryptoDM;
    private final String domainKey;
    private final String appId;
    private final Device device;
    private final Jsonifier jsonifier;
    private final Domain domain;
    private final Platform platform;

    BaseNetwork(String route, Domain domain, Platform platform) {
        this.route = route;
        this.platform = platform;
        this.domain = domain;
        this.localeProviderDM = domain.getLocaleProviderDM();
        this.cryptoDM = domain.getCryptoDM();
        this.networkRequestDAO = platform.getNetworkRequestDAO();
        this.transport = platform.getHTTPTransport();
        this.apiKey = platform.getAPIKey();
        this.domainKey = platform.getDomain();
        this.appId = platform.getAppId();
        this.device = platform.getDevice();
        this.jsonifier = platform.getJsonifier();
    }

    abstract Request getRequest(RequestData var1);

    protected String getURL() {
        return NetworkConstants.scheme + this.domainKey + this.getURI();
    }

    private String getURI() {
        return "/api/lib/3" + this.route;
    }

    Map<String, String> getAuthData(Method method, Map<String, String> data) {
        AuthDataProvider authDataProvider = new AuthDataProvider(this.domain, this.platform, this.route);
        data.put("uri", this.getURI());
        try {
            return authDataProvider.getAuthData(method, data);
        }
        catch (GeneralSecurityException e) {
            NetworkException networkException = NetworkException.UNABLE_TO_GENERATE_SIGNATURE;
            networkException.route = this.route;
            throw RootAPIException.wrap(e, networkException, "Network error");
        }
    }

    List<KeyValuePair> getHeaders(String requestId, RequestData requestData) {
        List<KeyValuePair> headers = this.getCommonHeaders(requestId);
        headers.addAll(this.getCustomHeaders(requestData));
        return headers;
    }

    List<KeyValuePair> getCommonHeaders(String requestId) {
        String userAgent = String.format(Locale.ENGLISH, "Helpshift-%s/%s/%s", this.device.getPlatformName(), this.device.getSDKVersion(), this.device.getOSVersion());
        String sdkLanguage = this.localeProviderDM.getSDKLanguage();
        String deviceLanguage = this.localeProviderDM.getDefaultLanguage();
        String acceptLangHead = !StringUtils.isEmpty(sdkLanguage) ? String.format(Locale.ENGLISH, "%s;q=1.0, %s;q=0.5", sdkLanguage, deviceLanguage) : String.format(Locale.ENGLISH, "%s;q=1.0", deviceLanguage);
        String xHSVHead = String.format(Locale.ENGLISH, "Helpshift-%s/%s", this.device.getPlatformName(), this.device.getSDKVersion());
        ArrayList<KeyValuePair> headers = new ArrayList<KeyValuePair>();
        headers.add(new KeyValuePair("User-Agent", userAgent));
        headers.add(new KeyValuePair("Accept-Language", acceptLangHead));
        headers.add(new KeyValuePair("Accept-Encoding", "gzip"));
        headers.add(new KeyValuePair("X-HS-V", xHSVHead));
        headers.add(new KeyValuePair("X-HS-Request-ID", requestId));
        return headers;
    }

    private List<KeyValuePair> getCustomHeaders(RequestData requestData) {
        ArrayList<KeyValuePair> headers = new ArrayList<KeyValuePair>();
        Map<String, String> customHeaders = requestData.getCustomHeaders();
        if (customHeaders != null) {
            for (Map.Entry<String, String> customHeader : customHeaders.entrySet()) {
                headers.add(new KeyValuePair(customHeader.getKey(), customHeader.getValue()));
            }
        }
        return headers;
    }

    @Override
    public Response makeRequest(RequestData data) {
        Request request = this.getRequest(data);
        return this.transport.makeRequest(request);
    }
}

