/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.POSTRequest;
import com.helpshift.common.platform.network.Request;
import com.helpshift.common.platform.network.RequestData;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;

public class CustomAuthDataPOSTNetwork
extends POSTNetwork {
    private Map<String, String> customAuthData;

    public CustomAuthDataPOSTNetwork(String route, Domain domain, Platform platform, Map<String, String> customAuthData) {
        super(route, domain, platform);
        this.customAuthData = customAuthData;
    }

    @Override
    Request getRequest(RequestData requestData) {
        return new POSTRequest(this.getURL(), this.getQuery(NetworkDataRequestUtil.cleanData(requestData.body)), this.getHeaders(requestData.getRequestId(), requestData), 5000);
    }

    @Override
    protected String getQuery(Map<String, String> data) {
        data.putAll(this.customAuthData);
        data = NetworkDataRequestUtil.cleanData(data);
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            try {
                String param = URLEncoder.encode(entry.getKey(), "UTF-8") + "=" + URLEncoder.encode(entry.getValue(), "UTF-8");
                result.add(param);
            }
            catch (UnsupportedEncodingException e) {
                throw RootAPIException.wrap(e, NetworkException.UNSUPPORTED_ENCODING_EXCEPTION);
            }
        }
        return StringUtils.join("&", result);
    }
}

