/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;

public class FailedAPICallNetworkDecorator
implements Network {
    private final Network network;

    public FailedAPICallNetworkDecorator(Network network) {
        this.network = network;
    }

    @Override
    public Response makeRequest(RequestData requestData) {
        Response response = this.network.makeRequest(requestData);
        int status = response.status;
        if (this.isStatusCodeNonRetriable(status)) {
            NetworkException networkException = NetworkException.NON_RETRIABLE;
            networkException.serverStatusCode = status;
            throw RootAPIException.wrap(null, networkException);
        }
        return response;
    }

    private boolean isStatusCodeNonRetriable(int status) {
        return NetworkErrorCodes.NOT_RETRIABLE_STATUS_CODES.contains(status);
    }
}

