/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.BaseNetwork;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.GETRequest;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.common.platform.network.Method;
import com.helpshift.common.platform.network.Request;
import com.helpshift.common.platform.network.RequestData;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GETNetwork
extends BaseNetwork {
    public GETNetwork(String route, Domain domain, Platform platform) {
        super(route, domain, platform);
    }

    @Override
    Request getRequest(RequestData requestData) {
        String url = this.getURL() + "?" + this.getQuery(NetworkDataRequestUtil.cleanData(requestData.body));
        return new GETRequest(url, this.getHeaders(requestData.getRequestId(), requestData), 5000);
    }

    private String getQuery(Map<String, String> data) {
        Map<String, String> authData = this.getAuthData(Method.GET, data);
        ArrayList<String> dataList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : authData.entrySet()) {
            try {
                dataList.add(entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw RootAPIException.wrap(e, NetworkException.UNSUPPORTED_ENCODING_EXCEPTION);
            }
        }
        return StringUtils.join("&", dataList);
    }

    @Override
    List<KeyValuePair> getHeaders(String requestId, RequestData requestData) {
        List<KeyValuePair> headers = super.getHeaders(requestId, requestData);
        String eTag = this.networkRequestDAO.getETag(this.route);
        if (eTag != null) {
            headers.add(new KeyValuePair("If-None-Match", eTag));
        }
        return headers;
    }
}

