/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.domain.network.Network;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;

public class GuardOKNetwork
implements Network {
    private final Network network;

    public GuardOKNetwork(Network network) {
        this.network = network;
    }

    @Override
    public Response makeRequest(RequestData requestData) {
        Response response = this.network.makeRequest(requestData);
        int status = response.status;
        if (status >= 200 && status < 300) {
            return response;
        }
        NetworkException networkException = NetworkException.UNHANDLED_STATUS_CODE;
        networkException.serverStatusCode = response.status;
        throw RootAPIException.wrap(null, networkException);
    }
}

