/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.idempotent.IdempotentPolicy;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;

public class IdempotentNetwork
implements Network {
    private Network network;
    private String route;
    private String uniqueMappingKey;
    private NetworkRequestDAO networkRequestDAO;
    private IdempotentPolicy idempotentPolicy;

    public IdempotentNetwork(Network network, Platform platform, IdempotentPolicy idempotentPolicy, String route, String uniqueMappingKey) {
        this.network = network;
        this.idempotentPolicy = idempotentPolicy;
        this.networkRequestDAO = platform.getNetworkRequestDAO();
        this.route = route;
        this.uniqueMappingKey = uniqueMappingKey;
    }

    @Override
    public Response makeRequest(RequestData requestData) {
        String existingRequestId = this.networkRequestDAO.getPendingRequestId(this.route, this.uniqueMappingKey);
        if (StringUtils.isEmpty(existingRequestId)) {
            this.networkRequestDAO.storePendingRequestId(this.route, this.uniqueMappingKey, requestData.getRequestId());
        } else {
            requestData.overrideRequestId(existingRequestId);
        }
        Response response = this.network.makeRequest(requestData);
        if (response == null || this.idempotentPolicy.isRequestCompleted(response.status)) {
            this.networkRequestDAO.deletePendingRequestId(this.route, this.uniqueMappingKey);
            this.networkRequestDAO.storeSuccessfulRequestId(requestData.getRequestId());
        }
        return response;
    }
}

