/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.domain.network.Network;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Jsonifier;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;
import java.util.HashMap;
import java.util.Map;

public class MetaCorrectedNetwork
implements Network {
    private final Network network;
    private final Jsonifier jsonifier;

    public MetaCorrectedNetwork(Network network, Platform platform) {
        this.network = network;
        this.jsonifier = platform.getJsonifier();
    }

    @Override
    public Response makeRequest(RequestData data) {
        return this.makeRequest(data, 1);
    }

    private Response makeRequest(RequestData requestData, int retryCount) {
        Response response = this.network.makeRequest(requestData);
        if (response.status == 413) {
            if (retryCount > 0) {
                HashMap<String, String> newBody = new HashMap<String, String>(requestData.body);
                this.removeCIFAndCustomMetadata(newBody);
                RequestData newRequestData = new RequestData(newBody);
                return this.makeRequest(newRequestData, --retryCount);
            }
            throw RootAPIException.wrap(null, NetworkException.ENTITY_TOO_LARGE_RETRIES_EXHAUSTED);
        }
        return response;
    }

    private void removeCIFAndCustomMetadata(Map<String, String> data) {
        String meta = data.get("meta");
        data.put("meta", this.jsonifier.removeKeyFromJsonObjString(meta, "custom_meta"));
        data.remove("custom_fields");
    }
}

