/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.account.domainmodel.ClearedUserDM;
import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.account.domainmodel.UserManagerDM;
import com.helpshift.common.StringUtils;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class NetworkDataRequestUtil {
    public static HashMap<String, String> getUserRequestData(UserManagerDM userManagerDM) {
        UserDM activeUser = null;
        if (userManagerDM != null) {
            activeUser = userManagerDM.getActiveUser();
        }
        return NetworkDataRequestUtil.getUserRequestData(activeUser);
    }

    public static HashMap<String, String> getUserRequestData(UserDM userDM) {
        HashMap<String, String> returnData = new HashMap<String, String>();
        if (userDM != null) {
            if (!StringUtils.isEmpty(userDM.getDeviceId())) {
                returnData.put("did", userDM.getDeviceId());
            }
            if (!StringUtils.isEmpty(userDM.getIdentifier())) {
                returnData.put("uid", userDM.getIdentifier());
            }
            if (!StringUtils.isEmpty(userDM.getEmail())) {
                returnData.put("email", userDM.getEmail());
            }
            if (!StringUtils.isEmpty(userDM.getAuthToken())) {
                returnData.put("user_auth_token", userDM.getAuthToken());
            }
        }
        return returnData;
    }

    public static HashMap<String, String> getUserRequestData(ClearedUserDM clearedUserDM) {
        HashMap<String, String> returnData = new HashMap<String, String>();
        if (clearedUserDM != null) {
            if (!StringUtils.isEmpty(clearedUserDM.deviceId)) {
                returnData.put("did", clearedUserDM.deviceId);
            }
            if (!StringUtils.isEmpty(clearedUserDM.identifier)) {
                returnData.put("uid", clearedUserDM.identifier);
            }
            if (!StringUtils.isEmpty(clearedUserDM.email)) {
                returnData.put("email", clearedUserDM.email);
            }
            if (!StringUtils.isEmpty(clearedUserDM.authToken)) {
                returnData.put("user_auth_token", clearedUserDM.authToken);
            }
        }
        return returnData;
    }

    public static Map<String, String> cleanData(Map<String, String> data) {
        HashMap<String, String> cleanData = new HashMap<String, String>();
        for (String key : data.keySet()) {
            String value;
            if (key == null || (value = data.get(key)) == null) continue;
            cleanData.put(key, value);
        }
        return cleanData;
    }

    public static Map<String, Object> getSdkMeta() {
        HashMap<String, Object> sdkMetaMap = new HashMap<String, Object>();
        sdkMetaMap.put("ia", true);
        sdkMetaMap.put("rs", true);
        sdkMetaMap.put("clc", true);
        sdkMetaMap.put("atai_v2", true);
        sdkMetaMap.put("fp", true);
        sdkMetaMap.put("cb", true);
        return sdkMetaMap;
    }

    public static String getAdjustedTimestamp(NetworkRequestDAO networkRequestDAO) {
        float timeDelta = networkRequestDAO.getServerTimeDelta();
        DecimalFormat secondsFormatter = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
        double deviceTs = (double)System.currentTimeMillis() / 1000.0;
        return secondsFormatter.format(deviceTs + (double)timeDelta);
    }
}

