/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.BaseNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.common.platform.network.Method;
import com.helpshift.common.platform.network.PUTRequest;
import com.helpshift.common.platform.network.Request;
import com.helpshift.common.platform.network.RequestData;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PUTNetwork
extends BaseNetwork
implements Network {
    public PUTNetwork(String route, Domain domain, Platform platform) {
        super(route, domain, platform);
    }

    @Override
    Request getRequest(RequestData requestData) {
        return new PUTRequest(this.getURL(), this.getQuery(NetworkDataRequestUtil.cleanData(requestData.body)), this.getHeaders(requestData.getRequestId(), requestData), 5000);
    }

    @Override
    protected List<KeyValuePair> getHeaders(String requestId, RequestData requestData) {
        List<KeyValuePair> headers = super.getHeaders(requestId, requestData);
        headers.add(new KeyValuePair("Content-type", "application/x-www-form-urlencoded"));
        return headers;
    }

    protected String getQuery(Map<String, String> data) {
        Map<String, String> authData = this.getAuthData(Method.PUT, data);
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : authData.entrySet()) {
            try {
                String param = URLEncoder.encode(entry.getKey(), "UTF-8") + "=" + URLEncoder.encode(entry.getValue(), "UTF-8");
                result.add(param);
            }
            catch (UnsupportedEncodingException e) {
                throw RootAPIException.wrap(e, NetworkException.UNSUPPORTED_ENCODING_EXCEPTION);
            }
        }
        return StringUtils.join("&", result);
    }
}

