/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.domain.network.Network;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.util.HSDateFormatSpec;
import java.util.List;

public class TSCorrectedNetwork
implements Network {
    private final Network network;
    private final NetworkRequestDAO networkRequestDAO;

    public TSCorrectedNetwork(Network network, Platform platform) {
        this.network = network;
        this.networkRequestDAO = platform.getNetworkRequestDAO();
    }

    @Override
    public Response makeRequest(RequestData requestData) {
        return this.makeRequest(requestData, 3);
    }

    private Response makeRequest(RequestData requestData, int retryCount) {
        Response response = this.network.makeRequest(requestData);
        if (response.status == 422) {
            if (retryCount != 0) {
                --retryCount;
                String serverTime = this.getHeaderValue(response.headers, "HS-UEpoch");
                if (serverTime != null) {
                    this.networkRequestDAO.storeServerTimeDelta(HSDateFormatSpec.calculateTimeDelta(serverTime));
                }
                return this.makeRequest(new RequestData(requestData), retryCount);
            }
            throw RootAPIException.wrap(null, NetworkException.TIMESTAMP_CORRECTION_RETRIES_EXHAUSTED);
        }
        return response;
    }

    private String getHeaderValue(List<KeyValuePair> headers, String key) {
        String value = null;
        for (KeyValuePair header : headers) {
            if (header.key == null || !header.key.equals(key)) continue;
            value = header.value;
            break;
        }
        return value;
    }
}

