/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.BaseNetwork;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.common.platform.network.Method;
import com.helpshift.common.platform.network.Request;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.UploadRequest;
import java.io.File;
import java.util.List;

public class UploadNetwork
extends BaseNetwork {
    Platform platform;

    public UploadNetwork(String route, Domain domain, Platform platform) {
        super(route, domain, platform);
        this.platform = platform;
    }

    @Override
    Request getRequest(RequestData requestData) {
        File screenshotFile = new File(requestData.body.get("screenshot"));
        String mimeType = this.platform.getMimeTypeForFile(screenshotFile.getPath());
        if (this.platform.isSupportedMimeType(mimeType)) {
            return new UploadRequest(Method.POST, this.getURL(), this.getAuthData(Method.POST, NetworkDataRequestUtil.cleanData(requestData.body)), mimeType, this.getHeaders(requestData.getRequestId(), requestData), 30000);
        }
        throw RootAPIException.wrap(null, NetworkException.UNSUPPORTED_MIME_TYPE);
    }

    @Override
    List<KeyValuePair> getHeaders(String requestId, RequestData requestData) {
        List<KeyValuePair> headers = super.getHeaders(requestId, requestData);
        headers.add(new KeyValuePair("Connection", "Keep-Alive"));
        headers.add(new KeyValuePair("Content-Type", "multipart/form-data;boundary=*****"));
        return headers;
    }
}

