/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import android.os.Environment;
import android.text.TextUtils;
import com.helpshift.common.dao.BackupDAO;
import com.helpshift.util.HelpshiftContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class AndroidBackupDAO
implements BackupDAO {
    private final String BACKUP_FILE_NAME = "__hs__backup_dao_storage";
    private String externalDirectoryPath;

    @Override
    public synchronized void storeValue(String key, Serializable value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        HashMap<String, Serializable> backedupHashMap = this.restoreHashMap();
        if (backedupHashMap == null) {
            backedupHashMap = new HashMap();
        }
        if (value.equals(backedupHashMap.get(key))) {
            return;
        }
        backedupHashMap.put(key, value);
        this.backupHashMap(backedupHashMap);
    }

    @Override
    public synchronized Serializable getValue(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        HashMap<String, Serializable> backedupHashMap = this.restoreHashMap();
        if (backedupHashMap != null) {
            return backedupHashMap.get(key);
        }
        return null;
    }

    @Override
    public synchronized void removeKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        HashMap<String, Serializable> backedupHashMap = this.restoreHashMap();
        if (backedupHashMap != null && backedupHashMap.containsKey(key)) {
            backedupHashMap.remove(key);
            this.backupHashMap(backedupHashMap);
        }
    }

    @Override
    public synchronized void delete() {
        if (!this.backupExists()) {
            return;
        }
        try {
            File backupFile;
            File externalDirectory = Environment.getExternalStoragePublicDirectory((String)this.getExternalDirectoryPath());
            if (externalDirectory != null && externalDirectory.exists() && (backupFile = new File(externalDirectory, "__hs__backup_dao_storage")).canWrite()) {
                backupFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupHashMap(HashMap<String, Serializable> data) {
        if (data == null) {
            return;
        }
        ObjectOutputStream outputStream = null;
        try {
            File destinationDirectory = Environment.getExternalStoragePublicDirectory((String)this.getExternalDirectoryPath());
            if (!destinationDirectory.exists()) {
                destinationDirectory.mkdirs();
            }
            if (destinationDirectory.canWrite()) {
                File destinationFile = new File(destinationDirectory, "__hs__backup_dao_storage");
                outputStream = new ObjectOutputStream(new FileOutputStream(destinationFile));
                outputStream.writeObject(data);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Serializable> restoreHashMap() {
        if (!this.backupExists()) {
            return null;
        }
        HashMap returnData = null;
        ObjectInputStream inputStream = null;
        try {
            File sourceDirectory = Environment.getExternalStoragePublicDirectory((String)this.getExternalDirectoryPath());
            if (sourceDirectory.canRead()) {
                File sourceFile = new File(sourceDirectory, "__hs__backup_dao_storage");
                inputStream = new ObjectInputStream(new FileInputStream(sourceFile));
                returnData = (HashMap)inputStream.readObject();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return returnData;
    }

    private boolean backupExists() {
        try {
            File externalDirectory = Environment.getExternalStoragePublicDirectory((String)this.getExternalDirectoryPath());
            File backupFile = new File(externalDirectory, "__hs__backup_dao_storage");
            return backupFile.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getExternalDirectoryPath() {
        if (this.externalDirectoryPath == null) {
            this.externalDirectoryPath = ".backups/" + HelpshiftContext.getApplicationContext().getPackageName() + "/helpshift/databases/";
        }
        return this.externalDirectoryPath;
    }
}

