/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import android.content.Context;
import com.helpshift.common.conversation.ConversationDB;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.ConversationUpdate;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.dao.ConversationDAO;
import com.helpshift.conversation.dao.FAQSuggestionsDAO;
import com.helpshift.support.Faq;
import com.helpshift.util.HSLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class AndroidConversationDAO
implements ConversationDAO,
FAQSuggestionsDAO {
    private final ConversationDB conversationDB;
    private final String TAG = "Helpshift_CnDAO";

    AndroidConversationDAO(Context context) {
        this.conversationDB = ConversationDB.getInstance(context);
    }

    @Override
    public void dropAndCreateDatabase() {
        this.conversationDB.dropAndCreateDatabase();
    }

    @Override
    public synchronized ConversationDM readConversationWithoutMessages(String conversationServerId) {
        return this.conversationDB.readConversationWithServerId(conversationServerId);
    }

    @Override
    public synchronized ConversationDM readPreConversationWithoutMessages(String preConversationServerId) {
        return this.conversationDB.readPreConversationWithServerId(preConversationServerId);
    }

    @Override
    public ConversationDM readConversationWithoutMessages(Long conversationLocalId) {
        return this.conversationDB.readConversationWithLocalId(conversationLocalId);
    }

    @Override
    public synchronized ConversationDM readConversation(long conversationLocalId) {
        ConversationDM readableConversation = this.conversationDB.readConversationWithLocalId(conversationLocalId);
        if (readableConversation == null) {
            return null;
        }
        readableConversation.setMessageDMs(this.conversationDB.readMessages(conversationLocalId));
        return readableConversation;
    }

    @Override
    public synchronized void deleteConversation(long conversationLocalId) {
        if (conversationLocalId != 0L) {
            this.conversationDB.deleteConversationWithLocalId(conversationLocalId);
        }
    }

    @Override
    public synchronized List<ConversationDM> readConversationsWithoutMessages(long profileLocalId) {
        return this.conversationDB.readConversationsWithLocalId(profileLocalId);
    }

    @Override
    public synchronized void insertPreIssueConversation(ConversationDM conversation) {
        long localId;
        if (conversation.localUUID == null) {
            conversation.localUUID = UUID.randomUUID().toString();
        }
        if ((localId = this.conversationDB.insertConversation(conversation)) != -1L) {
            conversation.setLocalId(localId);
        }
    }

    @Override
    public synchronized Map<Long, Integer> getMessagesCountForConversations(List<Long> conversationslocalIds) {
        return this.conversationDB.getMessagesCountForConversations(conversationslocalIds, null);
    }

    @Override
    public synchronized Map<Long, Integer> getMessagesCountForConversations(List<Long> conversationslocalIds, String[] messageTypes) {
        return this.conversationDB.getMessagesCountForConversations(conversationslocalIds, messageTypes);
    }

    @Override
    public synchronized List<MessageDM> readMessages(long conversationLocalId) {
        return this.conversationDB.readMessages(conversationLocalId);
    }

    @Override
    public List<MessageDM> readMessages(long conversationLocalId, MessageType messageType) {
        return this.conversationDB.readMessages(conversationLocalId, messageType);
    }

    @Override
    public List<MessageDM> readMessagesForConversations(List<Long> conversationLocalIds) {
        return this.conversationDB.readMessagesForConversations(conversationLocalIds);
    }

    @Override
    public MessageDM readMessage(String serverId) {
        return this.conversationDB.readMessageWithServerId(serverId);
    }

    @Override
    public synchronized void insertOrUpdateMessage(MessageDM newMessage) {
        Long newLocalId = newMessage.localId;
        String newServerId = newMessage.serverId;
        if (newLocalId == null && newServerId == null) {
            long localId = this.conversationDB.insertMessage(newMessage);
            if (localId != -1L) {
                newMessage.localId = localId;
            }
        } else if (newLocalId == null && newServerId != null) {
            MessageDM localMessage = this.conversationDB.readMessageWithServerId(newServerId);
            if (localMessage == null) {
                long localId = this.conversationDB.insertMessage(newMessage);
                if (localId != -1L) {
                    newMessage.localId = localId;
                }
            } else {
                newMessage.localId = localMessage.localId;
                this.conversationDB.updateMessage(newMessage);
            }
        } else {
            MessageDM localMessage = this.conversationDB.readMessageWithLocalId(newLocalId);
            if (localMessage == null) {
                long localId = this.conversationDB.insertMessage(newMessage);
                if (localId != -1L) {
                    newMessage.localId = localId;
                }
            } else {
                this.conversationDB.updateMessage(newMessage);
            }
        }
    }

    @Override
    public synchronized void insertOrUpdateMessages(List<MessageDM> messages) {
        if (messages.size() == 0) {
            return;
        }
        ArrayList<MessageDM> newMessages = new ArrayList<MessageDM>();
        ArrayList<MessageDM> updatedMessages = new ArrayList<MessageDM>();
        for (MessageDM messageDM : messages) {
            MessageDM localMessage;
            Long newLocalId = messageDM.localId;
            String newServerId = messageDM.serverId;
            if (newLocalId == null && newServerId == null) {
                newMessages.add(messageDM);
                continue;
            }
            if (newLocalId == null && newServerId != null) {
                localMessage = this.conversationDB.readMessageWithServerId(newServerId);
                if (localMessage == null) {
                    newMessages.add(messageDM);
                    continue;
                }
                messageDM.localId = localMessage.localId;
                updatedMessages.add(messageDM);
                continue;
            }
            localMessage = this.conversationDB.readMessageWithLocalId(newLocalId);
            if (localMessage == null) {
                newMessages.add(messageDM);
                continue;
            }
            updatedMessages.add(messageDM);
        }
        List<Long> localIds = this.conversationDB.insertMessages(newMessages);
        for (int i = 0; i < newMessages.size(); ++i) {
            long localId = localIds.get(i);
            if (localId == -1L) continue;
            ((MessageDM)newMessages.get((int)i)).localId = localId;
        }
        this.conversationDB.updateMessages(updatedMessages);
    }

    @Override
    public void insertConversation(ConversationDM conversationDM) {
        long localId;
        String newServerId = conversationDM.serverId;
        String preConversationId = conversationDM.preConversationServerId;
        if (newServerId == null && preConversationId == null) {
            return;
        }
        if (conversationDM.localUUID == null) {
            conversationDM.localUUID = UUID.randomUUID().toString();
        }
        if ((localId = this.conversationDB.insertConversation(conversationDM)) != -1L) {
            conversationDM.setLocalId(localId);
        }
        this.insertOrUpdateMessages(conversationDM.messageDMs);
    }

    @Override
    public void updateConversation(ConversationDM conversationDM) {
        String newServerId = conversationDM.serverId;
        String preConversationId = conversationDM.preConversationServerId;
        if (newServerId == null && preConversationId == null) {
            return;
        }
        this.conversationDB.updateConversation(conversationDM);
        this.insertOrUpdateMessages(conversationDM.messageDMs);
    }

    @Override
    public void updateLastUserActivityTimeInConversation(Long localId, long lastUserActivityTime) {
        if (localId == null) {
            HSLogger.e("Helpshift_CnDAO", "Trying to update last user activity time but localId is null");
            return;
        }
        this.conversationDB.updateLastUserActivityTimeInConversation(localId, lastUserActivityTime);
    }

    @Override
    public void updateConversationWithoutMessages(ConversationDM conversation) {
        this.conversationDB.updateConversation(conversation);
    }

    @Override
    public void insertConversations(List<ConversationDM> conversations) {
        if (conversations.size() == 0) {
            return;
        }
        for (ConversationDM conversationDM : conversations) {
            if (conversationDM.localUUID != null) continue;
            conversationDM.localUUID = UUID.randomUUID().toString();
        }
        List<Long> localIds = this.conversationDB.insertConversations(conversations);
        HashSet<ConversationDM> failedConversations = new HashSet<ConversationDM>();
        for (int i = 0; i < conversations.size(); ++i) {
            long localId = localIds.get(i);
            ConversationDM newConversation = conversations.get(i);
            if (localId == -1L) {
                failedConversations.add(newConversation);
                continue;
            }
            newConversation.setLocalId(localId);
        }
        ArrayList<MessageDM> allMessages = new ArrayList<MessageDM>();
        for (ConversationDM conversation : conversations) {
            if (failedConversations.contains(conversation)) continue;
            allMessages.addAll(conversation.messageDMs);
        }
        this.insertOrUpdateMessages(allMessages);
    }

    @Override
    public void updateConversations(List<ConversationDM> conversations, Map<Long, ConversationUpdate> conversationUpdateMap) {
        if (conversations.size() == 0) {
            return;
        }
        this.conversationDB.updateConversations(conversations);
        ArrayList<MessageDM> newMessages = new ArrayList<MessageDM>();
        ArrayList<MessageDM> updatedMessages = new ArrayList<MessageDM>();
        for (ConversationDM conversation : conversations) {
            if (!conversationUpdateMap.containsKey(conversation.localId)) continue;
            ConversationUpdate conversationUpdate = conversationUpdateMap.get(conversation.localId);
            newMessages.addAll(conversationUpdate.newMessageDMs);
            updatedMessages.addAll(conversationUpdate.updatedMessageDMs);
        }
        List<Long> localIds = this.conversationDB.insertMessages(newMessages);
        for (int i = 0; i < newMessages.size(); ++i) {
            long localId = localIds.get(i);
            if (localId == -1L) continue;
            ((MessageDM)newMessages.get((int)i)).localId = localId;
        }
        this.conversationDB.updateMessages(updatedMessages);
    }

    @Override
    public void deleteConversations(long userLocalId) {
        if (userLocalId > 0L) {
            this.conversationDB.deleteConversations(userLocalId);
        }
    }

    @Override
    public String getOldestMessageCursor(long userLocalId) {
        return this.conversationDB.getOldestMessageCursor(userLocalId);
    }

    @Override
    public Long getOldestConversationCreatedAtTime(long userLocalId) {
        return this.conversationDB.getOldestConversationEpochCreatedAtTime(userLocalId);
    }

    @Override
    public Object getFAQ(String publishId, String language) {
        return this.conversationDB.getAdminFAQSuggestion(publishId, language);
    }

    @Override
    public void insertOrUpdateFAQ(Object faqObj) {
        Faq faq = (Faq)faqObj;
        this.conversationDB.insertOrUpdateAdminFAQSuggestion(faq);
    }

    @Override
    public void removeFAQ(String publishId, String language) {
        this.conversationDB.removeAdminFAQSuggestion(publishId, language);
    }
}

