/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import android.content.Context;
import com.helpshift.common.StringUtils;
import com.helpshift.common.conversation.ConversationDB;
import com.helpshift.common.platform.KVStore;
import com.helpshift.conversation.dao.ConversationInboxDAO;
import com.helpshift.conversation.dao.PushNotificationData;
import com.helpshift.conversation.dto.ConversationDetailDTO;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.dto.dao.ConversationInboxRecord;
import org.json.JSONException;
import org.json.JSONObject;

public class AndroidConversationInboxDAO
implements ConversationInboxDAO {
    private static final String KEY_PUSH_NOTIFICATION_DATA = "push_notification_data";
    private static final String KEY_NOTIFICATION_COUNT = "notification_count";
    private static final String KEY_NOTIFICATION_TITLE = "notification_title";
    private ConversationDB conversationDB;
    private KVStore kvStore;

    public AndroidConversationInboxDAO(Context context, KVStore kvStore) {
        this.conversationDB = ConversationDB.getInstance(context);
        this.kvStore = kvStore;
    }

    private synchronized ConversationInboxRecord.Builder getConversationInboxRecordBuilder(long userLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(userLocalId);
        ConversationInboxRecord.Builder builder = record == null ? new ConversationInboxRecord.Builder(userLocalId) : new ConversationInboxRecord.Builder(record);
        return builder;
    }

    @Override
    public synchronized void saveDescriptionDetail(long userLocalId, ConversationDetailDTO descriptionDetail) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(userLocalId);
        builder.setDescription(descriptionDetail.title);
        builder.setDescriptionTimeStamp(descriptionDetail.timestamp);
        builder.setDescriptionType(descriptionDetail.type);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized ConversationDetailDTO getDescriptionDetail(long userLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(userLocalId);
        ConversationDetailDTO conversationDetailDTO = null;
        if (record != null) {
            String title = record.description;
            long timeStamp = record.descriptionTimeStamp;
            int type = record.descriptionType;
            if (!StringUtils.isEmpty(title)) {
                conversationDetailDTO = new ConversationDetailDTO(title, timeStamp, type);
            }
        }
        return conversationDetailDTO;
    }

    @Override
    public synchronized void saveName(long userLocalId, String name) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(userLocalId);
        builder.setFormName(name);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized String getName(long userLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(userLocalId);
        String result = null;
        if (record != null) {
            result = record.formName;
        }
        return result;
    }

    @Override
    public synchronized void saveEmail(long userLocalId, String email) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(userLocalId);
        builder.setFormEmail(email);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized String getEmail(long userLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(userLocalId);
        String result = null;
        if (record != null) {
            result = record.formEmail;
        }
        return result;
    }

    @Override
    public synchronized void saveImageAttachment(long userLocalId, ImagePickerFile imageAttachment) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(userLocalId);
        builder.setImageAttachmentDraft(imageAttachment);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized ImagePickerFile getImageAttachment(long userLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(userLocalId);
        ImagePickerFile result = null;
        if (record != null) {
            result = record.imageAttachmentDraft;
        }
        return result;
    }

    @Override
    public synchronized void saveConversationInboxTimestamp(long userLocalId, String timestamp) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(userLocalId);
        builder.setLastSyncTimestamp(timestamp);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized String getConversationInboxTimestamp(long userLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(userLocalId);
        String result = null;
        if (record != null) {
            result = record.lastSyncTimestamp;
        }
        return result;
    }

    @Override
    public synchronized void saveConversationArchivalPrefillText(long userLocalId, String prefillText) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(userLocalId);
        builder.setArchivalText(prefillText);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized String getConversationArchivalPrefillText(long userLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(userLocalId);
        String result = null;
        if (record != null) {
            result = record.archivalText;
        }
        return result;
    }

    @Override
    public synchronized void saveUserReplyDraft(long userLocalId, String replyText) {
        if (replyText == null) {
            replyText = "";
        }
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(userLocalId);
        builder.setReplyText(replyText);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized String getUserReplyDraft(long userLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(userLocalId);
        String result = "";
        if (record != null) {
            result = record.replyText;
        }
        return result;
    }

    @Override
    public synchronized boolean getPersistMessageBox(long userLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(userLocalId);
        boolean result = false;
        if (record != null) {
            result = record.persistMessageBox;
        }
        return result;
    }

    @Override
    public synchronized void savePersistMessageBox(long userLocalId, boolean value) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(userLocalId);
        builder.setPersistMessageBox(value);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public PushNotificationData getPushNotificationData(String conversationUniqueId) {
        String serializeData = this.kvStore.getString(KEY_PUSH_NOTIFICATION_DATA);
        if (StringUtils.isEmpty(serializeData)) {
            return null;
        }
        PushNotificationData notificationData = null;
        try {
            JSONObject allNotifications = new JSONObject(serializeData);
            if (allNotifications.has(conversationUniqueId)) {
                JSONObject conversationData = allNotifications.getJSONObject(conversationUniqueId);
                int count = conversationData.getInt(KEY_NOTIFICATION_COUNT);
                String title = conversationData.getString(KEY_NOTIFICATION_TITLE);
                notificationData = new PushNotificationData(count, title);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return notificationData;
    }

    @Override
    public void setPushNotificationData(String conversationUniqueId, PushNotificationData pushNotificationData) {
        String serializeData = this.kvStore.getString(KEY_PUSH_NOTIFICATION_DATA);
        if (StringUtils.isEmpty(serializeData)) {
            serializeData = "{}";
        }
        try {
            JSONObject allNotifications = new JSONObject(serializeData);
            if (pushNotificationData == null) {
                allNotifications.remove(conversationUniqueId);
            } else {
                JSONObject pushData = new JSONObject();
                pushData.put(KEY_NOTIFICATION_COUNT, pushNotificationData.count);
                pushData.put(KEY_NOTIFICATION_TITLE, (Object)pushNotificationData.title);
                allNotifications.put(conversationUniqueId, (Object)pushData);
            }
            this.kvStore.setString(KEY_PUSH_NOTIFICATION_DATA, allNotifications.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public void deleteUserData(long userLocalId) {
        if (userLocalId > 0L) {
            this.conversationDB.deleteConversationInboxData(userLocalId);
        }
    }

    @Override
    public void saveHasOlderMessages(long userLocalId, boolean value) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(userLocalId);
        builder.setHasOlderMessages(value);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public boolean getHasOlderMessages(long userLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(userLocalId);
        boolean result = true;
        if (record != null && record.hasOlderMessages != null) {
            result = record.hasOlderMessages;
        }
        return result;
    }

    @Override
    public void saveLastConversationsRedactionTime(long userLocalId, long conversationsRedactionTime) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(userLocalId);
        builder.setLastConversationsRedactionTime(conversationsRedactionTime);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public Long getLastConversationsRedactionTime(long userLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(userLocalId);
        Long result = null;
        if (record != null) {
            result = record.lastConversationsRedactionTime;
        }
        return result;
    }

    @Override
    public void resetDataAfterConversationsDeletion(long userLocalId) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(userLocalId);
        builder.setHasOlderMessages(true);
        builder.setLastSyncTimestamp(null);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }
}

