/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.text.format.DateFormat;
import android.util.DisplayMetrics;
import com.helpshift.common.StringUtils;
import com.helpshift.common.dao.BackupDAO;
import com.helpshift.common.platform.Device;
import com.helpshift.common.platform.KVStore;
import com.helpshift.meta.dto.DeviceDiskSpaceDTO;
import com.helpshift.support.util.PermissionUtil;
import com.helpshift.util.ApplicationUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public class AndroidDevice
implements Device {
    public static final String KEY_DEVICE_ID = "key_support_device_id";
    private static final String KEY_PUSH_TOKEN = "key_push_token";
    private final Context context;
    private KVStore kvStore;
    private BackupDAO backupDAO;
    private String cacheDeviceId;
    private String cachedPushToken;

    AndroidDevice(Context context, KVStore kvStore, BackupDAO backupDAO) {
        this.context = context;
        this.kvStore = kvStore;
        this.backupDAO = backupDAO;
    }

    @Override
    public String getSDKVersion() {
        return "7.5.0";
    }

    @Override
    public String getPlatformName() {
        return "Android";
    }

    @Override
    public String getOSVersion() {
        return Build.VERSION.RELEASE;
    }

    @Override
    public int getOSVersionNumber() {
        return Build.VERSION.SDK_INT;
    }

    @Override
    public String getAppVersion() {
        return ApplicationUtil.getApplicationVersion(this.context);
    }

    @Override
    public String getAppName() {
        return ApplicationUtil.getApplicationName(this.context);
    }

    @Override
    public String getAppIdentifier() {
        return this.context.getPackageName();
    }

    @Override
    public String getLanguage() {
        return Locale.getDefault().toString();
    }

    @Override
    public String getDeviceModel() {
        return Build.MODEL;
    }

    @Override
    public String getRom() {
        return System.getProperty("os.version") + ":" + Build.FINGERPRINT;
    }

    @Override
    public String getSimCountryIso() {
        TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
        return tm == null ? "" : tm.getSimCountryIso();
    }

    @Override
    public String getTimeStamp() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH).format(new Date());
    }

    @Override
    public String getCarrierName() {
        TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
        return tm == null ? "" : tm.getNetworkOperatorName();
    }

    @Override
    public String getNetworkType() {
        String type = null;
        try {
            NetworkInfo ani;
            ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
            if (cm != null && (ani = cm.getActiveNetworkInfo()) != null) {
                type = ani.getTypeName();
            }
        }
        catch (SecurityException e) {
            type = null;
        }
        if (type == null) {
            type = "Unknown";
        }
        return type;
    }

    @Override
    public String getBatteryStatus() {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = this.context.registerReceiver(null, filter);
        if (batteryStatus == null) {
            return "Not charging";
        }
        int status = batteryStatus.getIntExtra("status", -1);
        boolean isCharging = status == 2 || status == 5;
        return isCharging ? "Charging" : "Not charging";
    }

    @Override
    public String getBatteryLevel() {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = this.context.registerReceiver(null, filter);
        if (batteryStatus == null) {
            return "";
        }
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        int batteryPct = (int)((float)level / (float)scale * 100.0f);
        return batteryPct + "%";
    }

    @Override
    public DeviceDiskSpaceDTO getDiskSpace() {
        double total_phone_memory;
        double free_phone_memory;
        double bytesInOneGB = 1.073741824E9;
        StatFs phoneStat = new StatFs(Environment.getDataDirectory().getPath());
        if (Build.VERSION.SDK_INT >= 18) {
            free_phone_memory = (double)phoneStat.getAvailableBlocksLong() * (double)phoneStat.getBlockSizeLong() / bytesInOneGB;
            free_phone_memory = (double)Math.round(free_phone_memory * 100.0) / 100.0;
            total_phone_memory = (double)phoneStat.getBlockCountLong() * (double)phoneStat.getBlockSizeLong() / bytesInOneGB;
            total_phone_memory = (double)Math.round(total_phone_memory * 100.0) / 100.0;
        } else {
            free_phone_memory = (double)phoneStat.getAvailableBlocks() * (double)phoneStat.getBlockSize() / bytesInOneGB;
            free_phone_memory = (double)Math.round(free_phone_memory * 100.0) / 100.0;
            total_phone_memory = (double)phoneStat.getBlockCount() * (double)phoneStat.getBlockSize() / bytesInOneGB;
            total_phone_memory = (double)Math.round(total_phone_memory * 100.0) / 100.0;
        }
        return new DeviceDiskSpaceDTO(total_phone_memory + " GB", free_phone_memory + " GB", null, null);
    }

    @Override
    public String getApiVersion() {
        return "3";
    }

    @Override
    public Device.PermissionState checkPermission(Device.PermissionType permission2) {
        Device.PermissionState permissionState = null;
        switch (permission2) {
            case READ_STORAGE: {
                permissionState = this.checkStoragePermissions("android.permission.READ_EXTERNAL_STORAGE");
                break;
            }
            case WRITE_STORAGE: {
                permissionState = this.checkStoragePermissions("android.permission.WRITE_EXTERNAL_STORAGE");
            }
        }
        return permissionState;
    }

    @Override
    public Locale getLocale() {
        Resources resources = this.context.getResources();
        Configuration configuration = resources.getConfiguration();
        if (Build.VERSION.SDK_INT >= 24) {
            return configuration.getLocales().get(0);
        }
        return configuration.locale;
    }

    @Override
    public void changeLocale(Locale locale) {
        Resources resources = this.context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Configuration configuration = resources.getConfiguration();
        configuration.locale = locale;
        resources.updateConfiguration(configuration, displayMetrics);
    }

    @Override
    public boolean is24HourFormat() {
        return DateFormat.is24HourFormat((Context)this.context);
    }

    @Override
    public String getTimeZoneId() {
        return TimeZone.getDefault().getID();
    }

    @Override
    public long getTimeZoneOffSet() {
        GregorianCalendar calendar = new GregorianCalendar();
        TimeZone timeZone = ((Calendar)calendar).getTimeZone();
        return timeZone.getRawOffset() + timeZone.getDSTSavings();
    }

    @Override
    public String getDeviceId() {
        if (this.cacheDeviceId != null) {
            return this.cacheDeviceId;
        }
        this.cacheDeviceId = this.kvStore.getString(KEY_DEVICE_ID);
        if (StringUtils.isEmpty(this.cacheDeviceId)) {
            this.cacheDeviceId = (String)((Object)this.backupDAO.getValue(KEY_DEVICE_ID));
            if (!StringUtils.isEmpty(this.cacheDeviceId)) {
                this.kvStore.setString(KEY_DEVICE_ID, this.cacheDeviceId);
            }
        } else {
            this.backupDAO.storeValue(KEY_DEVICE_ID, (Serializable)((Object)this.cacheDeviceId));
        }
        if (StringUtils.isEmpty(this.cacheDeviceId)) {
            this.cacheDeviceId = UUID.randomUUID().toString();
            this.kvStore.setString(KEY_DEVICE_ID, this.cacheDeviceId);
            this.backupDAO.storeValue(KEY_DEVICE_ID, (Serializable)((Object)this.cacheDeviceId));
        }
        return this.cacheDeviceId;
    }

    @Override
    public String getPushToken() {
        if (this.cachedPushToken == null) {
            this.cachedPushToken = this.kvStore.getString(KEY_PUSH_TOKEN);
        }
        return this.cachedPushToken;
    }

    @Override
    public void setPushToken(String pushToken) {
        this.kvStore.setString(KEY_PUSH_TOKEN, pushToken);
        this.cachedPushToken = pushToken;
    }

    void updateDeviceIdInBackupDAO() {
        String kvDeviceId = this.kvStore.getString(KEY_DEVICE_ID);
        if (!StringUtils.isEmpty(kvDeviceId)) {
            this.backupDAO.storeValue(KEY_DEVICE_ID, (Serializable)((Object)kvDeviceId));
        }
    }

    private Device.PermissionState checkStoragePermissions(String permission2) {
        boolean hasPermissionInManifest;
        int osVersion = this.getOSVersionNumber();
        Device.PermissionState permissionState = osVersion < 19 ? Device.PermissionState.AVAILABLE : (ApplicationUtil.isPermissionGranted(this.context, permission2) ? Device.PermissionState.AVAILABLE : (osVersion < 23 ? Device.PermissionState.UNAVAILABLE : ((hasPermissionInManifest = PermissionUtil.hasPermissionInManifest(this.context, permission2)) ? Device.PermissionState.REQUESTABLE : Device.PermissionState.UNAVAILABLE)));
        return permissionState;
    }
}

