/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import com.helpshift.common.platform.KVStore;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import com.helpshift.util.HSLogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AndroidNetworkRequestDAO
implements NetworkRequestDAO {
    public static final String KEY_SERVER_TIME_DELTA = "server_time_delta";
    private static final String KEY_ROUTE_ETAG_MAP = "route_etag_map";
    private static final String KEY_IDEMPOTENT_REQUEST_ID_PREFIX = "idempotent_";
    private Set<String> successfulRequestIds;
    private KVStore kvStore;

    public AndroidNetworkRequestDAO(KVStore kvStore) {
        this.kvStore = kvStore;
        this.successfulRequestIds = new HashSet<String>();
    }

    @Override
    public void storeServerTimeDelta(float timeDelta) {
        this.kvStore.setFloat(KEY_SERVER_TIME_DELTA, Float.valueOf(timeDelta));
        HSLogger.updateTimeStampDelta(timeDelta);
    }

    @Override
    public float getServerTimeDelta() {
        return this.kvStore.getFloat(KEY_SERVER_TIME_DELTA, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void storeETag(String route, String eTag) {
        Object fromKVStore = this.kvStore.getSerializable(KEY_ROUTE_ETAG_MAP);
        HashMap<String, String> mapToStore = fromKVStore == null ? new HashMap<String, String>() : (HashMap<String, String>)fromKVStore;
        mapToStore.put(route, eTag);
        this.kvStore.setSerializable(KEY_ROUTE_ETAG_MAP, mapToStore);
    }

    @Override
    public void removeETag(String route) {
        HashMap mapToStore;
        if (route == null) {
            return;
        }
        Object fromKVStore = this.kvStore.getSerializable(KEY_ROUTE_ETAG_MAP);
        if (fromKVStore != null && (mapToStore = (HashMap)fromKVStore).containsKey(route)) {
            mapToStore.remove(route);
            this.kvStore.setSerializable(KEY_ROUTE_ETAG_MAP, mapToStore);
        }
    }

    @Override
    public String getETag(String route) {
        Object fromKVStore = this.kvStore.getSerializable(KEY_ROUTE_ETAG_MAP);
        if (fromKVStore == null) {
            return null;
        }
        HashMap routeEtagMap = (HashMap)fromKVStore;
        return (String)routeEtagMap.get(route);
    }

    @Override
    public void storePendingRequestId(String route, String uniqueMappingKey, String requestId) {
        String storageKey = KEY_IDEMPOTENT_REQUEST_ID_PREFIX + route;
        Object fromKVStore = this.kvStore.getSerializable(storageKey);
        HashMap<String, String> mapToStore = fromKVStore == null ? new HashMap<String, String>() : (HashMap<String, String>)fromKVStore;
        mapToStore.put(uniqueMappingKey, requestId);
        this.kvStore.setSerializable(storageKey, mapToStore);
    }

    @Override
    public void deletePendingRequestId(String route, String uniqueMappingKey) {
        String storageKey = KEY_IDEMPOTENT_REQUEST_ID_PREFIX + route;
        Object fromKVStore = this.kvStore.getSerializable(storageKey);
        if (fromKVStore instanceof HashMap) {
            HashMap mapToStore = (HashMap)fromKVStore;
            mapToStore.remove(uniqueMappingKey);
            this.kvStore.setSerializable(storageKey, mapToStore);
        }
    }

    @Override
    public String getPendingRequestId(String route, String uniqueMappingKey) {
        Object fromKVStore = this.kvStore.getSerializable(KEY_IDEMPOTENT_REQUEST_ID_PREFIX + route);
        if (fromKVStore == null) {
            return null;
        }
        HashMap requestIdMap = (HashMap)fromKVStore;
        return (String)requestIdMap.get(uniqueMappingKey);
    }

    @Override
    public Map<String, String> getPendingRequestIdMapForRoute(String route) {
        Object fromKVStore = this.kvStore.getSerializable(KEY_IDEMPOTENT_REQUEST_ID_PREFIX + route);
        if (fromKVStore == null) {
            return null;
        }
        return (HashMap)fromKVStore;
    }

    @Override
    public void storeSuccessfulRequestId(String requestId) {
        this.successfulRequestIds.add(requestId);
    }

    @Override
    public Set<String> getAllSuccessfulRequestIds() {
        return this.successfulRequestIds;
    }

    @Override
    public void clearSuccessfulRequestIds() {
        this.successfulRequestIds.clear();
    }
}

