/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import android.app.Notification;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.NotificationCompat;
import com.helpshift.R;
import com.helpshift.account.dao.AndroidClearedUserDAO;
import com.helpshift.account.dao.AndroidLegacyAnalyticsEventIDDAO;
import com.helpshift.account.dao.AndroidLegacyProfileMigrationDAO;
import com.helpshift.account.dao.AndroidRedactionDAO;
import com.helpshift.account.dao.AndroidUserDAO;
import com.helpshift.account.dao.AndroidUserManagerDAO;
import com.helpshift.account.dao.ClearedUserDAO;
import com.helpshift.account.dao.UserDAO;
import com.helpshift.account.dao.UserDB;
import com.helpshift.account.dao.UserManagerDAO;
import com.helpshift.analytics.AnalyticsEventDAO;
import com.helpshift.cif.dao.CustomIssueFieldDAO;
import com.helpshift.common.dao.BackupDAO;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.Threader;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.AndroidBackupDAO;
import com.helpshift.common.platform.AndroidConversationDAO;
import com.helpshift.common.platform.AndroidConversationInboxDAO;
import com.helpshift.common.platform.AndroidCustomIssueFieldDAO;
import com.helpshift.common.platform.AndroidDevice;
import com.helpshift.common.platform.AndroidFAQSearchDM;
import com.helpshift.common.platform.AndroidFaqEventDAO;
import com.helpshift.common.platform.AndroidHTTPTransport;
import com.helpshift.common.platform.AndroidJsonifier;
import com.helpshift.common.platform.AndroidMetadataDAO;
import com.helpshift.common.platform.AndroidNetworkRequestDAO;
import com.helpshift.common.platform.AndroidResponseParser;
import com.helpshift.common.platform.AndroidSupportDownloader;
import com.helpshift.common.platform.Device;
import com.helpshift.common.platform.Jsonifier;
import com.helpshift.common.platform.KVStore;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.HTTPTransport;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.conversation.dao.ConversationDAO;
import com.helpshift.conversation.dao.ConversationInboxDAO;
import com.helpshift.conversation.dao.FAQSuggestionsDAO;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.downloader.SupportDownloader;
import com.helpshift.faq.dao.FaqEventDAO;
import com.helpshift.faq.domainmodel.FAQSearchDM;
import com.helpshift.meta.dao.MetaDataDAO;
import com.helpshift.migration.LegacyAnalyticsEventIDDAO;
import com.helpshift.migration.LegacyProfileMigrationDAO;
import com.helpshift.notifications.NotificationChannelsManager;
import com.helpshift.providers.CrossModuleDataProvider;
import com.helpshift.providers.ICampaignsModuleAPIs;
import com.helpshift.redaction.RedactionDAO;
import com.helpshift.support.HSApiData;
import com.helpshift.support.storage.AndroidAnalyticsEventDAO;
import com.helpshift.support.storage.SupportKeyValueDBStorage;
import com.helpshift.support.util.AttachmentUtil;
import com.helpshift.support.util.SupportNotification;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.FileUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftConnectionUtil;
import java.io.IOException;

public class AndroidPlatform
implements Platform {
    private static final String TAG = "AndroidPlatform";
    private final Context context;
    private String apiKey;
    private String domain;
    private String appId;
    private HSApiData data;
    private KVStore storage;
    private Device device;
    private NetworkRequestDAO networkRequestDAO;
    private MetaDataDAO metaDataDAO;
    private ConversationDAO conversationDAO;
    private ConversationInboxDAO conversationInboxDAO;
    private AnalyticsEventDAO analyticsEventDAO;
    private CustomIssueFieldDAO customIssueFieldDAO;
    private BackupDAO backupDAO;
    private FaqEventDAO faqEventDAO;
    private FAQSearchDM faqSearchDM;
    private Threader uiThreader;
    private SupportDownloader downloader;
    private Context uiContext;
    private Jsonifier jsonifier;
    private AndroidUserManagerDAO userManagerDAO;
    private UserDAO userDAO;
    private ClearedUserDAO clearedUserDAO;
    private LegacyProfileMigrationDAO legacyProfileMigrationDAO;
    private LegacyAnalyticsEventIDDAO legacyAnalyticsEventIDDAO;
    private RedactionDAO redactionDAO;

    public AndroidPlatform(Context context, String apiKey, String domain, String appId) {
        this.context = context;
        this.apiKey = apiKey;
        this.domain = domain;
        this.appId = appId;
    }

    @Override
    public String getAPIKey() {
        return this.apiKey;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Device getDevice() {
        if (this.device == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.device == null) {
                    AndroidDevice androidDevice = new AndroidDevice(this.context, this.getKVStore(), this.getBackupDAO());
                    androidDevice.updateDeviceIdInBackupDAO();
                    this.device = androidDevice;
                }
            }
        }
        return this.device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConversationInboxDAO getConversationInboxDAO() {
        if (this.conversationInboxDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.conversationInboxDAO == null) {
                    this.conversationInboxDAO = new AndroidConversationInboxDAO(this.context, this.getKVStore());
                }
            }
        }
        return this.conversationInboxDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConversationDAO getConversationDAO() {
        if (this.conversationDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.conversationDAO == null) {
                    this.conversationDAO = new AndroidConversationDAO(this.context);
                }
            }
        }
        return this.conversationDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FAQSuggestionsDAO getFAQSuggestionsDAO() {
        if (this.conversationDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.conversationDAO == null) {
                    this.conversationDAO = new AndroidConversationDAO(this.context);
                }
            }
        }
        return (FAQSuggestionsDAO)((Object)this.conversationDAO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaDataDAO getMetaDataDAO() {
        if (this.metaDataDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.metaDataDAO == null) {
                    this.metaDataDAO = new AndroidMetadataDAO(this.getKVStore());
                }
            }
        }
        return this.metaDataDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyticsEventDAO getAnalyticsEventDAO() {
        if (this.analyticsEventDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.analyticsEventDAO == null) {
                    this.analyticsEventDAO = new AndroidAnalyticsEventDAO(this.getKVStore());
                }
            }
        }
        return this.analyticsEventDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomIssueFieldDAO getCustomIssueFieldDAO() {
        if (this.customIssueFieldDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.customIssueFieldDAO == null) {
                    this.customIssueFieldDAO = new AndroidCustomIssueFieldDAO(this.getKVStore());
                }
            }
        }
        return this.customIssueFieldDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BackupDAO getBackupDAO() {
        if (this.backupDAO != null) return this.backupDAO;
        Class<AndroidPlatform> clazz = AndroidPlatform.class;
        synchronized (AndroidPlatform.class) {
            if (this.backupDAO != null) return this.backupDAO;
            this.backupDAO = new AndroidBackupDAO();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.backupDAO;
        }
    }

    @Override
    public ResponseParser getResponseParser() {
        return new AndroidResponseParser();
    }

    @Override
    public HTTPTransport getHTTPTransport() {
        return new AndroidHTTPTransport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FAQSearchDM getFAQSearchDM() {
        if (this.faqSearchDM == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.faqSearchDM == null) {
                    this.faqSearchDM = new AndroidFAQSearchDM(this.getData());
                }
            }
        }
        return this.faqSearchDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KVStore getKVStore() {
        if (this.storage == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.storage == null) {
                    this.storage = new SupportKeyValueDBStorage(this.context);
                }
            }
        }
        return this.storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Jsonifier getJsonifier() {
        if (this.jsonifier == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.jsonifier == null) {
                    this.jsonifier = new AndroidJsonifier();
                }
            }
        }
        return this.jsonifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserManagerDAO getUserManagerDAO() {
        if (this.userManagerDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.userManagerDAO == null) {
                    this.userManagerDAO = new AndroidUserManagerDAO(this.getKVStore());
                }
            }
        }
        return this.userManagerDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDAO getUserDAO() {
        if (this.userDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.userDAO == null) {
                    this.userDAO = new AndroidUserDAO(UserDB.getInstance(this.context));
                }
            }
        }
        return this.userDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClearedUserDAO getClearedUserDAO() {
        if (this.clearedUserDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.clearedUserDAO == null) {
                    this.clearedUserDAO = new AndroidClearedUserDAO(UserDB.getInstance(this.context));
                }
            }
        }
        return this.clearedUserDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkRequestDAO getNetworkRequestDAO() {
        if (this.networkRequestDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.networkRequestDAO == null) {
                    this.networkRequestDAO = new AndroidNetworkRequestDAO(this.getKVStore());
                }
            }
        }
        return this.networkRequestDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FaqEventDAO getFaqEventDAO() {
        if (this.faqEventDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.faqEventDAO == null) {
                    this.faqEventDAO = new AndroidFaqEventDAO(this.getKVStore());
                }
            }
        }
        return this.faqEventDAO;
    }

    @Override
    public boolean isCurrentThreadUIThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Threader getUIThreader() {
        if (this.uiThreader == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.uiThreader == null) {
                    this.uiThreader = new Threader(){

                        @Override
                        public F thread(final F f) {
                            return new F(){

                                @Override
                                public void f() {
                                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                                        @Override
                                        public void run() {
                                            f.f();
                                        }
                                    });
                                }
                            };
                        }
                    };
                }
            }
        }
        return this.uiThreader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SupportDownloader getDownloader() {
        if (this.downloader == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.downloader == null) {
                    this.downloader = new AndroidSupportDownloader(this.context, this.getKVStore());
                }
            }
        }
        return this.downloader;
    }

    @Override
    public boolean isSupportedMimeType(String mimeType) {
        return FileUtil.isSupportedMimeType(mimeType);
    }

    @Override
    public String getMimeTypeForFile(String fileLocation) {
        return FileUtil.getMimeType(fileLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String compressAndStoreScreenshot(String imageUri, String id) {
        String newFileLocation = null;
        try {
            newFileLocation = AttachmentUtil.copyAttachment(imageUri, id);
        }
        catch (IOException e) {
            HSLogger.d(TAG, "Saving attachment", e);
        }
        finally {
            if (newFileLocation == null) {
                newFileLocation = imageUri;
            }
        }
        return newFileLocation;
    }

    @Override
    public void compressAndCopyScreenshot(ImagePickerFile imagePickerFile, String refersId) throws RootAPIException {
        try {
            AttachmentUtil.copyAttachment(imagePickerFile, refersId);
        }
        catch (Exception e) {
            throw RootAPIException.wrap(e);
        }
    }

    @Override
    public int getMinimumConversationDescriptionLength() {
        Context localContext = this.uiContext != null ? this.uiContext : this.context;
        return localContext.getResources().getInteger(R.integer.hs__issue_description_min_chars);
    }

    @Override
    public void showNotification(Long conversationLocalId, String conversationLocalUUID, int messageCount, String contentTitle) {
        Context localContext = this.uiContext != null ? this.uiContext : ApplicationUtil.getContextWithUpdatedLocale(this.context);
        NotificationCompat.Builder notificationBuilder = SupportNotification.createNotification(localContext, conversationLocalId, conversationLocalUUID, messageCount, contentTitle);
        if (notificationBuilder != null) {
            Notification notification = notificationBuilder.build();
            NotificationChannelsManager notificationChannelsManager = new NotificationChannelsManager(this.context);
            notification = notificationChannelsManager.attachChannelId(notification, NotificationChannelsManager.NotificationChannelType.SUPPORT);
            ApplicationUtil.showNotification(this.context, conversationLocalUUID, notification);
        }
    }

    @Override
    public void clearNotifications(String conversationUniqueId) {
        ApplicationUtil.cancelNotification(this.context, conversationUniqueId, 1);
    }

    @Override
    public ICampaignsModuleAPIs getCampaignModuleAPIs() {
        return CrossModuleDataProvider.getCampaignModuleAPIs();
    }

    @Override
    public boolean isOnline() {
        return HelpshiftConnectionUtil.isOnline(this.context);
    }

    @Override
    public void setUIContext(Object context) {
        if (context == null) {
            this.uiContext = null;
        } else if (context instanceof Context) {
            this.uiContext = (Context)context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LegacyProfileMigrationDAO getLegacyUserMigrationDataSource() {
        if (this.legacyProfileMigrationDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.legacyProfileMigrationDAO == null) {
                    this.legacyProfileMigrationDAO = new AndroidLegacyProfileMigrationDAO(UserDB.getInstance(this.context));
                }
            }
        }
        return this.legacyProfileMigrationDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LegacyAnalyticsEventIDDAO getLegacyAnalyticsEventIDDAO() {
        if (this.legacyAnalyticsEventIDDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.legacyAnalyticsEventIDDAO == null) {
                    this.legacyAnalyticsEventIDDAO = new AndroidLegacyAnalyticsEventIDDAO(UserDB.getInstance(this.context));
                }
            }
        }
        return this.legacyAnalyticsEventIDDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RedactionDAO getRedactionDAO() {
        if (this.redactionDAO == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.redactionDAO == null) {
                    this.redactionDAO = new AndroidRedactionDAO(UserDB.getInstance(this.context));
                }
            }
        }
        return this.redactionDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HSApiData getData() {
        if (this.data == null) {
            AndroidPlatform androidPlatform = this;
            synchronized (androidPlatform) {
                if (this.data == null) {
                    this.data = new HSApiData(this.context);
                }
            }
        }
        return this.data;
    }
}

