/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import com.helpshift.auth.dto.WebSocketAuthData;
import com.helpshift.common.exception.ParseException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.configuration.response.PeriodicReview;
import com.helpshift.configuration.response.RootServerConfig;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.message.AcceptedAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminBotControlMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageWithOptionInputDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageWithTextInputDM;
import com.helpshift.conversation.activeconversation.message.AttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.ConfirmationAcceptedMessageDM;
import com.helpshift.conversation.activeconversation.message.ConfirmationRejectedMessageDM;
import com.helpshift.conversation.activeconversation.message.FAQListMessageDM;
import com.helpshift.conversation.activeconversation.message.FAQListMessageWithOptionInputDM;
import com.helpshift.conversation.activeconversation.message.FollowupAcceptedMessageDM;
import com.helpshift.conversation.activeconversation.message.FollowupRejectedMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestForReopenMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.UnsupportedAdminMessageWithInputDM;
import com.helpshift.conversation.activeconversation.message.UserBotControlMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageDM;
import com.helpshift.conversation.activeconversation.message.UserResponseMessageForOptionInput;
import com.helpshift.conversation.activeconversation.message.UserResponseMessageForTextInputDM;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import com.helpshift.conversation.dto.ConversationHistory;
import com.helpshift.conversation.dto.ConversationInbox;
import com.helpshift.conversation.dto.IssueState;
import com.helpshift.conversation.dto.WSPingMessage;
import com.helpshift.conversation.dto.WSTypingActionMessage;
import com.helpshift.conversation.dto.WebSocketMessage;
import com.helpshift.conversation.states.ConversationCSATState;
import com.helpshift.faq.FaqCore;
import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HSLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AndroidResponseParser
implements ResponseParser {
    private static final String TAG = "Helpshift_AResponseParser";
    private static final int OPTIONS_MAX_LIMIT = 500;

    AndroidResponseParser() {
    }

    @Override
    public UserMessageDM parseReadableUserMessage(String responseString) {
        try {
            JSONObject messageObj = new JSONObject(responseString);
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            UserMessageDM messageDM = new UserMessageDM(messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"));
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            messageDM.isRedacted = messageObj.optBoolean("redacted", false);
            this.parseAndSetDataForUserSentMessages(messageDM, messageObj);
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading user text message");
        }
    }

    @Override
    public UserResponseMessageForTextInputDM parseResponseMessageForTextInput(String responseString) {
        try {
            JSONObject messageObj = new JSONObject(responseString);
            String type = messageObj.getString("type");
            int keyboard = 1;
            boolean isMessageEmpty = false;
            switch (type) {
                case "rsp_empty_msg_with_txt_input": {
                    isMessageEmpty = true;
                    break;
                }
                case "rsp_txt_msg_with_txt_input": {
                    keyboard = 1;
                    break;
                }
                case "rsp_txt_msg_with_email_input": {
                    keyboard = 2;
                    break;
                }
                case "rsp_txt_msg_with_numeric_input": {
                    keyboard = 3;
                    break;
                }
                case "rsp_txt_msg_with_dt_input": {
                    keyboard = 4;
                    break;
                }
                default: {
                    return null;
                }
            }
            boolean skipped = !isMessageEmpty && messageObj.getBoolean("skipped");
            JSONObject meta = messageObj.getJSONObject("meta");
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            UserResponseMessageForTextInputDM result = new UserResponseMessageForTextInputDM(messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), keyboard, messageObj.getJSONObject("chatbot_info").toString(), skipped, meta.getString("refers"), isMessageEmpty);
            if (keyboard == 4 && !skipped) {
                result.dateInMillis = meta.getLong("dt");
                result.timeZoneId = meta.optString("timezone");
            }
            result.serverId = messageObj.getString("id");
            result.isRedacted = messageObj.optBoolean("redacted", false);
            this.parseAndSetDataForUserSentMessages(result, messageObj);
            return result;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading user response for text input");
        }
    }

    @Override
    public ScreenshotMessageDM parseScreenshotMessageDM(String response) {
        try {
            JSONObject responseObj = new JSONObject(response);
            return this.parseScreenshotMessageDM(responseObj);
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading reopen message");
        }
    }

    @Override
    public AcceptedAppReviewMessageDM parseAcceptedAppReviewMessageDM(String response) {
        try {
            JSONObject messageObj = new JSONObject(response);
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            AcceptedAppReviewMessageDM messageDM = new AcceptedAppReviewMessageDM(messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), messageObj.getJSONObject("meta").getString("refers"), 2);
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            messageDM.isRedacted = messageObj.optBoolean("redacted", false);
            this.parseAndSetDataForUserSentMessages(messageDM, messageObj);
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading accepted review message");
        }
    }

    @Override
    public ConfirmationAcceptedMessageDM parseConfirmationAcceptedMessageDM(String response) {
        try {
            JSONObject messageObj = new JSONObject(response);
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            ConfirmationAcceptedMessageDM messageDM = new ConfirmationAcceptedMessageDM(messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), 2);
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            messageDM.isRedacted = messageObj.optBoolean("redacted", false);
            this.parseAndSetDataForUserSentMessages(messageDM, messageObj);
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading confirmation accepted message");
        }
    }

    @Override
    public ConfirmationRejectedMessageDM parseConfirmationRejectedMessageDM(String response) {
        try {
            JSONObject messageObj = new JSONObject(response);
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            ConfirmationRejectedMessageDM messageDM = new ConfirmationRejectedMessageDM(messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), 2);
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            messageDM.isRedacted = messageObj.optBoolean("redacted", false);
            this.parseAndSetDataForUserSentMessages(messageDM, messageObj);
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading confirmation rejected message");
        }
    }

    @Override
    public ConversationInbox parseConversationInbox(String response) {
        try {
            JSONObject responseObj = new JSONObject(response);
            ArrayList<ConversationDM> conversations = new ArrayList<ConversationDM>();
            JSONArray conversationObjs = responseObj.getJSONArray("issues");
            for (int i = 0; i < conversationObjs.length(); ++i) {
                conversations.add(this.parseReadableConversation(conversationObjs.getJSONObject(i).toString()));
            }
            Boolean hasOlderMessages = null;
            if (responseObj.has("has_older_messages")) {
                hasOlderMessages = responseObj.getBoolean("has_older_messages");
            }
            String cursor = responseObj.getString("cursor");
            boolean issueExists = responseObj.getBoolean("issue_exists");
            return new ConversationInbox(cursor, conversations, issueExists, hasOlderMessages);
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading conversation inbox");
        }
    }

    @Override
    public ConversationHistory parseConversationHistory(String response) {
        try {
            JSONObject responseObj = new JSONObject(response);
            ArrayList<ConversationDM> conversations = new ArrayList<ConversationDM>();
            JSONArray conversationObjs = responseObj.getJSONArray("issues");
            for (int i = 0; i < conversationObjs.length(); ++i) {
                conversations.add(this.parseReadableConversation(conversationObjs.getJSONObject(i).toString()));
            }
            boolean hasOlderMessages = responseObj.getBoolean("has_older_messages");
            return new ConversationHistory(conversations, hasOlderMessages);
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading conversation history");
        }
    }

    @Override
    public FollowupRejectedMessageDM parseFollowupRejectedMessage(String response) {
        try {
            JSONObject responseObj = new JSONObject(response);
            return this.parseFollowupRejectedMessageDM(responseObj);
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading follow-up rejected message");
        }
    }

    @Override
    public FollowupAcceptedMessageDM parseFollowupAcceptedMessage(String response) {
        try {
            JSONObject responseObj = new JSONObject(response);
            return this.parseFollowupAcceptedMessageDM(responseObj);
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading follow-up accepted message");
        }
    }

    @Override
    public WebSocketAuthData parseAuthToken(String response) {
        WebSocketAuthData returnAuthData = null;
        try {
            JSONObject responseObj = new JSONObject(response);
            String authToken = responseObj.getString("token");
            String webSocketRoute = responseObj.getString("endpoint");
            returnAuthData = new WebSocketAuthData(authToken, webSocketRoute);
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "Exception in parsing auth token", e);
        }
        return returnAuthData;
    }

    @Override
    public WebSocketMessage parseWebSocketMessage(String response) {
        WebSocketMessage returnMessage = null;
        try {
            JSONArray array = new JSONArray(response);
            int messageType = array.getInt(0);
            switch (messageType) {
                case 107: {
                    long pingWaitTime = TimeUnit.SECONDS.toMillis(array.getLong(1));
                    returnMessage = new WSPingMessage(pingWaitTime);
                    break;
                }
                case 100: {
                    JSONArray actionArray = array.getJSONArray(2);
                    for (int i = 0; i < actionArray.length(); ++i) {
                        JSONObject message = actionArray.getJSONObject(i);
                        JSONObject messageData = new JSONObject(message.getString("m"));
                        String stream = messageData.getString("stream");
                        if (!"agent_type_activity".equals(stream)) continue;
                        String action = messageData.getString("action");
                        if ("start".equals(action)) {
                            long typingActionTimeout = TimeUnit.SECONDS.toMillis(messageData.getLong("ttl"));
                            returnMessage = new WSTypingActionMessage(true, typingActionTimeout);
                            continue;
                        }
                        if (!"stop".equals(action)) continue;
                        returnMessage = new WSTypingActionMessage(false, 0L);
                    }
                    break;
                }
            }
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "Exception in parsing web-socket message", e);
        }
        return returnMessage;
    }

    private boolean parseDisableHelpshiftBrandingValue(JSONObject jsonObject) {
        boolean disableHelpshiftBranding = false;
        if (jsonObject != null) {
            String hl = jsonObject.optString("hl", "true");
            disableHelpshiftBranding = !hl.equals("true");
        }
        return disableHelpshiftBranding;
    }

    private List<MessageDM> parseMessageDMs(JSONArray messagesObj) {
        ArrayList<MessageDM> messageDMs = new ArrayList<MessageDM>();
        int size = messagesObj.length();
        for (int i = 0; i < size; ++i) {
            try {
                JSONObject messageObj = messagesObj.getJSONObject(i);
                String type = messageObj.getString("type");
                String origin = messageObj.getString("origin");
                if ("admin".equals(origin)) {
                    this.parseAdminMessage(type, messageObj, messageDMs);
                    continue;
                }
                if ("mobile".equals(origin)) {
                    this.parseMobileMessage(type, messageObj, messageDMs);
                    continue;
                }
                HSLogger.e(TAG, "Unknown message type received.");
                continue;
            }
            catch (RootAPIException | JSONException ex) {
                HSLogger.e(TAG, "Exception while parsing messages: ", ex);
            }
        }
        return messageDMs;
    }

    private void parseAdminMessage(String type, JSONObject messageObj, List<MessageDM> messageDMs) {
        try {
            switch (type) {
                case "txt": {
                    messageDMs.addAll(this.parseAdminMessageDM(messageObj));
                    break;
                }
                case "txt_msg_with_txt_input": {
                    messageDMs.add(this.parseAdminMessageWithTextInputDM(messageObj, 1));
                    break;
                }
                case "txt_msg_with_email_input": {
                    messageDMs.add(this.parseAdminMessageWithTextInputDM(messageObj, 2));
                    break;
                }
                case "txt_msg_with_numeric_input": {
                    messageDMs.add(this.parseAdminMessageWithTextInputDM(messageObj, 3));
                    break;
                }
                case "txt_msg_with_dt_input": {
                    messageDMs.add(this.parseAdminMessageWithTextInputDM(messageObj, 4));
                    break;
                }
                case "empty_msg_with_txt_input": {
                    messageDMs.add(this.parseAdminEmptyMessageWithTextInputDM(messageObj));
                    break;
                }
                case "txt_msg_with_option_input": {
                    messageDMs.add(this.parseAdminMessageWithOptionInputDM(messageObj));
                    break;
                }
                case "rar": {
                    messageDMs.add(this.parseRequestAppReviewMessageDM(messageObj));
                    break;
                }
                case "rsc": {
                    messageDMs.addAll(this.parseRequestScreenshotMessageDM(messageObj));
                    break;
                }
                case "rfr": {
                    messageDMs.add(this.parseRequestForReopenMessageDM(messageObj));
                    break;
                }
                case "faq_list": {
                    messageDMs.add(this.parseFAQListMessageDM(messageObj));
                    break;
                }
                case "faq_list_msg_with_option_input": {
                    messageDMs.add(this.parseFAQListMessageWitOptionInputDM(messageObj));
                    break;
                }
                case "bot_started": 
                case "bot_ended": {
                    messageDMs.add(this.parseBotControlMessage(messageObj.toString(), true));
                    break;
                }
                default: {
                    if (messageObj.has("input")) {
                        messageDMs.add(this.parseUnsupportedAdminMessageWithInput(messageObj.toString()));
                    }
                    break;
                }
            }
        }
        catch (RootAPIException ex) {
            HSLogger.e(TAG, "Exception while parsing messages: ", ex);
        }
    }

    private void parseMobileMessage(String type, JSONObject messageObj, List<MessageDM> messageDMs) {
        try {
            switch (type) {
                case "txt": {
                    messageDMs.add(this.parseReadableUserMessage(messageObj.toString()));
                    break;
                }
                case "ar": {
                    messageDMs.add(this.parseAcceptedAppReviewMessageDM(messageObj.toString()));
                    break;
                }
                case "ncr": {
                    messageDMs.add(this.parseConfirmationRejectedMessageDM(messageObj.toString()));
                    break;
                }
                case "ca": {
                    messageDMs.add(this.parseConfirmationAcceptedMessageDM(messageObj.toString()));
                    break;
                }
                case "sc": {
                    messageDMs.add(this.parseScreenshotMessageDM(messageObj));
                    break;
                }
                case "ra": {
                    messageDMs.add(this.parseFollowupAcceptedMessageDM(messageObj));
                    break;
                }
                case "rj": {
                    messageDMs.add(this.parseFollowupRejectedMessageDM(messageObj));
                    break;
                }
                case "rsp_empty_msg_with_txt_input": 
                case "rsp_txt_msg_with_txt_input": 
                case "rsp_txt_msg_with_email_input": 
                case "rsp_txt_msg_with_numeric_input": 
                case "rsp_txt_msg_with_dt_input": {
                    messageDMs.add(this.parseResponseMessageForTextInput(messageObj.toString()));
                    break;
                }
                case "rsp_txt_msg_with_option_input": 
                case "rsp_faq_list_msg_with_option_input": {
                    messageDMs.add(this.parseResponseMessageForOptionInput(messageObj.toString()));
                    break;
                }
                case "bot_cancelled": {
                    messageDMs.add(this.parseBotControlMessage(messageObj.toString(), false));
                }
            }
        }
        catch (RootAPIException ex) {
            HSLogger.e(TAG, "Exception while parsing messages: ", ex);
        }
    }

    @Override
    public MessageDM parseBotControlMessage(String message, boolean isAdminMessage) {
        try {
            JSONObject messageObject = new JSONObject(message);
            String actionType = messageObject.getString("type");
            String serverId = messageObject.getString("id");
            String botInfo = messageObject.getJSONObject("chatbot_info").toString();
            boolean isRedacted = messageObject.optBoolean("redacted", false);
            String createdAt = messageObject.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            if (isAdminMessage) {
                AdminBotControlMessageDM messageDM = new AdminBotControlMessageDM(serverId, messageObject.getString("body"), createdAt, epochCreatedAtTime, messageObject.getJSONObject("author").getString("name"), actionType, botInfo);
                messageDM.hasNextBot = messageObject.optBoolean("has_next_bot", false);
                messageDM.isRedacted = isRedacted;
                return messageDM;
            }
            JSONObject meta = messageObject.getJSONObject("meta");
            String reason = meta.getString("chatbot_cancelled_reason");
            String refersMessageId = meta.getString("refers");
            UserBotControlMessageDM messageDM = new UserBotControlMessageDM(messageObject.getString("body"), createdAt, epochCreatedAtTime, messageObject.getJSONObject("author").getString("name"), actionType, reason, botInfo, refersMessageId, 2);
            messageDM.serverId = serverId;
            messageDM.isRedacted = isRedacted;
            this.parseAndSetDataForUserSentMessages(messageDM, messageObject);
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading bot control messages.");
        }
    }

    private List<FAQListMessageDM.FAQ> parseFAQList(JSONArray actionsArray) throws JSONException {
        ArrayList<FAQListMessageDM.FAQ> result = new ArrayList<FAQListMessageDM.FAQ>();
        for (int i = 0; i < actionsArray.length(); ++i) {
            JSONObject actionObj = actionsArray.getJSONObject(i);
            JSONObject dataObj = actionObj.getJSONObject("data");
            result.add(new FAQListMessageDM.FAQ(actionObj.getString("title"), dataObj.getString("publish_id"), dataObj.getString("language")));
        }
        return result;
    }

    private MessageDM parseFAQListMessageWitOptionInputDM(JSONObject messageObj) {
        try {
            JSONObject input = messageObj.getJSONObject("input");
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            FAQListMessageWithOptionInputDM result = new FAQListMessageWithOptionInputDM(messageObj.getString("id"), messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), this.parseFAQList(messageObj.getJSONArray("faqs")), messageObj.getJSONObject("chatbot_info").toString(), input.getBoolean("required"), input.getString("label"), input.optString("skip_label"), this.parseOptions(input));
            result.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            result.isRedacted = messageObj.optBoolean("redacted", false);
            return result;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading list message with option input");
        }
    }

    private FAQListMessageDM parseFAQListMessageDM(JSONObject messageObj) {
        try {
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            FAQListMessageDM result = new FAQListMessageDM(messageObj.getString("id"), messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), this.parseFAQList(messageObj.getJSONArray("faqs")));
            result.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            result.isRedacted = messageObj.optBoolean("redacted", false);
            return result;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading faq list message");
        }
    }

    private FollowupRejectedMessageDM parseFollowupRejectedMessageDM(JSONObject messageObj) {
        try {
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            FollowupRejectedMessageDM messageDM = new FollowupRejectedMessageDM(messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), messageObj.getJSONObject("meta").getString("refers"), 2);
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            messageDM.isRedacted = messageObj.optBoolean("redacted", false);
            this.parseAndSetDataForUserSentMessages(messageDM, messageObj);
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading follow-up rejected message");
        }
    }

    private FollowupAcceptedMessageDM parseFollowupAcceptedMessageDM(JSONObject messageObj) {
        try {
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            FollowupAcceptedMessageDM messageDM = new FollowupAcceptedMessageDM(messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), messageObj.getJSONObject("meta").getString("refers"), 2);
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            messageDM.isRedacted = messageObj.optBoolean("redacted", false);
            this.parseAndSetDataForUserSentMessages(messageDM, messageObj);
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading follow-up accepted message");
        }
    }

    private RequestForReopenMessageDM parseRequestForReopenMessageDM(JSONObject messageObj) {
        try {
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            RequestForReopenMessageDM messageDM = new RequestForReopenMessageDM(messageObj.getString("id"), messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"));
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            messageDM.isRedacted = messageObj.optBoolean("redacted", false);
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading reopen message");
        }
    }

    private List<OptionInput.Option> parseOptions(JSONObject input) throws JSONException {
        ArrayList<OptionInput.Option> result = new ArrayList<OptionInput.Option>();
        JSONArray optionsArray = input.getJSONArray("options");
        int optionsLimit = Math.min(optionsArray.length(), 500);
        for (int i = 0; i < optionsLimit; ++i) {
            JSONObject optionObj = optionsArray.getJSONObject(i);
            result.add(new OptionInput.Option(optionObj.getString("title"), optionObj.getJSONObject("data").toString()));
        }
        return result;
    }

    private OptionInput.Type parseOptionType(JSONObject input) throws JSONException {
        return OptionInput.Type.getType(input.optString("type"), input.getJSONArray("options").length());
    }

    private MessageDM parseAdminMessageWithOptionInputDM(JSONObject messageObj) {
        try {
            JSONObject input = messageObj.getJSONObject("input");
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            AdminMessageWithOptionInputDM result = new AdminMessageWithOptionInputDM(messageObj.getString("id"), messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), messageObj.getJSONObject("chatbot_info").toString(), input.getBoolean("required"), input.getString("label"), input.optString("skip_label"), this.parseOptions(input), this.parseOptionType(input));
            result.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            result.isRedacted = messageObj.optBoolean("redacted", false);
            return result;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading admin text message with option input");
        }
    }

    @Override
    public UserResponseMessageForOptionInput parseResponseMessageForOptionInput(String responseString) {
        try {
            MessageType refersMessageType;
            String type;
            JSONObject messageObj = new JSONObject(responseString);
            switch (type = messageObj.getString("type")) {
                case "rsp_txt_msg_with_option_input": {
                    refersMessageType = MessageType.ADMIN_TEXT_WITH_OPTION_INPUT;
                    break;
                }
                case "rsp_faq_list_msg_with_option_input": {
                    refersMessageType = MessageType.FAQ_LIST_WITH_OPTION_INPUT;
                    break;
                }
                default: {
                    return null;
                }
            }
            boolean isSkipped = messageObj.getBoolean("skipped");
            String optionData = isSkipped ? "{}" : messageObj.getJSONObject("option_data").toString();
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            UserResponseMessageForOptionInput result = new UserResponseMessageForOptionInput(messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), messageObj.getJSONObject("chatbot_info").toString(), isSkipped, optionData, messageObj.getJSONObject("meta").getString("refers"), refersMessageType);
            result.serverId = messageObj.getString("id");
            result.isRedacted = messageObj.optBoolean("redacted", false);
            this.parseAndSetDataForUserSentMessages(result, messageObj);
            return result;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading user response for option input");
        }
    }

    private AdminMessageWithTextInputDM parseAdminEmptyMessageWithTextInputDM(JSONObject messageObj) {
        try {
            JSONObject input = messageObj.getJSONObject("input");
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            AdminMessageWithTextInputDM result = new AdminMessageWithTextInputDM(messageObj.getString("id"), "", createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), messageObj.getJSONObject("chatbot_info").toString(), input.getString("placeholder"), input.getBoolean("required"), input.getString("label"), input.optString("skip_label"), 1, true);
            result.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            result.isRedacted = messageObj.optBoolean("redacted", false);
            return result;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading admin empty message with text input");
        }
    }

    private AdminMessageWithTextInputDM parseAdminMessageWithTextInputDM(JSONObject messageObj, int keyboard) {
        try {
            JSONObject input = messageObj.getJSONObject("input");
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            AdminMessageWithTextInputDM result = new AdminMessageWithTextInputDM(messageObj.getString("id"), messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), messageObj.getJSONObject("chatbot_info").toString(), input.getString("placeholder"), input.getBoolean("required"), input.getString("label"), input.optString("skip_label"), keyboard, false);
            result.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            result.isRedacted = messageObj.optBoolean("redacted", false);
            return result;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading admin message with text input");
        }
    }

    private List<MessageDM> parseAdminMessageDM(JSONObject messageObj) {
        try {
            ArrayList<MessageDM> result = new ArrayList<MessageDM>();
            JSONArray attachments = messageObj.getJSONObject("meta").optJSONArray("attachments");
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            AdminMessageDM messageDM = new AdminMessageDM(messageObj.getString("id"), messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"));
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            messageDM.isRedacted = messageObj.optBoolean("redacted", false);
            result.add(messageDM);
            if (attachments != null) {
                result.addAll(this.parseAdminAttachmentEntities(messageObj, attachments));
            }
            return result;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading admin text message");
        }
    }

    private UnsupportedAdminMessageWithInputDM parseUnsupportedAdminMessageWithInput(String message) {
        try {
            JSONObject messageObj = new JSONObject(message);
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            return new UnsupportedAdminMessageWithInputDM(messageObj.getString("id"), messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), messageObj.getString("type"), messageObj.getJSONObject("chatbot_info").toString(), messageObj.getJSONObject("input").toString());
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading unsupported admin message with input");
        }
    }

    @Override
    public RootServerConfig parseConfigResponse(String response) {
        try {
            JSONObject config = new JSONObject(response);
            Long lastConversationsRedactionTime = null;
            if (config.has("last_redaction_at")) {
                lastConversationsRedactionTime = config.getLong("last_redaction_at");
            }
            Long profileCreatedAt = null;
            if (config.has("profile_created_at")) {
                profileCreatedAt = config.getLong("profile_created_at");
            }
            Long periodicFetchInterval = config.optLong("pfi", 0L) / 1000L;
            return new RootServerConfig(config.optBoolean("rne", false), config.optBoolean("pfe", true), config.optBoolean("san", true), config.optBoolean("csat", false), config.optBoolean("dia", false), this.parseDisableHelpshiftBrandingValue(config.optJSONObject("t")), config.optBoolean("issue_exists", true), config.optInt("dbgl", 100), config.optInt("bcl", 100), config.optString("rurl", ""), this.parsePeriodicReview(config.getJSONObject("pr")), config.optBoolean("ic", false), config.optString("gm", ""), config.optBoolean("tyi", true), config.optBoolean("rq", true), config.optBoolean("conversation_history_enabled", false), lastConversationsRedactionTime, profileCreatedAt, config.optBoolean("allow_user_attachments", true), this.fetchIntervalWithMinimumDefault(periodicFetchInterval));
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while fetching config");
        }
    }

    @Override
    public ConversationDM parseReadableConversation(String conversationResponse) {
        try {
            String issueType;
            JSONObject resObj = new JSONObject(conversationResponse);
            List<MessageDM> messageDMs = this.parseMessageDMs(resObj.getJSONArray("messages"));
            String messageCursor = null;
            for (int i = messageDMs.size() - 1; i >= 0; --i) {
                MessageDM messageDM = messageDMs.get(i);
                if (messageDM instanceof AdminAttachmentMessageDM || messageDM instanceof AdminImageAttachmentMessageDM) continue;
                messageCursor = messageDM.getCreatedAt();
                break;
            }
            IssueState state = IssueState.fromInt(resObj.getInt("state"));
            String createAt = resObj.getString("created_at");
            long epochCreatedAt = HSDateFormatSpec.convertToEpochTime(createAt);
            ConversationDM conversationDM = new ConversationDM(resObj.optString("title", ""), state, createAt, epochCreatedAt, resObj.getString("updated_at"), resObj.getString("publish_id"), messageCursor, resObj.optBoolean("show-agent-name", true));
            conversationDM.isRedacted = resObj.optBoolean("redacted", false);
            conversationDM.serverId = resObj.isNull("issue_id") ? null : resObj.getString("issue_id");
            conversationDM.preConversationServerId = resObj.isNull("preissue_id") ? null : resObj.getString("preissue_id");
            conversationDM.issueType = issueType = resObj.getString("type");
            conversationDM.createdRequestId = resObj.optString("request_id");
            if ("issue".equals(issueType)) {
                conversationDM.csatState = resObj.optBoolean("csat_received") ? ConversationCSATState.SUBMITTED_SYNCED : ConversationCSATState.NONE;
            }
            conversationDM.setMessageDMs(messageDMs);
            return conversationDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception in reading conversation");
        }
    }

    @Override
    public FaqCore parseSingleFAQ(String response) {
        try {
            JSONObject question = new JSONObject(response);
            return new FaqCore(question.getString("id"), question.getString("publish_id"), question.getString("language"), question.getString("section_id"), question.getString("title"), question.getString("body"), 0, question.getString("is_rtl") == "true", question.has("stags") ? HSJSONUtils.jsonToStringArrayList(question.getString("stags")) : new ArrayList(), question.has("issue_tags") ? HSJSONUtils.jsonToStringArrayList(question.getString("issue_tags")) : new ArrayList());
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading single faq");
        }
    }

    private List<MessageDM> parseAdminAttachmentEntities(JSONObject messageObj, JSONArray attachments) {
        try {
            ArrayList<MessageDM> result = new ArrayList<MessageDM>();
            for (int i = 0; i < attachments.length(); ++i) {
                JSONObject attachment = attachments.getJSONObject(i);
                String messageId = messageObj.getString("id") + "_" + i;
                String createdAt = messageObj.getString("created_at");
                createdAt = HSDateFormatSpec.addMilliSeconds(HSDateFormatSpec.STORAGE_TIME_FORMAT, createdAt, i + 1);
                long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
                String body = messageObj.getString("body");
                String authorName = messageObj.getJSONObject("author").getString("name");
                String url = attachment.getString("url");
                String contentType = attachment.getString("content-type");
                int size = attachment.getInt("size");
                String fileName = attachment.getString("file-name");
                boolean isSecureAttachment = attachment.optBoolean("secure?", false);
                boolean isRedacted = messageObj.optBoolean("redacted", false);
                int deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
                AttachmentMessageDM messageDM = attachment.optBoolean("image") ? new AdminImageAttachmentMessageDM(messageId, body, createdAt, epochCreatedAtTime, authorName, url, fileName, attachment.getString("thumbnail"), contentType, isSecureAttachment, size) : new AdminAttachmentMessageDM(messageId, body, createdAt, epochCreatedAtTime, authorName, size, contentType, url, fileName, isSecureAttachment);
                messageDM.deliveryState = deliveryState;
                messageDM.isRedacted = isRedacted;
                result.add(messageDM);
            }
            return result;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading admin attachment message");
        }
    }

    private RequestAppReviewMessageDM parseRequestAppReviewMessageDM(JSONObject messageObj) {
        try {
            boolean isAnswered = false;
            JSONObject responseObj = messageObj.getJSONObject("meta").optJSONObject("response");
            if (responseObj != null) {
                isAnswered = responseObj.optBoolean("state");
            }
            boolean isInvisible = messageObj.optBoolean("invisible") || isAnswered;
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            RequestAppReviewMessageDM messageDM = new RequestAppReviewMessageDM(messageObj.getString("id"), messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), isInvisible);
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            messageDM.isRedacted = messageObj.optBoolean("redacted", false);
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading request review message");
        }
    }

    private List<MessageDM> parseRequestScreenshotMessageDM(JSONObject messageObj) {
        try {
            ArrayList<MessageDM> result = new ArrayList<MessageDM>();
            boolean isAnswered = false;
            JSONObject meta = messageObj.getJSONObject("meta");
            JSONObject responseObj = meta.optJSONObject("response");
            JSONArray attachments = meta.optJSONArray("attachments");
            if (responseObj != null) {
                isAnswered = responseObj.getBoolean("state");
            }
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            RequestScreenshotMessageDM messageDM = new RequestScreenshotMessageDM(messageObj.getString("id"), messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), isAnswered);
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            messageDM.isRedacted = messageObj.optBoolean("redacted", false);
            result.add(messageDM);
            if (attachments != null) {
                result.addAll(this.parseAdminAttachmentEntities(messageObj, attachments));
            }
            return result;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading request screenshot message");
        }
    }

    private ScreenshotMessageDM parseScreenshotMessageDM(JSONObject messageObj) {
        try {
            JSONObject attachment = messageObj.getJSONObject("meta").getJSONArray("attachments").getJSONObject(0);
            String createdAt = messageObj.getString("created_at");
            long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
            ScreenshotMessageDM messageDM = new ScreenshotMessageDM(messageObj.getString("body"), createdAt, epochCreatedAtTime, messageObj.getJSONObject("author").getString("name"), attachment.getString("content-type"), attachment.optString("thumbnail", ""), attachment.getString("file-name"), attachment.getString("url"), attachment.getInt("size"), attachment.optBoolean("secure?", false));
            messageDM.serverId = messageObj.getString("id");
            messageDM.deliveryState = this.convertDeliveryStateToInt(messageObj.optString("md_state", ""));
            messageDM.isRedacted = messageObj.optBoolean("redacted", false);
            this.parseAndSetDataForUserSentMessages(messageDM, messageObj);
            return messageDM;
        }
        catch (JSONException e) {
            throw RootAPIException.wrap((Exception)((Object)e), ParseException.GENERIC, "Parsing exception while reading screenshot message");
        }
    }

    private PeriodicReview parsePeriodicReview(JSONObject periodicReviewConfig) throws JSONException {
        return new PeriodicReview(periodicReviewConfig.optBoolean("s"), periodicReviewConfig.optInt("i"), periodicReviewConfig.optString("t", ""));
    }

    private int convertDeliveryStateToInt(String mdState) {
        switch (mdState) {
            case "unread": {
                return 0;
            }
            case "read": {
                return 1;
            }
            case "sent": {
                return 2;
            }
        }
        return 0;
    }

    private void parseAndSetDataForUserSentMessages(MessageDM messageDM, JSONObject messageObj) throws JSONException {
        messageDM.authorId = messageObj.getJSONObject("author").optString("id");
        messageDM.createdRequestId = messageObj.optString("request_id");
    }

    private Long fetchIntervalWithMinimumDefault(Long input) {
        if (input < SDKConfigurationDM.MINIMUM_PERIODIC_FETCH_INTERVAL) {
            return SDKConfigurationDM.MINIMUM_PERIODIC_FETCH_INTERVAL;
        }
        return input;
    }
}

