/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import com.helpshift.account.dao.ClearedUserDAO;
import com.helpshift.account.dao.UserDAO;
import com.helpshift.account.dao.UserManagerDAO;
import com.helpshift.analytics.AnalyticsEventDAO;
import com.helpshift.cif.dao.CustomIssueFieldDAO;
import com.helpshift.common.dao.BackupDAO;
import com.helpshift.common.domain.Threader;
import com.helpshift.common.platform.Device;
import com.helpshift.common.platform.Jsonifier;
import com.helpshift.common.platform.KVStore;
import com.helpshift.common.platform.network.HTTPTransport;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.conversation.dao.ConversationDAO;
import com.helpshift.conversation.dao.ConversationInboxDAO;
import com.helpshift.conversation.dao.FAQSuggestionsDAO;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.downloader.SupportDownloader;
import com.helpshift.faq.dao.FaqEventDAO;
import com.helpshift.faq.domainmodel.FAQSearchDM;
import com.helpshift.meta.dao.MetaDataDAO;
import com.helpshift.migration.LegacyAnalyticsEventIDDAO;
import com.helpshift.migration.LegacyProfileMigrationDAO;
import com.helpshift.providers.ICampaignsModuleAPIs;
import com.helpshift.redaction.RedactionDAO;

public interface Platform {
    public String getAPIKey();

    public String getDomain();

    public String getAppId();

    public Device getDevice();

    public ConversationInboxDAO getConversationInboxDAO();

    public ConversationDAO getConversationDAO();

    public FAQSuggestionsDAO getFAQSuggestionsDAO();

    public MetaDataDAO getMetaDataDAO();

    public AnalyticsEventDAO getAnalyticsEventDAO();

    public CustomIssueFieldDAO getCustomIssueFieldDAO();

    public BackupDAO getBackupDAO();

    public ResponseParser getResponseParser();

    public HTTPTransport getHTTPTransport();

    public FAQSearchDM getFAQSearchDM();

    public KVStore getKVStore();

    public Jsonifier getJsonifier();

    public UserManagerDAO getUserManagerDAO();

    public UserDAO getUserDAO();

    public ClearedUserDAO getClearedUserDAO();

    public NetworkRequestDAO getNetworkRequestDAO();

    public FaqEventDAO getFaqEventDAO();

    public boolean isCurrentThreadUIThread();

    public Threader getUIThreader();

    public SupportDownloader getDownloader();

    public boolean isSupportedMimeType(String var1);

    public String getMimeTypeForFile(String var1);

    public String compressAndStoreScreenshot(String var1, String var2);

    public void compressAndCopyScreenshot(ImagePickerFile var1, String var2);

    public int getMinimumConversationDescriptionLength();

    public void showNotification(Long var1, String var2, int var3, String var4);

    public void clearNotifications(String var1);

    public ICampaignsModuleAPIs getCampaignModuleAPIs();

    public boolean isOnline();

    public void setUIContext(Object var1);

    public LegacyProfileMigrationDAO getLegacyUserMigrationDataSource();

    public LegacyAnalyticsEventIDDAO getLegacyAnalyticsEventIDDAO();

    public RedactionDAO getRedactionDAO();
}

