/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform.network.websockets;

import com.helpshift.common.StringUtils;
import com.helpshift.common.platform.network.websockets.IHSWebSocketListener;
import com.helpshift.common.platform.network.websockets.NVWebSocketListenerImpl;
import com.helpshift.websockets.WebSocket;
import com.helpshift.websockets.WebSocketException;
import com.helpshift.websockets.WebSocketFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HSWebSocket {
    private final WebSocket mWebSocket;
    private final IHSWebSocketListener listener;

    HSWebSocket(WebSocket webSocket, IHSWebSocketListener listener) {
        this.mWebSocket = webSocket;
        this.listener = listener;
        NVWebSocketListenerImpl nvWebSocketListener = new NVWebSocketListenerImpl(this, listener);
        webSocket.addListener(nvWebSocketListener);
    }

    public void connect() {
        try {
            this.mWebSocket.connect();
        }
        catch (WebSocketException e) {
            this.listener.onError(this, e.getMessage());
        }
    }

    public void disconnect() {
        this.mWebSocket.disconnect();
    }

    public void sendMessage(String message) {
        try {
            this.mWebSocket.sendText(message);
        }
        catch (Exception e) {
            this.listener.onError(this, e.getMessage());
        }
    }

    public static class Builder {
        private String url;
        private int connectionTimeout;
        private int socketTimeout;
        private List<String> extensions = new ArrayList<String>();
        private List<String> protocols = new ArrayList<String>();
        private Map<String, String> headers = new HashMap<String, String>();
        private IHSWebSocketListener listener;

        public Builder(String url) {
            this.url = url;
        }

        public Builder setConnectionTimeout(int timeout) {
            this.connectionTimeout = timeout;
            return this;
        }

        public Builder setSocketTimeout(int timeout) {
            this.socketTimeout = timeout;
            return this;
        }

        public Builder addExtension(String extension) {
            this.extensions.add(extension);
            return this;
        }

        public Builder addProtocol(String protocol) {
            this.protocols.add(protocol);
            return this;
        }

        public Builder addHeader(String name, String value) {
            if (value != null && !StringUtils.isEmpty(name)) {
                this.headers.put(name, value);
            }
            return this;
        }

        public Builder setWebSocketListener(IHSWebSocketListener listener) {
            this.listener = listener;
            return this;
        }

        public HSWebSocket build() throws IOException {
            WebSocketFactory factory = new WebSocketFactory();
            WebSocket ws = factory.setConnectionTimeout(this.connectionTimeout).createSocket(this.url);
            ws.getSocket().setSoTimeout(this.socketTimeout);
            for (String extension : this.extensions) {
                ws.addExtension(extension);
            }
            for (String protocol : this.protocols) {
                ws.addProtocol(protocol);
            }
            for (String headerName : this.headers.keySet()) {
                ws.addHeader(headerName, this.headers.get(headerName));
            }
            HSWebSocket hsWebSocket = new HSWebSocket(ws, this.listener);
            return hsWebSocket;
        }
    }
}

