/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.util;

import com.helpshift.common.platform.Platform;
import com.helpshift.common.util.HSSimpleDateFormat;
import com.helpshift.util.HSLogger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class HSDateFormatSpec {
    public static final String STORAGE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DISPLAY_TIME_PATTERN_24HR = "H:mm";
    public static final String DISPLAY_TIME_PATTERN_12HR = "h:mm a";
    public static final String DISPLAY_DATE_PATTERN = "EEEE, MMMM dd, yyyy";
    public static final HSSimpleDateFormat STORAGE_TIME_FORMAT = new HSSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "GMT");
    private static final Map<String, HSSimpleDateFormat> formatterCache = new HashMap<String, HSSimpleDateFormat>();
    private static final String TAG = "Helpshift_DFSpec";

    private HSDateFormatSpec() {
    }

    public static HSSimpleDateFormat getDateFormatter(String pattern, Locale locale, String timeZone) {
        String lookupKey = pattern + "_" + locale.getLanguage() + "_" + timeZone;
        HSSimpleDateFormat cachedFormatter = formatterCache.get(lookupKey);
        if (cachedFormatter == null) {
            cachedFormatter = new HSSimpleDateFormat(pattern, locale, timeZone);
            formatterCache.put(lookupKey, cachedFormatter);
        }
        return cachedFormatter;
    }

    public static HSSimpleDateFormat getDateFormatter(String pattern, Locale locale) {
        String lookupKey = pattern + "_" + locale.getLanguage();
        HSSimpleDateFormat cachedFormatter = formatterCache.get(lookupKey);
        if (cachedFormatter == null) {
            cachedFormatter = new HSSimpleDateFormat(pattern, locale);
            formatterCache.put(lookupKey, cachedFormatter);
        }
        return cachedFormatter;
    }

    public static Date getCurrentAdjustedTime(Platform platform) {
        float serverTimeDelta = platform.getNetworkRequestDAO().getServerTimeDelta();
        long currentTimeMillis = System.currentTimeMillis();
        if (serverTimeDelta != 0.0f) {
            currentTimeMillis = (long)((float)currentTimeMillis + serverTimeDelta * 1000.0f);
        }
        return new Date(currentTimeMillis);
    }

    public static String getCurrentAdjustedTimeForStorage(Platform platform) {
        return STORAGE_TIME_FORMAT.format(HSDateFormatSpec.getCurrentAdjustedTime(platform));
    }

    public static String addMilliSeconds(HSSimpleDateFormat dateFormat, String inputDate, int milliSeconds) {
        try {
            Date date = dateFormat.parse(inputDate);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            date = new Date(calendar.getTimeInMillis() + (long)milliSeconds);
            return dateFormat.format(date);
        }
        catch (ParseException e) {
            HSLogger.e(TAG, "Parsing exception on adding millisecond", e);
            return inputDate;
        }
    }

    public static float calculateTimeDelta(String serverTime) {
        DecimalFormat tsSecFormatter = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
        String deviceTime = tsSecFormatter.format((double)System.currentTimeMillis() / 1000.0);
        Double timeStamp = Double.parseDouble(serverTime) * 1000.0;
        Date serverDate = new Date((long)timeStamp.doubleValue());
        return (float)((double)serverDate.getTime() / 1000.0 - Double.parseDouble(deviceTime));
    }

    public static long convertToEpochTime(String storageTimeFormat) {
        long epochTime = -1L;
        try {
            Date date = STORAGE_TIME_FORMAT.parse(storageTimeFormat);
            epochTime = date.getTime();
        }
        catch (ParseException e) {
            HSLogger.e(TAG, "Parsing exception on converting storageTimeFormat to epochTime", e);
        }
        return epochTime;
    }
}

