/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.util;

import com.helpshift.common.util.HSListObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HSObservableList<T>
extends ArrayList<T> {
    private HSListObserver<T> observer;

    public HSObservableList() {
    }

    public HSObservableList(List<T> elements) {
        super(elements);
    }

    public void setObserver(HSListObserver<T> observer) {
        this.observer = observer;
    }

    @Override
    public boolean add(T t) {
        boolean result = super.add(t);
        if (result && this.observer != null) {
            this.observer.add(t);
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = super.addAll(c);
        if (result && this.observer != null) {
            this.observer.addAll(c);
        }
        return result;
    }

    public void prependItems(Collection<? extends T> c) {
        super.addAll(0, c);
    }

    public T setAndNotifyObserver(int index, T messageDM) {
        T t = super.set(index, messageDM);
        if (t != null && this.observer != null) {
            this.observer.update(messageDM);
        }
        return t;
    }
}

