/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.configuration.domainmodel;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.account.domainmodel.UserManagerDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.ETagNetwork;
import com.helpshift.common.domain.network.GETNetwork;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkConstants;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.KVStore;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.configuration.dto.RootApiConfig;
import com.helpshift.configuration.dto.RootInstallConfig;
import com.helpshift.configuration.response.PeriodicReview;
import com.helpshift.configuration.response.RootServerConfig;
import com.helpshift.util.HSLogger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;

public class SDKConfigurationDM
extends Observable {
    public static final String REQUIRE_NAME_AND_EMAIL = "requireNameAndEmail";
    public static final String PROFILE_FORM_ENABLE = "profileFormEnable";
    public static final String SHOW_AGENT_NAME = "showAgentName";
    public static final String CUSTOMER_SATISFACTION_SURVEY = "customerSatisfactionSurvey";
    public static final String DEBUG_LOG_LIMIT = "debugLogLimit";
    public static final String BREADCRUMB_LIMIT = "breadcrumbLimit";
    public static final String DISABLE_IN_APP_CONVERSATION = "disableInAppConversation";
    public static final String HELPSHIFT_BRANDING_DISABLE_AGENT = "disableHelpshiftBrandingAgent";
    public static final String REVIEW_URL = "reviewUrl";
    public static final String ENABLE_TYPING_INDICATOR_AGENT = "enableTypingIndicatorAgent";
    public static final String CONVERSATION_GREETING_MESSAGE = "conversationGreetingMessage";
    public static final String CONVERSATIONAL_ISSUE_FILING = "conversationalIssueFiling";
    public static final String SHOW_CONVERSATION_RESOLUTION_QUESTION_AGENT = "showConversationResolutionQuestionAgent";
    public static final String SHOULD_SHOW_CONVERSATION_HISTORY_AGENT = "showConversationHistoryAgent";
    public static final String ALLOW_USER_ATTACHMENTS = "allowUserAttachments";
    public static final String PERIODIC_FETCH_INTERVAL = "periodicFetchInterval";
    public static final String LAST_SUCCESSFUL_CONFIG_FETCH_TIME = "lastSuccessfulConfigFetchTime";
    public static final String API_KEY = "apiKey";
    public static final String DOMAIN_NAME = "domainName";
    public static final String PLATFORM_ID = "platformId";
    public static final String SDK_TYPE = "sdkType";
    public static final String PLUGIN_VERSION = "pluginVersion";
    public static final String RUNTIME_VERSION = "runtimeVersion";
    public static final String FONT_PATH = "fontPath";
    public static final String NOTIFICATION_SOUND_ID = "notificationSoundId";
    public static final String NOTIFICATION_ICON_ID = "notificationIconId";
    public static final String SUPPORT_NOTIFICATION_CHANNEL_ID = "supportNotificationChannelId";
    public static final String NOTIFICATION_LARGE_ICON_ID = "notificationLargeIconId";
    public static final String NOTIFICATION_MUTE_ENABLE = "notificationMute";
    public static final String ENABLE_IN_APP_NOTIFICATION = "enableInAppNotification";
    public static final String HELPSHIFT_BRANDING_DISABLE_INSTALL = "disableHelpshiftBranding";
    public static final String INBOX_POLLING_ENABLE = "inboxPollingEnable";
    public static final String DISABLE_ANIMATION = "disableAnimations";
    public static final String DEFAULT_FALLBACK_LANGUAGE_ENABLE = "defaultFallbackLanguageEnable";
    public static final String DISABLE_ERROR_LOGGING = "disableErrorLogging";
    public static final String DISABLE_APP_LAUNCH_EVENT = "disableAppLaunchEvent";
    public static final String ENABLE_FULL_PRIVACY = "fullPrivacy";
    public static final String HIDE_NAME_AND_EMAIL = "hideNameAndEmail";
    public static final String REQUIRE_EMAIL = "requireEmail";
    public static final String SHOW_SEARCH_ON_NEW_CONVERSATION = "showSearchOnNewConversation";
    public static final String CONVERSATION_PRE_FILL_TEXT = "conversationPrefillText";
    public static final String ENABLE_CONTACT_US = "enableContactUs";
    public static final String GOTO_CONVERSATION_AFTER_CONTACT_US = "gotoConversationAfterContactUs";
    public static final String SHOW_CONVERSATION_RESOLUTION_QUESTION_API = "showConversationResolutionQuestion";
    public static final String SHOW_CONVERSATION_INFO_SCREEN = "showConversationInfoScreen";
    public static final String ENABLE_TYPING_INDICATOR = "enableTypingIndicator";
    public static final String ENABLE_DEFAULT_CONVERSATIONAL_FILING = "enableDefaultConversationalFiling";
    public static final String APP_REVIEWED = "app_reviewed";
    public static final String SDK_LANGUAGE = "sdkLanguage";
    public static final String PERIODIC_REVIEW_ENABLED = "periodicReviewEnabled";
    public static final String PERIODIC_REVIEW_INTERVAL = "periodicReviewInterval";
    public static final String PERIODIC_REVIEW_TYPE = "periodicReviewType";
    public static final Long MINIMUM_PERIODIC_FETCH_INTERVAL = 60L;
    private static final String TAG = "Helpshift_SDKConfigDM";
    private final Domain domain;
    private final Platform platform;
    private final ResponseParser responseParser;
    private final KVStore kvStore;

    public SDKConfigurationDM(Domain domain, Platform platform) {
        this.domain = domain;
        this.platform = platform;
        this.responseParser = platform.getResponseParser();
        this.kvStore = platform.getKVStore();
    }

    public RootServerConfig fetchServerConfig(UserManagerDM userManagerDM) {
        UserDM userDM = userManagerDM.getActiveUser();
        String route = NetworkConstants.SUPPORT_CONFIG_ROUTE;
        Network network = new GETNetwork(route, this.domain, this.platform);
        network = new TSCorrectedNetwork(network, this.platform);
        network = new ETagNetwork(network, this.platform, route);
        network = new GuardOKNetwork(network);
        RequestData requestData = new RequestData(NetworkDataRequestUtil.getUserRequestData(userManagerDM));
        try {
            Response response = network.makeRequest(requestData);
            if (response.responseString == null) {
                HSLogger.d(TAG, "SDK config data fetched but nothing to update.");
                this.updateLastSuccessfulConfigFetchTime();
                return null;
            }
            HSLogger.d(TAG, "SDK config data updated successfully");
            RootServerConfig serverConfig = this.responseParser.parseConfigResponse(response.responseString);
            this.updateServerConfig(serverConfig);
            this.updateUserConfig(userDM, serverConfig, userManagerDM);
            this.updateLastSuccessfulConfigFetchTime();
            return serverConfig;
        }
        catch (RootAPIException e) {
            if (e.exceptionType instanceof NetworkException && ((NetworkException)e.exceptionType).serverStatusCode == NetworkErrorCodes.CONTENT_UNCHANGED) {
                this.updateLastSuccessfulConfigFetchTime();
            }
            throw e;
        }
    }

    private void updateUserConfig(UserDM userDM, RootServerConfig serverConfig, UserManagerDM userManagerDM) {
        userManagerDM.updateIssueExists(userDM, serverConfig.issueExists);
    }

    public void updateServerConfig(RootServerConfig serverConfig) {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        values.put(REQUIRE_NAME_AND_EMAIL, Boolean.valueOf(serverConfig.requireNameAndEmail));
        values.put(PROFILE_FORM_ENABLE, Boolean.valueOf(serverConfig.profileFormEnable));
        values.put(SHOW_AGENT_NAME, Boolean.valueOf(serverConfig.showAgentName));
        values.put(CUSTOMER_SATISFACTION_SURVEY, Boolean.valueOf(serverConfig.customerSatisfactionSurvey));
        values.put(DISABLE_IN_APP_CONVERSATION, Boolean.valueOf(serverConfig.disableInAppConversation));
        values.put(HELPSHIFT_BRANDING_DISABLE_AGENT, Boolean.valueOf(serverConfig.disableHelpshiftBranding));
        values.put(DEBUG_LOG_LIMIT, Integer.valueOf(serverConfig.debugLogLimit));
        values.put(BREADCRUMB_LIMIT, Integer.valueOf(serverConfig.breadcrumbLimit));
        values.put(REVIEW_URL, (Serializable)((Object)serverConfig.reviewUrl));
        PeriodicReview periodicReview = serverConfig.periodicReview;
        if (periodicReview == null) {
            periodicReview = new PeriodicReview(false, 0, null);
        }
        values.put(PERIODIC_REVIEW_ENABLED, Boolean.valueOf(periodicReview.isEnabled));
        values.put(PERIODIC_REVIEW_INTERVAL, Integer.valueOf(periodicReview.interval));
        values.put(PERIODIC_REVIEW_TYPE, (Serializable)((Object)periodicReview.type));
        values.put(CONVERSATION_GREETING_MESSAGE, (Serializable)((Object)serverConfig.conversationGreetingMessage));
        values.put(CONVERSATIONAL_ISSUE_FILING, Boolean.valueOf(serverConfig.conversationalIssueFiling));
        values.put(ENABLE_TYPING_INDICATOR_AGENT, Boolean.valueOf(serverConfig.enableTypingIndicator));
        values.put(SHOW_CONVERSATION_RESOLUTION_QUESTION_AGENT, Boolean.valueOf(serverConfig.showConversationResolutionQuestion));
        values.put(SHOULD_SHOW_CONVERSATION_HISTORY_AGENT, Boolean.valueOf(serverConfig.shouldShowConversationHistory));
        values.put(ALLOW_USER_ATTACHMENTS, Boolean.valueOf(serverConfig.allowUserAttachments));
        values.put(PERIODIC_FETCH_INTERVAL, serverConfig.periodicFetchInterval);
        this.kvStore.setKeyValues(values);
        this.setChanged();
        this.notifyObservers();
    }

    private void updateLastSuccessfulConfigFetchTime() {
        this.kvStore.setLong(LAST_SUCCESSFUL_CONFIG_FETCH_TIME, System.currentTimeMillis() / 1000L);
    }

    public Long getLastSuccessfulConfigFetchTime() {
        return this.kvStore.getLong(LAST_SUCCESSFUL_CONFIG_FETCH_TIME, 0L);
    }

    public boolean getBoolean(String key) {
        boolean defaultValue;
        switch (key) {
            case "profileFormEnable": 
            case "showAgentName": 
            case "enableInAppNotification": 
            case "defaultFallbackLanguageEnable": 
            case "showConversationResolutionQuestionAgent": 
            case "enableTypingIndicatorAgent": 
            case "allowUserAttachments": {
                defaultValue = true;
                break;
            }
            case "conversationalIssueFiling": {
                defaultValue = this.kvStore.getBoolean(ENABLE_DEFAULT_CONVERSATIONAL_FILING, false);
                break;
            }
            default: {
                defaultValue = false;
            }
        }
        return this.kvStore.getBoolean(key, defaultValue);
    }

    public Integer getInt(String key) {
        Integer defaultValue;
        switch (key) {
            case "debugLogLimit": 
            case "breadcrumbLimit": {
                defaultValue = 100;
                break;
            }
            default: {
                defaultValue = null;
            }
        }
        return this.kvStore.getInt(key, defaultValue);
    }

    public String getString(String key) {
        String defaultValue;
        switch (key) {
            case "reviewUrl": 
            case "sdkLanguage": {
                defaultValue = "";
                break;
            }
            case "sdkType": {
                defaultValue = "android";
                break;
            }
            default: {
                defaultValue = null;
            }
        }
        return this.kvStore.getString(key, defaultValue);
    }

    public PeriodicReview getPeriodicReview() {
        boolean enabled = this.kvStore.getBoolean(PERIODIC_REVIEW_ENABLED, false);
        int interval = this.kvStore.getInt(PERIODIC_REVIEW_INTERVAL, 0);
        String type = this.kvStore.getString(PERIODIC_REVIEW_TYPE, "");
        return new PeriodicReview(enabled, interval, type);
    }

    public void updateInstallConfig(Map<String, Object> installConfig) {
        RootInstallConfig rootInstallConfig = new RootInstallConfig.RootInstallConfigBuilder().applyMap(installConfig).build();
        this.updateInstallConfig(rootInstallConfig);
    }

    public void updateInstallConfig(RootInstallConfig rootInstallConfig) {
        HashMap<String, String> overwritableValues = new HashMap<String, String>();
        overwritableValues.put(SUPPORT_NOTIFICATION_CHANNEL_ID, rootInstallConfig.supportNotificationChannelId);
        overwritableValues.put(FONT_PATH, rootInstallConfig.fontPath);
        HashMap<String, Serializable> nonOverwritableValues = new HashMap<String, Serializable>();
        nonOverwritableValues.put(ENABLE_IN_APP_NOTIFICATION, rootInstallConfig.enableInAppNotification);
        nonOverwritableValues.put(DEFAULT_FALLBACK_LANGUAGE_ENABLE, rootInstallConfig.enableDefaultFallbackLanguage);
        nonOverwritableValues.put(INBOX_POLLING_ENABLE, rootInstallConfig.enableInboxPolling);
        nonOverwritableValues.put(NOTIFICATION_MUTE_ENABLE, rootInstallConfig.enableNotificationMute);
        nonOverwritableValues.put(DISABLE_ANIMATION, rootInstallConfig.disableAnimations);
        nonOverwritableValues.put(HELPSHIFT_BRANDING_DISABLE_INSTALL, rootInstallConfig.disableHelpshiftBranding);
        nonOverwritableValues.put(DISABLE_ERROR_LOGGING, rootInstallConfig.disableErrorLogging);
        nonOverwritableValues.put(DISABLE_APP_LAUNCH_EVENT, rootInstallConfig.disableAppLaunchEvent);
        nonOverwritableValues.put(NOTIFICATION_SOUND_ID, rootInstallConfig.notificationSound);
        nonOverwritableValues.put(NOTIFICATION_ICON_ID, rootInstallConfig.notificationIcon);
        nonOverwritableValues.put(NOTIFICATION_LARGE_ICON_ID, rootInstallConfig.largeNotificationIcon);
        nonOverwritableValues.put(SDK_TYPE, (Serializable)((Object)rootInstallConfig.sdkType));
        nonOverwritableValues.put(PLUGIN_VERSION, (Serializable)((Object)rootInstallConfig.pluginVersion));
        nonOverwritableValues.put(RUNTIME_VERSION, (Serializable)((Object)rootInstallConfig.runtimeVersion));
        this.removeNullValues(nonOverwritableValues);
        nonOverwritableValues.putAll(overwritableValues);
        this.kvStore.setKeyValues(nonOverwritableValues);
    }

    public void setInstallCredentials(String apiKey, String domainName, String platformId) {
        this.kvStore.setString(API_KEY, apiKey);
        this.kvStore.setString(DOMAIN_NAME, domainName);
        this.kvStore.setString(PLATFORM_ID, platformId);
    }

    public boolean isHelpshiftBrandingDisabled() {
        return this.kvStore.getBoolean(HELPSHIFT_BRANDING_DISABLE_INSTALL, false) != false || this.kvStore.getBoolean(HELPSHIFT_BRANDING_DISABLE_AGENT, false) != false;
    }

    public boolean shouldShowConversationResolutionQuestion() {
        return this.getBoolean(SHOW_CONVERSATION_RESOLUTION_QUESTION_AGENT) || this.getBoolean(SHOW_CONVERSATION_RESOLUTION_QUESTION_API);
    }

    public void updateApiConfig(Map<String, Object> apiConfig) {
        RootApiConfig rootApiConfig = new RootApiConfig.RootApiConfigBuilder().applyMap(apiConfig).build();
        this.updateApiConfig(rootApiConfig);
    }

    public void updateApiConfig(RootApiConfig rootApiConfig) {
        HashMap<String, String> overwritableValues = new HashMap<String, String>();
        overwritableValues.put(CONVERSATION_PRE_FILL_TEXT, rootApiConfig.conversationPrefillText);
        HashMap<String, Serializable> nonOverwritableValues = new HashMap<String, Serializable>();
        nonOverwritableValues.put(ENABLE_FULL_PRIVACY, rootApiConfig.enableFullPrivacy);
        nonOverwritableValues.put(HIDE_NAME_AND_EMAIL, rootApiConfig.hideNameAndEmail);
        nonOverwritableValues.put(REQUIRE_EMAIL, rootApiConfig.requireEmail);
        nonOverwritableValues.put(SHOW_SEARCH_ON_NEW_CONVERSATION, rootApiConfig.showSearchOnNewConversation);
        nonOverwritableValues.put(GOTO_CONVERSATION_AFTER_CONTACT_US, rootApiConfig.gotoConversationAfterContactUs);
        nonOverwritableValues.put(SHOW_CONVERSATION_RESOLUTION_QUESTION_API, rootApiConfig.showConversationResolutionQuestion);
        nonOverwritableValues.put(SHOW_CONVERSATION_INFO_SCREEN, rootApiConfig.showConversationInfoScreen);
        nonOverwritableValues.put(ENABLE_TYPING_INDICATOR, rootApiConfig.enableTypingIndicator);
        if (rootApiConfig.enableContactUs != null) {
            nonOverwritableValues.put(ENABLE_CONTACT_US, Integer.valueOf(rootApiConfig.enableContactUs.getValue()));
        }
        nonOverwritableValues.put(ENABLE_DEFAULT_CONVERSATIONAL_FILING, rootApiConfig.enableDefaultConversationalFiling);
        this.removeNullValues(nonOverwritableValues);
        nonOverwritableValues.putAll(overwritableValues);
        this.kvStore.setKeyValues(nonOverwritableValues);
    }

    public RootApiConfig.EnableContactUs getEnableContactUs() {
        return RootApiConfig.EnableContactUs.fromInt(this.kvStore.getInt(ENABLE_CONTACT_US, 0));
    }

    public void setAppReviewed(boolean reviewed) {
        this.kvStore.setBoolean(APP_REVIEWED, reviewed);
    }

    public void setSdkLanguage(String sdkLanguage) {
        this.kvStore.setString(SDK_LANGUAGE, sdkLanguage);
    }

    public boolean shouldEnableTypingIndicator() {
        return this.getBoolean(ENABLE_TYPING_INDICATOR_AGENT) || this.getBoolean(ENABLE_TYPING_INDICATOR);
    }

    public boolean shouldCreateConversationAnonymously() {
        return this.getBoolean(ENABLE_FULL_PRIVACY) || (!this.getBoolean(REQUIRE_NAME_AND_EMAIL) || !this.getBoolean(HIDE_NAME_AND_EMAIL)) && !this.getBoolean(PROFILE_FORM_ENABLE);
    }

    public int getMinimumConversationDescriptionLength() {
        return this.platform.getMinimumConversationDescriptionLength();
    }

    private void removeNullValues(Map<String, Serializable> map) {
        Iterator<Map.Entry<String, Serializable>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Serializable> entry = iterator.next();
            if (entry.getValue() != null) continue;
            iterator.remove();
        }
    }

    public boolean shouldShowConversationHistory() {
        boolean isConversationalIssueFilingOn;
        boolean shouldShowConversationHistoryAgent = this.getBoolean(SHOULD_SHOW_CONVERSATION_HISTORY_AGENT);
        if (shouldShowConversationHistoryAgent && (isConversationalIssueFilingOn = this.getBoolean(CONVERSATIONAL_ISSUE_FILING))) {
            return !this.getBoolean(ENABLE_FULL_PRIVACY);
        }
        return false;
    }

    public Long getPeriodicFetchInterval() {
        Long defaultValue = 0L;
        return this.kvStore.getLong(PERIODIC_FETCH_INTERVAL, defaultValue);
    }
}

