/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.controllers;

import com.helpshift.controllers.DataSyncCompletionListener;
import com.helpshift.controllers.DataSyncCoordinator;
import com.helpshift.storage.KeyValueStorage;

public class DataSyncCoordinatorImpl
implements DataSyncCoordinator {
    public static final String FIRST_DEVICE_SYNC_COMPLETE_KEY = "firstDeviceSyncComplete";
    private KeyValueStorage storage;
    private DataSyncCompletionListener dataSyncCompletionListener;

    protected DataSyncCoordinatorImpl(KeyValueStorage keyValueStorage) {
        this.storage = keyValueStorage;
    }

    protected DataSyncCoordinatorImpl(KeyValueStorage keyValueStorage, DataSyncCompletionListener dataSyncCompletionListener) {
        this(keyValueStorage);
        this.dataSyncCompletionListener = dataSyncCompletionListener;
    }

    private static boolean isBoolean(Boolean value) {
        return value != null && value != false;
    }

    private boolean canSyncProperties(String userId) {
        boolean deviceSyncComplete = DataSyncCoordinatorImpl.isBoolean((Boolean)this.storage.get(FIRST_DEVICE_SYNC_COMPLETE_KEY));
        boolean userSwitchComplete = DataSyncCoordinatorImpl.isBoolean((Boolean)this.storage.get("switchUserCompleteFor" + userId));
        return deviceSyncComplete && userSwitchComplete;
    }

    @Override
    public boolean canSyncUserProperties(String userId) {
        return this.canSyncProperties(userId);
    }

    @Override
    public boolean canSyncSessionProperties(String userId) {
        return this.canSyncProperties(userId);
    }

    @Override
    public void firstDeviceSyncComplete() {
        this.storage.set(FIRST_DEVICE_SYNC_COMPLETE_KEY, Boolean.valueOf(true));
        if (this.dataSyncCompletionListener != null) {
            this.dataSyncCompletionListener.firstDeviceSyncComplete();
        }
    }

    @Override
    public boolean isFirstDeviceSyncComplete() {
        return DataSyncCoordinatorImpl.isBoolean((Boolean)this.storage.get(FIRST_DEVICE_SYNC_COMPLETE_KEY));
    }

    @Override
    public void switchUserPending(String userId) {
        this.storage.set("switchUserCompleteFor" + userId, Boolean.valueOf(false));
    }

    @Override
    public void switchUserComplete(String userId) {
        this.storage.set("switchUserCompleteFor" + userId, Boolean.valueOf(true));
        if (this.dataSyncCompletionListener != null) {
            this.dataSyncCompletionListener.switchUserComplete(userId);
        }
    }
}

