/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.app.AppLifeCycleStateHolder;
import com.helpshift.common.ListUtils;
import com.helpshift.common.domain.PollFunction;
import com.helpshift.common.domain.Poller;
import com.helpshift.common.domain.PollingInterval;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.ConversationUtil;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.dao.ConversationDAO;
import com.helpshift.util.HSLogger;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class ConversationInboxPoller
implements Observer {
    private static final String TAG = "Helpshift_ConvPoller";
    private static final long INITIAL_DELAY = 3000L;
    public final Poller poller;
    private final UserDM userDM;
    private final SDKConfigurationDM sdkConfigurationDM;
    private final ConversationDAO conversationDAO;
    private PollingInterval currentPollingInterval;
    private PollFunction.PollFunctionListener pollFunctionListener = new PollFunction.PollFunctionListener(){

        @Override
        public void onPollingStoppedViaBackoffStrategy() {
            HSLogger.d(ConversationInboxPoller.TAG, "Poll stopped via backoff, resetting currentPollingInterval");
            ConversationInboxPoller.this.stop();
        }
    };

    public ConversationInboxPoller(UserDM userDM, SDKConfigurationDM sdkConfigurationDM, Poller poller, ConversationDAO conversationDAO) {
        this.userDM = userDM;
        this.sdkConfigurationDM = sdkConfigurationDM;
        this.poller = poller;
        this.conversationDAO = conversationDAO;
    }

    private boolean shouldStartSDKPoller() {
        return AppLifeCycleStateHolder.isAppInForeground() && this.userDM.issueExists() && !this.userDM.isPushTokenSynced() && !this.sdkConfigurationDM.getBoolean("disableInAppConversation");
    }

    public void startAppPoller(boolean withInitialDelay) {
        PollingInterval pollingInterval;
        if (!this.shouldStartSDKPoller()) {
            this.stop();
            return;
        }
        List<ConversationDM> conversations = this.conversationDAO.readConversationsWithoutMessages(this.userDM.getLocalId());
        boolean shouldStartPassivePoller = !ListUtils.isEmpty(conversations) ? !ConversationUtil.shouldPollActivelyForConversations(conversations) : false;
        PollingInterval pollingInterval2 = pollingInterval = shouldStartPassivePoller ? PollingInterval.PASSIVE : PollingInterval.CONSERVATIVE;
        if (this.currentPollingInterval == pollingInterval) {
            return;
        }
        this.stop();
        this.currentPollingInterval = pollingInterval;
        HSLogger.d(TAG, "Listening for conversation updates : " + (Object)((Object)this.currentPollingInterval));
        long delay = withInitialDelay ? 3000L : 0L;
        this.poller.start(pollingInterval, delay, this.pollFunctionListener);
    }

    public void startChatPoller() {
        if (!AppLifeCycleStateHolder.isAppInForeground()) {
            this.stop();
            return;
        }
        if (this.currentPollingInterval == PollingInterval.AGGRESSIVE) {
            return;
        }
        this.stop();
        this.currentPollingInterval = PollingInterval.AGGRESSIVE;
        HSLogger.d(TAG, "Listening for in-chat conversation updates");
        this.poller.start(PollingInterval.AGGRESSIVE, 0L, this.pollFunctionListener);
    }

    public void stop() {
        HSLogger.d(TAG, "Stopped listening for conversation updates : " + (Object)((Object)this.currentPollingInterval));
        this.poller.stop();
        this.currentPollingInterval = null;
    }

    @Override
    public void update(Observable observable, Object o) {
        this.refreshPoller(true);
    }

    public void refreshPoller(boolean withInitialDelay) {
        if (!AppLifeCycleStateHolder.isAppInForeground() || !this.userDM.isActiveUser()) {
            this.stop();
        } else if (this.currentPollingInterval == PollingInterval.AGGRESSIVE) {
            this.startChatPoller();
        } else {
            this.startAppPoller(withInitialDelay);
        }
    }
}

