/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation;

import com.helpshift.common.ListUtils;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.dao.ConversationDAO;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ConversationUtil {
    private static Comparator<ConversationDM> conversationDMComparator;
    private static Comparator<MessageDM> messageDMComparator;

    private static void checkAndUpdateCachedConversationDMComparator() {
        if (conversationDMComparator == null) {
            conversationDMComparator = new Comparator<ConversationDM>(){

                @Override
                public int compare(ConversationDM firstConversation, ConversationDM secondConversation) {
                    long firstConversationTime = firstConversation.getEpochCreatedAtTime();
                    long secondConversationTime = secondConversation.getEpochCreatedAtTime();
                    return ConversationUtil.compareEpochTime(firstConversationTime, secondConversationTime);
                }
            };
        }
    }

    public static void sortConversationsBasedOnCreatedAt(List<ConversationDM> conversations) {
        ConversationUtil.checkAndUpdateCachedConversationDMComparator();
        Collections.sort(conversations, conversationDMComparator);
    }

    public static ConversationDM getLastConversationDMBasedOnCreatedAt(Collection<ConversationDM> conversations) {
        ConversationUtil.checkAndUpdateCachedConversationDMComparator();
        return Collections.max(conversations, conversationDMComparator);
    }

    public static void sortMessagesBasedOnCreatedAt(List<MessageDM> messages) {
        if (messageDMComparator == null) {
            messageDMComparator = new Comparator<MessageDM>(){

                @Override
                public int compare(MessageDM firstMessage, MessageDM secondMessage) {
                    long firstMessageTime = firstMessage.getEpochCreatedAtTime();
                    long secondMessageTime = secondMessage.getEpochCreatedAtTime();
                    return ConversationUtil.compareEpochTime(firstMessageTime, secondMessageTime);
                }
            };
        }
        Collections.sort(messages, messageDMComparator);
    }

    private static int compareEpochTime(long firstTime, long secondTime) {
        if (firstTime > secondTime) {
            return 1;
        }
        if (firstTime < secondTime) {
            return -1;
        }
        return 0;
    }

    public static int getUserMessageCountForConversationLocalId(ConversationDAO conversationDAO, Long conversationLocalId) {
        if (conversationLocalId == null) {
            return 0;
        }
        Map<Long, Integer> messagesCountMap = ConversationUtil.getUserMessageCountForConversationLocalIds(conversationDAO, Collections.singletonList(conversationLocalId));
        Integer result = messagesCountMap.get(conversationLocalId);
        if (result != null) {
            return result;
        }
        return 0;
    }

    public static Map<Long, Integer> getUserMessageCountForConversationLocalIds(ConversationDAO conversationDAO, List<Long> conversationLocalIds) {
        String[] messageTypes = new String[]{MessageType.USER_TEXT.getValue(), MessageType.ACCEPTED_APP_REVIEW.getValue(), MessageType.SCREENSHOT.getValue(), MessageType.USER_RESP_FOR_TEXT_INPUT.getValue(), MessageType.USER_RESP_FOR_OPTION_INPUT.getValue()};
        return conversationDAO.getMessagesCountForConversations(conversationLocalIds, messageTypes);
    }

    public static boolean shouldPollActivelyForConversations(List<ConversationDM> conversations) {
        if (ListUtils.isEmpty(conversations)) {
            return false;
        }
        for (ConversationDM conversation : conversations) {
            if (!conversation.isIssueInProgress()) continue;
            return true;
        }
        return false;
    }
}

