/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.F;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.domainmodel.ConversationInboxDM;
import com.helpshift.util.HSLogger;
import java.lang.ref.WeakReference;

public class CreatePreIssueDM
extends F {
    private static final String TAG = "Helpshift_CrtePreIsue";
    private final ConversationInboxDM conversationInboxDM;
    private final ConversationDM conversationDM;
    private final SDKConfigurationDM sdkConfigurationDM;
    private WeakReference<ConversationInboxDM.StartNewConversationListener> listener;

    public CreatePreIssueDM(ConversationInboxDM conversationInboxDM, ConversationDM conversationDM, SDKConfigurationDM sdkConfigurationDM, ConversationInboxDM.StartNewConversationListener listener) {
        this.conversationDM = conversationDM;
        this.conversationInboxDM = conversationInboxDM;
        this.sdkConfigurationDM = sdkConfigurationDM;
        this.listener = new WeakReference<ConversationInboxDM.StartNewConversationListener>(listener);
    }

    @Override
    public void f() {
        block4: {
            try {
                if (this.conversationDM.preConversationServerId != null) {
                    return;
                }
                String greetingMessage = this.sdkConfigurationDM.getString("conversationGreetingMessage");
                this.conversationInboxDM.createPreIssueNetwork(this.conversationDM, greetingMessage);
                this.conversationDM.updateLastUserActivityTime(System.currentTimeMillis());
                if (this.listener.get() != null) {
                    ((ConversationInboxDM.StartNewConversationListener)this.listener.get()).onCreateConversationSuccess(this.conversationDM.localId);
                }
            }
            catch (RootAPIException e) {
                HSLogger.e(TAG, "Error filing a pre-issue", e);
                if (this.listener.get() == null || !StringUtils.isEmpty(this.conversationDM.getPreIssueId())) break block4;
                ((ConversationInboxDM.StartNewConversationListener)this.listener.get()).onCreateConversationFailure(e);
            }
        }
    }

    public void setListener(ConversationInboxDM.StartNewConversationListener listener) {
        this.listener = new WeakReference<ConversationInboxDM.StartNewConversationListener>(listener);
    }
}

