/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.idempotent.SuccessOrNonRetriableStatusCodeIdempotentPolicy;
import com.helpshift.common.domain.network.AuthenticationFailureNetwork;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.IdempotentNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.PUTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.exception.ExceptionType;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.common.util.HSObservableList;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.ConversationUtil;
import com.helpshift.conversation.activeconversation.ConversationDMListener;
import com.helpshift.conversation.activeconversation.ConversationServerInfo;
import com.helpshift.conversation.activeconversation.ConversationUpdate;
import com.helpshift.conversation.activeconversation.message.AcceptedAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminBotControlMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageWithOptionInputDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageWithTextInputDM;
import com.helpshift.conversation.activeconversation.message.AutoRetriableMessageDM;
import com.helpshift.conversation.activeconversation.message.ConfirmationAcceptedMessageDM;
import com.helpshift.conversation.activeconversation.message.ConfirmationRejectedMessageDM;
import com.helpshift.conversation.activeconversation.message.FAQListMessageDM;
import com.helpshift.conversation.activeconversation.message.FollowupAcceptedMessageDM;
import com.helpshift.conversation.activeconversation.message.FollowupRejectedMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.OptionInputMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestForReopenMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.UnsupportedAdminMessageWithInputDM;
import com.helpshift.conversation.activeconversation.message.UserBotControlMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageState;
import com.helpshift.conversation.activeconversation.message.UserResponseMessageForOptionInput;
import com.helpshift.conversation.activeconversation.message.UserResponseMessageForTextInputDM;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import com.helpshift.conversation.dao.ConversationDAO;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.dto.IssueState;
import com.helpshift.conversation.states.ConversationCSATState;
import com.helpshift.meta.MetaDataDM;
import com.helpshift.util.HSLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public class ConversationDM
implements Observer,
ConversationServerInfo {
    private static final String TAG = "Helpshift_ConvDM";
    private final Map<String, RequestForReopenMessageDM> unansweredRequestForReopenMessageDMs = new HashMap<String, RequestForReopenMessageDM>();
    public Long localId;
    public String serverId;
    public String preConversationServerId;
    public String localUUID;
    public String title;
    public IssueState state;
    public String issueType;
    public String updatedAt;
    public HSObservableList<MessageDM> messageDMs = new HSObservableList();
    public String publishId;
    public boolean showAgentName;
    public String messageCursor;
    public boolean shouldIncrementMessageCount;
    public boolean isConversationEndedDelegateSent;
    public ConversationCSATState csatState = ConversationCSATState.NONE;
    public int csatRating;
    public String csatFeedback;
    public boolean isStartNewConversationClicked;
    public long userLocalId;
    public long lastUserActivityTime;
    public String createdRequestId;
    public boolean wasFullPrivacyEnabledAtCreation;
    public boolean isRedacted;
    Platform platform;
    Domain domain;
    UserDM userDM;
    private String createdAt;
    private boolean isInBetweenBotExecution;
    private ConversationDAO conversationDAO;
    private MetaDataDM metaDataDM;
    private SDKConfigurationDM sdkConfigurationDM;
    private boolean enableMessageClickOnResolutionRejected;
    private ConversationDMListener conversationDMListener;
    private long epochCreatedAtTime;

    public ConversationDM(String title, IssueState state, String createdAt, long epochCreatedAtTime, String updatedAt, String publishId, String messageCursor, boolean showAgentName) {
        this.title = title;
        this.createdAt = createdAt;
        this.epochCreatedAtTime = epochCreatedAtTime;
        this.updatedAt = updatedAt;
        this.publishId = publishId;
        this.messageCursor = messageCursor;
        this.showAgentName = showAgentName;
        this.state = state;
    }

    public ConversationDM(Platform platform, Domain domain, UserDM userDM) {
        this.setDependencies(platform, domain, userDM);
    }

    public void setDependencies(Platform platform, Domain domain, UserDM userDM) {
        this.platform = platform;
        this.domain = domain;
        this.userDM = userDM;
        this.conversationDAO = platform.getConversationDAO();
        this.metaDataDM = domain.getMetaDataDM();
        this.sdkConfigurationDM = domain.getSDKConfigurationDM();
        this.userLocalId = userDM.getLocalId();
    }

    void registerMessagesObserver() {
        for (MessageDM messageDM : this.messageDMs) {
            messageDM.addObserver(this);
        }
    }

    public void retryMessage(MessageDM messageDM) {
        if (messageDM instanceof UserMessageDM) {
            this.sendTextMessage((UserMessageDM)messageDM);
        } else if (messageDM instanceof ScreenshotMessageDM) {
            this.sendScreenshotMessageInternal((ScreenshotMessageDM)messageDM, false);
        }
    }

    public void sendTextMessage(String reply, AdminMessageWithTextInputDM messageDM, boolean isSkipped) {
        String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
        long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
        UserResponseMessageForTextInputDM response = new UserResponseMessageForTextInputDM(reply, createdAt, epochCreatedAtTime, "mobile", messageDM, isSkipped);
        response.conversationLocalId = this.localId;
        response.updateState(true);
        this.addMessageToDbAndUI(response);
        this.sendTextMessage(response);
    }

    public void sendOptionInputMessage(OptionInputMessageDM messageDM, OptionInput.Option selectedOption, boolean isSkipped) {
        String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
        long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
        String messageBody = isSkipped ? messageDM.input.skipLabel : selectedOption.title;
        UserResponseMessageForOptionInput response = new UserResponseMessageForOptionInput(messageBody, createdAt, epochCreatedAtTime, "mobile", messageDM, isSkipped);
        response.conversationLocalId = this.localId;
        response.updateState(true);
        this.addMessageToDbAndUI(response);
        this.deleteOptionsForAdminMessageWithOptionsInput(messageDM);
        this.sendTextMessage(response);
    }

    private void deleteOptionsForAdminMessageWithOptionsInput(OptionInputMessageDM optionInputMessageDM) {
        if (optionInputMessageDM.referredMessageType == MessageType.ADMIN_TEXT_WITH_OPTION_INPUT) {
            AdminMessageWithOptionInputDM adminMessageWithOptionInputDM = (AdminMessageWithOptionInputDM)this.conversationDAO.readMessage(optionInputMessageDM.serverId);
            adminMessageWithOptionInputDM.input.options.clear();
            this.conversationDAO.insertOrUpdateMessage(adminMessageWithOptionInputDM);
        }
    }

    public void sendTextMessage(String reply) {
        String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
        long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
        UserMessageDM userMessageDM = new UserMessageDM(reply, createdAt, epochCreatedAtTime, "mobile");
        userMessageDM.conversationLocalId = this.localId;
        userMessageDM.updateState(this.shouldEnableMessagesClick());
        this.addMessageToDbAndUI(userMessageDM);
        this.sendTextMessage(userMessageDM);
    }

    private void sendTextMessage(UserMessageDM userMessageDM) {
        try {
            userMessageDM.send(this.userDM, this);
            if (this.state == IssueState.RESOLUTION_REJECTED) {
                this.updateIssueStatus(IssueState.WAITING_FOR_AGENT);
            }
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.CONVERSATION_ARCHIVED) {
                this.updateIssueStatus(IssueState.ARCHIVED);
            }
            if (e.exceptionType == NetworkException.USER_PRE_CONDITION_FAILED) {
                this.updateIssueStatus(IssueState.AUTHOR_MISMATCH);
            }
            throw e;
        }
    }

    public void handleAppReviewRequestClick(final RequestAppReviewMessageDM requestAppReviewMessageDM) {
        final AcceptedAppReviewMessageDM acceptedAppReviewMessageDM = requestAppReviewMessageDM.handleRequestReviewClick(this.domain, this.platform);
        if (acceptedAppReviewMessageDM != null) {
            this.sendMessageWithAutoRetry(new F(){

                @Override
                public void f() {
                    try {
                        acceptedAppReviewMessageDM.send(ConversationDM.this.userDM, ConversationDM.this);
                        requestAppReviewMessageDM.handleAcceptedReviewSuccess(ConversationDM.this.platform);
                    }
                    catch (RootAPIException e) {
                        if (e.exceptionType == NetworkException.CONVERSATION_ARCHIVED) {
                            ConversationDM.this.updateIssueStatus(IssueState.ARCHIVED);
                        }
                        requestAppReviewMessageDM.setIsReviewButtonClickable(true);
                        throw e;
                    }
                }
            });
        }
    }

    public void initializeIssueStatusForUI() {
        if (this.state == IssueState.RESOLUTION_REQUESTED && !this.sdkConfigurationDM.shouldShowConversationResolutionQuestion()) {
            this.markConversationResolutionStatus(true);
        }
    }

    public void updateIssueStatus(IssueState newStatus) {
        if (this.state == newStatus) {
            return;
        }
        HSLogger.d(TAG, "Changing conversation status from: " + (Object)((Object)this.state) + ", new status: " + (Object)((Object)newStatus) + ", for: " + this.serverId);
        this.state = newStatus;
        this.refreshConversationOnIssueStateUpdate();
        this.conversationDAO.updateConversationWithoutMessages(this);
        if (this.conversationDMListener != null) {
            this.conversationDMListener.onIssueStatusChange(this.state);
        }
    }

    public void refreshConversationOnIssueStateUpdate() {
        switch (this.state) {
            case ARCHIVED: {
                ArrayList<UserMessageDM> unsentUserMessages = new ArrayList<UserMessageDM>();
                List<MessageDM> allMessages = this.conversationDAO.readMessages(this.localId);
                for (MessageDM message : allMessages) {
                    if (!(message instanceof UserMessageDM) || message.serverId != null) continue;
                    unsentUserMessages.add((UserMessageDM)message);
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (UserMessageDM message : unsentUserMessages) {
                    stringBuilder.append(message.body);
                    stringBuilder.append("\n");
                }
                this.platform.getConversationInboxDAO().saveConversationArchivalPrefillText(this.userDM.getLocalId(), stringBuilder.toString());
                this.handleConversationEnded();
                break;
            }
            case RESOLUTION_ACCEPTED: 
            case REJECTED: {
                this.handleConversationEnded();
            }
        }
        this.updateMessagesOnIssueStatusUpdate();
    }

    public void dropCustomMetaData() {
        this.metaDataDM.setCustomMetaDataCallable(null);
        this.metaDataDM.clearCustomMetaData();
    }

    public void setLocalId(long localId) {
        this.localId = localId;
        for (MessageDM messageDM : this.messageDMs) {
            messageDM.conversationLocalId = localId;
        }
    }

    public void handleConversationEnded() {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                ConversationDM.this.deleteOptionsForAdminMessageWithOptionsInput();
                ConversationDM.this.sendConversationEndedDelegate();
            }
        });
    }

    private void sendConversationEndedDelegate() {
        if (!this.isConversationEndedDelegateSent) {
            this.domain.getDelegate().conversationEnded();
            this.isConversationEndedDelegateSent = true;
            this.conversationDAO.updateConversationWithoutMessages(this);
        }
    }

    private void deleteOptionsForAdminMessageWithOptionsInput() {
        List<MessageDM> messageDMList = this.conversationDAO.readMessages(this.localId, MessageType.ADMIN_TEXT_WITH_OPTION_INPUT);
        for (MessageDM messageDM : messageDMList) {
            ((AdminMessageWithOptionInputDM)messageDM).input.options.clear();
        }
        this.conversationDAO.insertOrUpdateMessages(messageDMList);
    }

    void initializeMessagesForUI(boolean isConversationActive) {
        block5: {
            block4: {
                this.sortMessageDMs();
                if (!isConversationActive) break block4;
                this.isInBetweenBotExecution = this.evaluateBotExecutionState(this.messageDMs, false);
                for (MessageDM messageDM : this.messageDMs) {
                    messageDM.setDependencies(this.domain, this.platform);
                    messageDM.shouldShowAgentNameForConversation = this.showAgentName;
                    if (messageDM instanceof AdminImageAttachmentMessageDM) {
                        ((AdminImageAttachmentMessageDM)messageDM).downloadThumbnailImage(this.platform);
                    }
                    this.updateMessageOnConversationUpdate(messageDM, this.shouldEnableMessagesClick());
                    this.updateAcceptedRequestForReopenMessageDMs(messageDM);
                }
                if (this.messageDMs.size() <= 0) break block5;
                MessageDM messageDM = (MessageDM)this.messageDMs.get(this.messageDMs.size() - 1);
                if (messageDM.messageType != MessageType.USER_RESP_FOR_OPTION_INPUT && messageDM.messageType != MessageType.USER_RESP_FOR_TEXT_INPUT) break block5;
                ((UserMessageDM)messageDM).updateState(true);
                break block5;
            }
            for (MessageDM messageDM : this.messageDMs) {
                messageDM.setDependencies(this.domain, this.platform);
                messageDM.shouldShowAgentNameForConversation = this.showAgentName;
                if (messageDM instanceof AdminImageAttachmentMessageDM) {
                    ((AdminImageAttachmentMessageDM)messageDM).downloadThumbnailImage(this.platform);
                }
                this.updateMessageOnConversationUpdate(messageDM, false);
            }
        }
    }

    void initializeMessageListForUI(List<MessageDM> messageDMs, boolean isClickable) {
        for (MessageDM messageDM : messageDMs) {
            messageDM.setDependencies(this.domain, this.platform);
            messageDM.shouldShowAgentNameForConversation = this.showAgentName;
            this.updateMessageOnConversationUpdate(messageDM, isClickable);
            this.updateAcceptedRequestForReopenMessageDMs(messageDM);
        }
    }

    public void setCSATData(int csatRating, ConversationCSATState csatState, String csatFeedback) {
        this.csatRating = csatRating;
        this.csatState = csatState;
        this.csatFeedback = csatFeedback;
    }

    public boolean shouldOpen() {
        if (!this.sdkConfigurationDM.getBoolean("conversationalIssueFiling") && this.isInPreIssueMode() && StringUtils.isEmpty(this.preConversationServerId)) {
            return false;
        }
        if (this.isInPreIssueMode() && this.isIssueInProgress()) {
            return true;
        }
        boolean shouldOpen = false;
        if (this.isRedacted) {
            shouldOpen = false;
        } else if (this.isIssueInProgress() || this.state == IssueState.RESOLUTION_REQUESTED) {
            shouldOpen = true;
        } else if (this.state == IssueState.RESOLUTION_ACCEPTED || this.state == IssueState.RESOLUTION_REJECTED || this.state == IssueState.ARCHIVED) {
            shouldOpen = !this.isStartNewConversationClicked;
        } else if (this.state == IssueState.REJECTED) {
            int userMessageCount;
            shouldOpen = this.isStartNewConversationClicked ? false : (!this.isInPreIssueMode() ? true : (userMessageCount = ConversationUtil.getUserMessageCountForConversationLocalId(this.conversationDAO, this.localId)) > 0);
        }
        return shouldOpen;
    }

    public boolean isSynced() {
        return !StringUtils.isEmpty(this.serverId) || !StringUtils.isEmpty(this.preConversationServerId);
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (observable instanceof MessageDM) {
            MessageDM messageDM = (MessageDM)observable;
            int index = this.messageDMs.indexOf(messageDM);
            this.messageDMs.setAndNotifyObserver(index, messageDM);
        }
    }

    void updateMessagesOnIssueStatusUpdate() {
        boolean isClickable = this.shouldEnableMessagesClick();
        for (MessageDM messageDM : this.messageDMs) {
            this.updateMessageOnConversationUpdate(messageDM, isClickable);
        }
    }

    void updateMessageOnConversationUpdate(MessageDM messageDM, boolean isClickable) {
        this.updateMessageClickableState(messageDM, isClickable);
        if (messageDM instanceof ScreenshotMessageDM) {
            ScreenshotMessageDM screenshotMessageDM = (ScreenshotMessageDM)messageDM;
            screenshotMessageDM.checkAndReDownloadImageIfNotExist(this.platform);
        }
    }

    public boolean evaluateBotExecutionState(List<MessageDM> messages, boolean previousState) {
        if (messages == null || messages.size() == 0) {
            return previousState;
        }
        for (int i = messages.size() - 1; i >= 0; --i) {
            MessageDM message = messages.get(i);
            MessageType type = message.messageType;
            if (MessageType.ADMIN_BOT_CONTROL != type) continue;
            AdminBotControlMessageDM adminControlMessage = (AdminBotControlMessageDM)message;
            String action = adminControlMessage.actionType;
            if ("bot_started".equals(action)) {
                return true;
            }
            if (!"bot_ended".equals(action)) continue;
            return adminControlMessage.hasNextBot;
        }
        return previousState;
    }

    public MessageDM getLatestActionableBotMessage() {
        for (int i = this.messageDMs.size() - 1; i >= 0; --i) {
            MessageDM messageDM = (MessageDM)this.messageDMs.get(i);
            if (messageDM.messageType == MessageType.ADMIN_BOT_CONTROL) {
                return null;
            }
            if (messageDM.messageType == MessageType.USER_RESP_FOR_OPTION_INPUT || messageDM.messageType == MessageType.USER_RESP_FOR_TEXT_INPUT) {
                return null;
            }
            if (messageDM.messageType != MessageType.ADMIN_TEXT_WITH_TEXT_INPUT && messageDM.messageType != MessageType.ADMIN_TEXT_WITH_OPTION_INPUT && messageDM.messageType != MessageType.FAQ_LIST_WITH_OPTION_INPUT && messageDM.messageType != MessageType.OPTION_INPUT) continue;
            return messageDM;
        }
        return null;
    }

    public boolean hasBotSwitchedToAnotherBotInPollerResponse(Collection<? extends MessageDM> messageDMs) {
        if (messageDMs == null || messageDMs.size() == 0) {
            return false;
        }
        ArrayList<? extends MessageDM> messages = new ArrayList<MessageDM>(messageDMs);
        boolean hasAnotherBotStart = false;
        for (int i = messages.size() - 1; i >= 0; --i) {
            MessageDM message = (MessageDM)messages.get(i);
            MessageType type = message.messageType;
            if (MessageType.ADMIN_BOT_CONTROL != type) continue;
            AdminBotControlMessageDM adminControlMessage = (AdminBotControlMessageDM)message;
            String action = adminControlMessage.actionType;
            boolean isBotEnd = "bot_ended".equals(action);
            if (isBotEnd) {
                return hasAnotherBotStart;
            }
            if (!"bot_started".equals(action)) continue;
            hasAnotherBotStart = true;
        }
        return false;
    }

    public void updateMessagesClickOnBotSwitch(boolean shouldEnable) {
        for (MessageDM messageDM : this.messageDMs) {
            this.updateMessageClickableState(messageDM, shouldEnable);
        }
    }

    private void updateMessageClickableState(MessageDM messageDM, boolean shouldEnable) {
        if (messageDM instanceof UserMessageDM) {
            ((UserMessageDM)messageDM).updateState(shouldEnable);
        } else if (messageDM instanceof RequestScreenshotMessageDM) {
            ((RequestScreenshotMessageDM)messageDM).setAttachmentButtonClickable(shouldEnable);
        } else if (messageDM instanceof ScreenshotMessageDM) {
            ((ScreenshotMessageDM)messageDM).updateState(shouldEnable);
        }
    }

    private void evaluateBotControlMessages(Collection<? extends MessageDM> messageDMs) {
        for (MessageDM messageDM : messageDMs) {
            MessageType type = messageDM.messageType;
            switch (type) {
                case UNSUPPORTED_ADMIN_MESSAGE_WITH_INPUT: {
                    String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
                    long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
                    UnsupportedAdminMessageWithInputDM unsupportedAdminMessage = (UnsupportedAdminMessageWithInputDM)messageDM;
                    final UserBotControlMessageDM userBotControlMessageDM = new UserBotControlMessageDM("Unsupported bot input", createdAt, epochCreatedAtTime, "mobile", "bot_cancelled", "unsupported_bot_input", unsupportedAdminMessage.botInfo, unsupportedAdminMessage.serverId, 1);
                    userBotControlMessageDM.conversationLocalId = this.localId;
                    this.addMessageToDbAndUI(userBotControlMessageDM);
                    this.sendMessageWithAutoRetry(new F(){

                        @Override
                        public void f() {
                            userBotControlMessageDM.send(ConversationDM.this.userDM, ConversationDM.this);
                        }
                    });
                }
            }
        }
    }

    public boolean shouldEnableMessagesClick() {
        if (this.isInBetweenBotExecution) {
            return false;
        }
        boolean result = false;
        if (this.isIssueInProgress()) {
            result = true;
        } else if (this.state == IssueState.RESOLUTION_REQUESTED || this.state == IssueState.RESOLUTION_ACCEPTED || this.state == IssueState.ARCHIVED || this.state == IssueState.REJECTED) {
            result = false;
        } else if (this.state == IssueState.RESOLUTION_REJECTED) {
            result = this.enableMessageClickOnResolutionRejected;
        }
        return result;
    }

    private void addMessageToDBAndGlobalList(MessageDM messageDM) {
        this.conversationDAO.insertOrUpdateMessage(messageDM);
        messageDM.setDependencies(this.domain, this.platform);
        messageDM.addObserver(this);
        this.messageDMs.add(messageDM);
    }

    private void addMessageToDbAndUI(MessageDM messageDM) {
        this.conversationDAO.insertOrUpdateMessage(messageDM);
        this.addMessageToUI(messageDM);
    }

    void addMessageToUI(MessageDM messageDM) {
        messageDM.setDependencies(this.domain, this.platform);
        if (messageDM.isUISupportedMessage()) {
            messageDM.addObserver(this);
            this.messageDMs.add(messageDM);
            this.sortMessageDMs();
        }
    }

    public void sendScreenshot(ImagePickerFile imagePickerFile, String refersId) {
        String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
        long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
        ScreenshotMessageDM screenshotMessageDM = new ScreenshotMessageDM(null, createdAt, epochCreatedAtTime, "mobile", null, null, null, null, 0, false);
        screenshotMessageDM.fileName = imagePickerFile.originalFileName;
        screenshotMessageDM.filePath = imagePickerFile.filePath;
        screenshotMessageDM.setRefersMessageId(refersId);
        screenshotMessageDM.updateState(this.shouldEnableMessagesClick());
        screenshotMessageDM.conversationLocalId = this.localId;
        this.addMessageToDbAndUI(screenshotMessageDM);
        if (refersId != null) {
            for (MessageDM messageDM : this.messageDMs) {
                if (messageDM.serverId == null || !messageDM.serverId.equals(refersId) || messageDM.messageType != MessageType.REQUESTED_SCREENSHOT) continue;
                RequestScreenshotMessageDM requestScreenshotMessageDM = (RequestScreenshotMessageDM)messageDM;
                requestScreenshotMessageDM.setIsAnswered(this.platform, true);
                break;
            }
        }
        this.sendScreenshotMessageInternal(screenshotMessageDM, !imagePickerFile.isFileCompressionAndCopyingDone);
    }

    private void sendScreenshotMessageInternal(ScreenshotMessageDM screenshotMessageDM, boolean shouldCompressImage) {
        try {
            screenshotMessageDM.uploadImage(this.userDM, this, shouldCompressImage);
            if (this.state == IssueState.RESOLUTION_REJECTED) {
                this.updateIssueStatus(IssueState.WAITING_FOR_AGENT);
            }
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.CONVERSATION_ARCHIVED) {
                this.updateIssueStatus(IssueState.ARCHIVED);
            }
            throw e;
        }
    }

    void updateAcceptedRequestForReopenMessageDMs(MessageDM messageDM) {
        String referredMessageId;
        if (messageDM instanceof RequestForReopenMessageDM) {
            RequestForReopenMessageDM requestForReopenMessageDM = (RequestForReopenMessageDM)messageDM;
            if (!requestForReopenMessageDM.isAnswered()) {
                this.unansweredRequestForReopenMessageDMs.put(messageDM.serverId, requestForReopenMessageDM);
            }
        } else if (messageDM instanceof FollowupAcceptedMessageDM && this.unansweredRequestForReopenMessageDMs.containsKey(referredMessageId = ((FollowupAcceptedMessageDM)messageDM).referredMessageId)) {
            RequestForReopenMessageDM acceptedRequestForReopenMessageDM = this.unansweredRequestForReopenMessageDMs.remove(referredMessageId);
            acceptedRequestForReopenMessageDM.setDependencies(this.domain, this.platform);
            acceptedRequestForReopenMessageDM.shouldShowAgentNameForConversation = this.showAgentName;
            acceptedRequestForReopenMessageDM.setAnsweredAndNotify(true);
            this.conversationDAO.insertOrUpdateMessage(acceptedRequestForReopenMessageDM);
        }
    }

    void sortMessageDMs(List<MessageDM> messages) {
        ConversationUtil.sortMessagesBasedOnCreatedAt(messages);
    }

    public void sortMessageDMs() {
        this.sortMessageDMs(this.messageDMs);
    }

    public void setMessageDMs(List<MessageDM> messageDMs) {
        this.messageDMs = new HSObservableList<MessageDM>(messageDMs);
        this.updateStateBasedOnMessages();
    }

    public void updateStateBasedOnMessages() {
        if (this.state == IssueState.RESOLUTION_REQUESTED && this.messageDMs != null && this.messageDMs.size() > 0) {
            MessageDM lastMessage = null;
            for (int last = this.messageDMs.size() - 1; last >= 0 && ((lastMessage = (MessageDM)this.messageDMs.get(last)) instanceof FollowupRejectedMessageDM || lastMessage instanceof RequestForReopenMessageDM); --last) {
            }
            if (lastMessage instanceof ConfirmationAcceptedMessageDM) {
                this.state = IssueState.RESOLUTION_ACCEPTED;
            } else if (lastMessage instanceof ConfirmationRejectedMessageDM) {
                this.state = IssueState.RESOLUTION_REJECTED;
            }
        }
    }

    public void markConversationResolutionStatus(boolean accepted) {
        String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
        long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
        if (accepted) {
            String body = "Accepted the solution";
            final ConfirmationAcceptedMessageDM messageDM = new ConfirmationAcceptedMessageDM(body, createdAt, epochCreatedAtTime, "mobile", 1);
            messageDM.setDependencies(this.domain, this.platform);
            messageDM.conversationLocalId = this.localId;
            this.conversationDAO.insertOrUpdateMessage(messageDM);
            this.sendMessageWithAutoRetry(new F(){

                @Override
                public void f() {
                    try {
                        messageDM.send(ConversationDM.this.userDM, ConversationDM.this);
                    }
                    catch (RootAPIException e) {
                        if (e.exceptionType == NetworkException.CONVERSATION_ARCHIVED) {
                            ConversationDM.this.updateIssueStatus(IssueState.ARCHIVED);
                        }
                        throw e;
                    }
                }
            });
            this.updateIssueStatus(IssueState.RESOLUTION_ACCEPTED);
            this.domain.getAnalyticsEventDM().pushEvent(AnalyticsEventType.RESOLUTION_ACCEPTED, this.serverId);
            this.domain.getDelegate().userRepliedToConversation("User accepted the solution");
        } else {
            String body = "Did not accept the solution";
            final ConfirmationRejectedMessageDM messageDM = new ConfirmationRejectedMessageDM(body, createdAt, epochCreatedAtTime, "mobile", 1);
            messageDM.conversationLocalId = this.localId;
            this.addMessageToDbAndUI(messageDM);
            this.sendMessageWithAutoRetry(new F(){

                @Override
                public void f() {
                    try {
                        messageDM.send(ConversationDM.this.userDM, ConversationDM.this);
                    }
                    catch (RootAPIException e) {
                        if (e.exceptionType == NetworkException.CONVERSATION_ARCHIVED) {
                            ConversationDM.this.updateIssueStatus(IssueState.ARCHIVED);
                        }
                        throw e;
                    }
                }
            });
            this.updateIssueStatus(IssueState.RESOLUTION_REJECTED);
            this.domain.getAnalyticsEventDM().pushEvent(AnalyticsEventType.RESOLUTION_REJECTED, this.serverId);
            this.domain.getDelegate().userRepliedToConversation("User rejected the solution");
        }
    }

    public void sendConversationPostedEvent(ConversationDM serverConversation) {
        if (serverConversation.state == IssueState.COMPLETED_ISSUE_CREATED && serverConversation.state != this.state) {
            this.domain.getAnalyticsEventDM().pushEvent(AnalyticsEventType.CONVERSATION_POSTED, serverConversation.serverId);
        }
    }

    public void sendConversationEndedDelegateForPreIssue() {
        if (this.state == IssueState.RESOLUTION_ACCEPTED) {
            this.handleConversationEnded();
        }
    }

    public void mergePreIssue(ConversationDM serverConversation, boolean isActive, ConversationUpdate conversationUpdate) {
        IssueState newStatus;
        IssueState serverIssueState = serverConversation.state;
        switch (serverIssueState) {
            case COMPLETED_ISSUE_CREATED: {
                newStatus = IssueState.COMPLETED_ISSUE_CREATED;
                this.serverId = serverConversation.serverId;
                break;
            }
            case RESOLUTION_REQUESTED: {
                newStatus = IssueState.RESOLUTION_ACCEPTED;
                break;
            }
            default: {
                newStatus = serverIssueState;
            }
        }
        String serverMessageCursor = serverConversation.messageCursor;
        if (serverMessageCursor != null) {
            this.messageCursor = serverMessageCursor;
        }
        this.preConversationServerId = serverConversation.preConversationServerId;
        this.serverId = serverConversation.serverId;
        this.issueType = serverConversation.issueType;
        this.title = serverConversation.title;
        this.showAgentName = serverConversation.showAgentName;
        this.publishId = serverConversation.publishId;
        this.createdAt = serverConversation.createdAt;
        this.epochCreatedAtTime = serverConversation.epochCreatedAtTime;
        this.updatedAt = serverConversation.updatedAt;
        this.state = newStatus;
        this.updateMessageDMs(isActive, serverConversation.messageDMs, conversationUpdate);
    }

    public void mergeIssue(ConversationDM serverConversation, boolean isActive, ConversationUpdate conversationUpdate) {
        String serverMessageCursor;
        IssueState serverIssueState = serverConversation.state;
        IssueState newStatus = this.state;
        switch (serverIssueState) {
            case RESOLUTION_REQUESTED: {
                if (this.state == IssueState.RESOLUTION_ACCEPTED || this.state == IssueState.RESOLUTION_REJECTED) break;
                newStatus = serverIssueState;
                break;
            }
            default: {
                newStatus = serverIssueState;
            }
        }
        if ((serverMessageCursor = serverConversation.messageCursor) != null) {
            this.messageCursor = serverMessageCursor;
        }
        this.serverId = serverConversation.serverId;
        this.preConversationServerId = serverConversation.preConversationServerId;
        this.issueType = serverConversation.issueType;
        this.title = serverConversation.title;
        this.showAgentName = serverConversation.showAgentName;
        this.publishId = serverConversation.publishId;
        this.createdAt = serverConversation.createdAt;
        this.epochCreatedAtTime = serverConversation.epochCreatedAtTime;
        this.isRedacted = serverConversation.isRedacted;
        this.updatedAt = serverConversation.updatedAt;
        if (serverConversation.csatState == ConversationCSATState.SUBMITTED_SYNCED) {
            this.csatState = serverConversation.csatState;
        }
        this.state = newStatus;
        this.updateMessageDMs(isActive, serverConversation.messageDMs, conversationUpdate);
    }

    private Map<String, String> getLocalIdToPendingRequestIdMessageMap() {
        return this.platform.getNetworkRequestDAO().getPendingRequestIdMapForRoute(this.getRouteForSendingMessage());
    }

    private String getRouteForSendingMessage() {
        String route = this.isInPreIssueMode() ? "/preissues/" + this.getPreIssueId() + "/messages/" : "/issues/" + this.getIssueId() + "/messages/";
        return route;
    }

    public void markMessagesAsSeen() {
        List<MessageDM> allMessages = this.conversationDAO.readMessages(this.localId);
        HashSet<Long> unseenMessagesLocalId = new HashSet<Long>();
        for (MessageDM messageDM : allMessages) {
            if (messageDM.deliveryState == 1) continue;
            switch (messageDM.messageType) {
                case ADMIN_TEXT: 
                case ADMIN_TEXT_WITH_TEXT_INPUT: 
                case ADMIN_TEXT_WITH_OPTION_INPUT: 
                case FAQ_LIST: 
                case FAQ_LIST_WITH_OPTION_INPUT: 
                case ADMIN_ATTACHMENT: 
                case ADMIN_IMAGE_ATTACHMENT: 
                case REQUEST_FOR_REOPEN: 
                case REQUESTED_SCREENSHOT: 
                case REQUESTED_APP_REVIEW: {
                    unseenMessagesLocalId.add(messageDM.localId);
                }
            }
        }
        if (unseenMessagesLocalId.size() == 0) {
            return;
        }
        this.markSeenMessagesAsRead(unseenMessagesLocalId);
    }

    public void markSeenMessagesAsRead(Set<Long> unseenMessagesLocalId) {
        String readAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
        HashMap<Long, MessageDM> uiMessageDMsMap = new HashMap<Long, MessageDM>();
        ArrayList<MessageDM> unseenMessages = new ArrayList<MessageDM>();
        for (MessageDM messageDM : this.messageDMs) {
            if (messageDM.localId == null) continue;
            uiMessageDMsMap.put(messageDM.localId, messageDM);
        }
        for (Long messageLocalId : unseenMessagesLocalId) {
            MessageDM uiMessageDM = (MessageDM)uiMessageDMsMap.get(messageLocalId);
            if (uiMessageDM == null) continue;
            uiMessageDM.readAt = readAt;
            uiMessageDM.deliveryState = 1;
            uiMessageDM.seenAtMessageCursor = this.messageCursor;
            unseenMessages.add(uiMessageDM);
        }
        if (ListUtils.isEmpty(unseenMessages)) {
            return;
        }
        this.platform.getConversationDAO().insertOrUpdateMessages(unseenMessages);
        this.markMessagesAsSeen(unseenMessages);
    }

    private void markMessagesAsSeen(List<MessageDM> messages) {
        if (ListUtils.isEmpty(messages)) {
            return;
        }
        String readAt = messages.get((int)0).readAt;
        String seenAtMessageCursor = messages.get((int)0).seenAtMessageCursor;
        HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(this.userDM);
        data.put("read_at", readAt);
        data.put("mc", seenAtMessageCursor);
        data.put("md_state", "read");
        String route = this.getRouteForSendingMessage();
        try {
            Network putNetwork = new PUTNetwork(route, this.domain, this.platform);
            putNetwork = new AuthenticationFailureNetwork(putNetwork);
            TSCorrectedNetwork tsCorrectedNetwork = new TSCorrectedNetwork(putNetwork, this.platform);
            Network network = new FailedAPICallNetworkDecorator(tsCorrectedNetwork);
            network = new GuardOKNetwork(network);
            network.makeRequest(new RequestData(data));
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.INVALID_AUTH_TOKEN || e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
                this.domain.getAuthenticationFailureDM().notifyAuthenticationFailure(this.userDM, e.exceptionType);
            }
            throw e;
        }
        for (MessageDM message : messages) {
            message.isMessageSeenSynced = true;
        }
        this.platform.getConversationDAO().insertOrUpdateMessages(messages);
    }

    public void setEnableMessageClickOnResolutionRejected(boolean isEnable) {
        this.enableMessageClickOnResolutionRejected = isEnable;
        if (this.state == IssueState.RESOLUTION_REJECTED) {
            this.updateMessagesOnIssueStatusUpdate();
        }
    }

    public boolean shouldShowCSATInFooter() {
        if (this.isInPreIssueMode()) {
            return false;
        }
        return this.csatState == ConversationCSATState.NONE && this.sdkConfigurationDM.getBoolean("customerSatisfactionSurvey");
    }

    public void sendCSATSurvey(int rating, String feedback) {
        int HighestRating = 5;
        if (rating > HighestRating) {
            rating = HighestRating;
        } else if (rating < 0) {
            rating = 0;
        }
        this.csatRating = rating;
        if (feedback != null) {
            feedback = feedback.trim();
        }
        this.csatFeedback = feedback;
        this.setCSATState(ConversationCSATState.SUBMITTED_NOT_SYNCED);
        this.sendMessageWithAutoRetry(new F(){

            @Override
            public void f() {
                ConversationDM.this.sendCSATSurveyInternal();
            }
        });
        this.domain.getDelegate().userCompletedCustomerSatisfactionSurvey(this.csatRating, this.csatFeedback);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendCSATSurveyInternal() {
        String url = "/issues/" + this.serverId + "/customer-survey/";
        HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(this.userDM);
        data.put("rating", String.valueOf(this.csatRating));
        data.put("feedback", this.csatFeedback);
        ConversationCSATState newState = null;
        Network network = new POSTNetwork(url, this.domain, this.platform);
        SuccessOrNonRetriableStatusCodeIdempotentPolicy idempotentPolicy = new SuccessOrNonRetriableStatusCodeIdempotentPolicy();
        network = new IdempotentNetwork(network, this.platform, idempotentPolicy, url, this.serverId);
        network = new TSCorrectedNetwork(network, this.platform);
        network = new FailedAPICallNetworkDecorator(network);
        network = new GuardOKNetwork(network);
        try {
            RequestData requestData = new RequestData(data);
            network.makeRequest(requestData);
            newState = ConversationCSATState.SUBMITTED_SYNCED;
            if (newState == null) return;
        }
        catch (RootAPIException e) {
            try {
                if (e.exceptionType == NetworkException.INVALID_AUTH_TOKEN || e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
                    this.domain.getAuthenticationFailureDM().notifyAuthenticationFailure(this.userDM, e.exceptionType);
                    throw e;
                } else {
                    if (e.exceptionType != NetworkException.NON_RETRIABLE) throw e;
                    newState = ConversationCSATState.SUBMITTED_SYNCED;
                }
                throw e;
            }
            catch (Throwable throwable) {
                if (newState == null) throw throwable;
                this.setCSATState(newState);
                throw throwable;
            }
        }
        this.setCSATState(newState);
        return;
    }

    private void setCSATState(ConversationCSATState state) {
        if (this.csatState != state) {
            HSLogger.d(TAG, "Update CSAT state : Conversation : " + this.serverId + ", state : " + state.toString());
        }
        this.csatState = state;
        this.conversationDAO.updateConversationWithoutMessages(this);
    }

    public boolean checkForReOpen(int conversationViewState, String openConversationId, boolean isActiveConversationInPreIssueMode) {
        boolean isIssueStatusChange = false;
        if (this.messageDMs != null && this.messageDMs.size() > 0) {
            MessageDM lastMessageDM = (MessageDM)this.messageDMs.get(this.messageDMs.size() - 1);
            if (!(lastMessageDM instanceof RequestForReopenMessageDM)) {
                return isIssueStatusChange;
            }
            if (((RequestForReopenMessageDM)lastMessageDM).isAnswered()) {
                return isIssueStatusChange;
            }
            if (conversationViewState == 1) {
                this.sendReOpenRejectedMessage(1, null, lastMessageDM.serverId);
            } else if (isActiveConversationInPreIssueMode) {
                this.sendReOpenRejectedMessage(4, null, lastMessageDM.serverId);
            } else if (conversationViewState == 2) {
                this.sendReOpenRejectedMessage(3, null, lastMessageDM.serverId);
            } else if (openConversationId != null && !openConversationId.equals(this.serverId)) {
                this.sendReOpenRejectedMessage(2, openConversationId, lastMessageDM.serverId);
            } else {
                this.state = IssueState.WAITING_FOR_AGENT;
                this.isConversationEndedDelegateSent = false;
                this.conversationDAO.updateConversationWithoutMessages(this);
                String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
                long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
                final FollowupAcceptedMessageDM followupAcceptedMessageDM = new FollowupAcceptedMessageDM(null, createdAt, epochCreatedAtTime, "mobile", lastMessageDM.serverId, 1);
                followupAcceptedMessageDM.conversationLocalId = this.localId;
                followupAcceptedMessageDM.setDependencies(this.domain, this.platform);
                this.addMessageToDBAndGlobalList(followupAcceptedMessageDM);
                RequestForReopenMessageDM requestForReopenMessageDM = (RequestForReopenMessageDM)lastMessageDM;
                requestForReopenMessageDM.setAnsweredAndNotify(true);
                this.platform.getConversationDAO().insertOrUpdateMessage(requestForReopenMessageDM);
                this.sendMessageWithAutoRetry(new F(){

                    @Override
                    public void f() {
                        followupAcceptedMessageDM.send(ConversationDM.this.userDM, ConversationDM.this);
                    }
                });
                isIssueStatusChange = true;
            }
        }
        return isIssueStatusChange;
    }

    private void sendMessageWithAutoRetry(final F f) {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                block2: {
                    try {
                        f.f();
                    }
                    catch (RootAPIException e) {
                        ExceptionType exceptionType = e.exceptionType;
                        if (exceptionType == NetworkException.NON_RETRIABLE || exceptionType == NetworkException.USER_PRE_CONDITION_FAILED) break block2;
                        ConversationDM.this.domain.getAutoRetryFailedEventDM().scheduleRetryTaskForEventType(AutoRetryFailedEventDM.EventType.CONVERSATION, e.getServerStatusCode());
                        throw e;
                    }
                }
            }
        });
    }

    private void sendReOpenRejectedMessage(int reason, String openConversationId, String referId) {
        String createdAt = HSDateFormatSpec.getCurrentAdjustedTimeForStorage(this.platform);
        long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createdAt);
        final FollowupRejectedMessageDM followupRejectedMessageDM = new FollowupRejectedMessageDM(null, createdAt, epochCreatedAtTime, "mobile", referId, 1);
        followupRejectedMessageDM.reason = reason;
        followupRejectedMessageDM.openConversationId = openConversationId;
        followupRejectedMessageDM.conversationLocalId = this.localId;
        followupRejectedMessageDM.setDependencies(this.domain, this.platform);
        this.addMessageToDBAndGlobalList(followupRejectedMessageDM);
        this.sendMessageWithAutoRetry(new F(){

            @Override
            public void f() {
                followupRejectedMessageDM.send(ConversationDM.this.userDM, ConversationDM.this);
            }
        });
    }

    public void setStartNewConversationButtonClicked(boolean isStartNewConversationClicked, boolean updateInDb) {
        this.isStartNewConversationClicked = isStartNewConversationClicked;
        if (updateInDb) {
            this.conversationDAO.updateConversationWithoutMessages(this);
        }
    }

    public void setShouldIncrementMessageCount(boolean val, boolean updateInDb) {
        if (this.shouldIncrementMessageCount != val) {
            this.shouldIncrementMessageCount = val;
            if (updateInDb) {
                this.conversationDAO.updateConversationWithoutMessages(this);
            }
        }
    }

    public int getUnSeenMessageCount() {
        if (!this.shouldOpen()) {
            return 0;
        }
        List<MessageDM> messageDMs = this.conversationDAO.readMessages(this.localId);
        int unreadMessageCount = 0;
        if (messageDMs != null) {
            for (MessageDM messageDM : messageDMs) {
                if (!messageDM.isUISupportedMessage() || messageDM.deliveryState == 1) continue;
                switch (messageDM.messageType) {
                    case ADMIN_TEXT_WITH_TEXT_INPUT: {
                        if (!(messageDM instanceof AdminMessageWithTextInputDM) || ((AdminMessageWithTextInputDM)messageDM).isMessageEmpty) break;
                        ++unreadMessageCount;
                        break;
                    }
                    case ADMIN_TEXT: 
                    case ADMIN_TEXT_WITH_OPTION_INPUT: 
                    case FAQ_LIST: 
                    case FAQ_LIST_WITH_OPTION_INPUT: 
                    case ADMIN_ATTACHMENT: 
                    case ADMIN_IMAGE_ATTACHMENT: 
                    case REQUEST_FOR_REOPEN: 
                    case REQUESTED_SCREENSHOT: 
                    case REQUESTED_APP_REVIEW: {
                        ++unreadMessageCount;
                    }
                }
            }
        }
        if (this.shouldIncrementMessageCount) {
            ++unreadMessageCount;
        }
        return unreadMessageCount;
    }

    public void retryMessages(boolean isActive) {
        List<MessageDM> allMessages = this.conversationDAO.readMessages(this.localId);
        ArrayList<AutoRetriableMessageDM> failedMessages = new ArrayList<AutoRetriableMessageDM>();
        ArrayList<MessageDM> failedMessageSeens = new ArrayList<MessageDM>();
        HashMap<String, RequestAppReviewMessageDM> rarMessagesMap = new HashMap<String, RequestAppReviewMessageDM>();
        ArrayList<FAQListMessageDM> suggestionsReadPendingEvents = new ArrayList<FAQListMessageDM>();
        for (MessageDM message : allMessages) {
            FAQListMessageDM faqListMessageDM;
            if (message instanceof AutoRetriableMessageDM && ((AutoRetriableMessageDM)message).isRetriable()) {
                failedMessages.add((AutoRetriableMessageDM)message);
            }
            if (!StringUtils.isEmpty(message.readAt) && !message.isMessageSeenSynced) {
                failedMessageSeens.add(message);
            }
            if (message instanceof RequestAppReviewMessageDM) {
                rarMessagesMap.put(message.serverId, (RequestAppReviewMessageDM)message);
            }
            if (!(message instanceof FAQListMessageDM) || !(faqListMessageDM = (FAQListMessageDM)message).isSuggestionsReadEventPending()) continue;
            suggestionsReadPendingEvents.add(faqListMessageDM);
        }
        for (AutoRetriableMessageDM failedMessage : failedMessages) {
            if (this.state == IssueState.ARCHIVED || this.state == IssueState.AUTHOR_MISMATCH) {
                return;
            }
            try {
                failedMessage.setDependencies(this.domain, this.platform);
                failedMessage.send(this.userDM, this);
                if (!(failedMessage instanceof AcceptedAppReviewMessageDM)) continue;
                ArrayList<MessageDM> uiMessages = new ArrayList<MessageDM>();
                AcceptedAppReviewMessageDM acceptedAppReviewMessageDM = (AcceptedAppReviewMessageDM)failedMessage;
                String referredMessageId = acceptedAppReviewMessageDM.referredMessageId;
                if (rarMessagesMap.containsKey(referredMessageId)) {
                    RequestAppReviewMessageDM rarMessage = (RequestAppReviewMessageDM)rarMessagesMap.get(referredMessageId);
                    rarMessage.handleAcceptedReviewSuccess(this.platform);
                    uiMessages.add(rarMessage);
                }
                if (!isActive) continue;
                uiMessages.add(failedMessage);
                this.addMessageToUI(acceptedAppReviewMessageDM);
                this.updateMessageDMs(true, uiMessages, null);
            }
            catch (RootAPIException e) {
                if (e.exceptionType == NetworkException.CONVERSATION_ARCHIVED) {
                    this.updateIssueStatus(IssueState.ARCHIVED);
                    continue;
                }
                if (e.exceptionType == NetworkException.USER_PRE_CONDITION_FAILED) {
                    this.updateIssueStatus(IssueState.AUTHOR_MISMATCH);
                    continue;
                }
                if (e.exceptionType == NetworkException.NON_RETRIABLE) continue;
                throw e;
            }
        }
        HashMap<String, ArrayList<MessageDM>> readAtMessagesMap = new HashMap<String, ArrayList<MessageDM>>();
        for (MessageDM message : failedMessageSeens) {
            String readAt = message.readAt;
            ArrayList<MessageDM> readAtMessages = (ArrayList<MessageDM>)readAtMessagesMap.get(readAt);
            if (readAtMessages == null) {
                readAtMessages = new ArrayList<MessageDM>();
            }
            readAtMessages.add(message);
            readAtMessagesMap.put(readAt, readAtMessages);
        }
        for (String readAt : readAtMessagesMap.keySet()) {
            try {
                this.markMessagesAsSeen((List)readAtMessagesMap.get(readAt));
            }
            catch (RootAPIException e) {
                if (e.exceptionType == NetworkException.NON_RETRIABLE) continue;
                throw e;
            }
        }
        for (FAQListMessageDM suggestionsReadPendingEvent : suggestionsReadPendingEvents) {
            suggestionsReadPendingEvent.setDependencies(this.domain, this.platform);
            suggestionsReadPendingEvent.sendSuggestionReadEvent(this, this.userDM);
        }
    }

    public void checkAndIncrementMessageCount(IssueState oldStatus) {
        if (this.isInProgressState(oldStatus) && (this.state == IssueState.RESOLUTION_REQUESTED || this.state == IssueState.RESOLUTION_ACCEPTED || this.state == IssueState.RESOLUTION_REJECTED)) {
            this.setShouldIncrementMessageCount(true, true);
        } else if (this.isIssueInProgress()) {
            this.setShouldIncrementMessageCount(false, true);
        }
    }

    public void deleteCachedScreenshotFiles() {
        List<MessageDM> messageDMs = this.conversationDAO.readMessages(this.localId);
        ArrayList<MessageDM> updatedMessageDMs = new ArrayList<MessageDM>();
        for (MessageDM messageDM : messageDMs) {
            ScreenshotMessageDM screenshotMessageDM;
            String filePath;
            if (!(messageDM instanceof ScreenshotMessageDM) || (filePath = (screenshotMessageDM = (ScreenshotMessageDM)messageDM).getFilePath()) == null) continue;
            try {
                File file = new File(filePath);
                if (!file.delete()) continue;
                screenshotMessageDM.filePath = null;
                updatedMessageDMs.add(screenshotMessageDM);
            }
            catch (Exception exception) {}
        }
        this.conversationDAO.insertOrUpdateMessages(updatedMessageDMs);
    }

    @Override
    public boolean isInPreIssueMode() {
        return "preissue".equals(this.issueType);
    }

    @Override
    public String getIssueId() {
        return this.serverId;
    }

    @Override
    public String getPreIssueId() {
        return this.preConversationServerId;
    }

    public void updateLastUserActivityTime(long lastUserActivityTime) {
        this.lastUserActivityTime = lastUserActivityTime;
        this.conversationDAO.updateLastUserActivityTimeInConversation(this.localId, lastUserActivityTime);
    }

    public boolean isIssueInProgress() {
        return this.isInProgressState(this.state);
    }

    public boolean isInProgressState(IssueState state) {
        return state == IssueState.NEW || state == IssueState.NEW_FOR_AGENT || state == IssueState.AGENT_REPLIED || state == IssueState.WAITING_FOR_AGENT || state == IssueState.PENDING_REASSIGNMENT || state == IssueState.COMPLETED_ISSUE_CREATED;
    }

    public void handleAdminSuggestedQuestionRead(String messageServerId, final String questionServerId, final String questionPublishId) {
        for (final MessageDM messageDM : this.messageDMs) {
            if (!(messageDM instanceof FAQListMessageDM) || !messageServerId.equals(messageDM.serverId)) continue;
            this.sendMessageWithAutoRetry(new F(){

                @Override
                public void f() {
                    ((FAQListMessageDM)messageDM).handleSuggestionClick(ConversationDM.this, ConversationDM.this.userDM, questionServerId, questionPublishId);
                }
            });
            break;
        }
    }

    public void handlePreIssueCreationSuccess() {
        this.lastUserActivityTime = System.currentTimeMillis();
    }

    private void populateMessageDMLookup(boolean isConversationDMInMemory, Map<String, MessageDM> messageDMLookupByServerId, Map<String, MessageDM> messageDMLookupByRequestId) {
        Iterator<MessageDM> messageDMsIterator;
        if (isConversationDMInMemory) {
            ArrayList<MessageDM> combinedMessages = new ArrayList<MessageDM>();
            List<MessageDM> messagesFromDB = this.conversationDAO.readMessages(this.localId);
            HashMap<Long, MessageDM> inMemoryMessagesLookup = new HashMap<Long, MessageDM>();
            for (MessageDM messageDM : this.messageDMs) {
                if (messageDM.localId == null) continue;
                inMemoryMessagesLookup.put(messageDM.localId, messageDM);
            }
            for (MessageDM messageFromDB : messagesFromDB) {
                MessageDM correspondingInMemoryMessage = (MessageDM)inMemoryMessagesLookup.get(messageFromDB.localId);
                if (correspondingInMemoryMessage == null) {
                    combinedMessages.add(messageFromDB);
                    continue;
                }
                combinedMessages.add(correspondingInMemoryMessage);
            }
            messageDMsIterator = combinedMessages.iterator();
        } else {
            messageDMsIterator = this.conversationDAO.readMessages(this.localId).iterator();
        }
        Map<String, String> messageDMLocalIdToPendingRequestIdMap = this.getLocalIdToPendingRequestIdMessageMap();
        while (messageDMsIterator.hasNext()) {
            MessageDM messageDM = messageDMsIterator.next();
            if (!StringUtils.isEmpty(messageDM.serverId)) {
                messageDMLookupByServerId.put(messageDM.serverId, messageDM);
            }
            if (messageDM.localId == null) continue;
            String localIdString = String.valueOf(messageDM.localId);
            if (messageDMLocalIdToPendingRequestIdMap == null || !messageDMLocalIdToPendingRequestIdMap.containsKey(localIdString)) continue;
            messageDMLookupByRequestId.put(messageDMLocalIdToPendingRequestIdMap.get(localIdString), messageDM);
        }
    }

    private MessageDM getMessageDMForUpdate(MessageDM serverMessageDM, Map<String, MessageDM> messageDMLookupByServerId, Map<String, MessageDM> messageDMLookupByRequestId, ConversationUpdate conversationUpdate) {
        MessageDM messageDMForUpdate = null;
        if (messageDMLookupByServerId.containsKey(serverMessageDM.serverId)) {
            messageDMForUpdate = messageDMLookupByServerId.get(serverMessageDM.serverId);
        } else if (messageDMLookupByRequestId.containsKey(serverMessageDM.createdRequestId)) {
            messageDMForUpdate = messageDMLookupByRequestId.get(serverMessageDM.createdRequestId);
            conversationUpdate.localIdsForResolvedRequestIds.add(String.valueOf(messageDMForUpdate.localId));
        }
        return messageDMForUpdate;
    }

    public void mergeMessageFromConversationHistory(List<MessageDM> serverMessageDMs, ConversationUpdate conversationUpdate) {
        if (!ListUtils.isEmpty(serverMessageDMs)) {
            this.updateMessageDMs(false, serverMessageDMs, conversationUpdate);
        }
    }

    void updateMessageDMs(boolean isConversationDMInMemory, List<MessageDM> serverMessageDMs, ConversationUpdate conversationUpdate) {
        if (conversationUpdate == null) {
            conversationUpdate = new ConversationUpdate();
        }
        HashMap<String, MessageDM> messageDMLookupByServerId = new HashMap<String, MessageDM>();
        HashMap<String, MessageDM> messageDMLookupByRequestId = new HashMap<String, MessageDM>();
        this.populateMessageDMLookup(isConversationDMInMemory, messageDMLookupByServerId, messageDMLookupByRequestId);
        ArrayList<MessageDM> newMessagesList = new ArrayList<MessageDM>();
        for (MessageDM serverMessageDM : serverMessageDMs) {
            MessageDM messageDMForUpdate = this.getMessageDMForUpdate(serverMessageDM, messageDMLookupByServerId, messageDMLookupByRequestId, conversationUpdate);
            if (messageDMForUpdate != null) {
                if (messageDMForUpdate instanceof UserMessageDM) {
                    messageDMForUpdate.merge(serverMessageDM);
                    ((UserMessageDM)messageDMForUpdate).setState(UserMessageState.SENT);
                } else if (messageDMForUpdate instanceof ScreenshotMessageDM) {
                    messageDMForUpdate.merge(serverMessageDM);
                    ((ScreenshotMessageDM)messageDMForUpdate).setState(UserMessageState.SENT);
                } else {
                    messageDMForUpdate.mergeAndNotify(serverMessageDM);
                }
                conversationUpdate.updatedMessageDMs.add(messageDMForUpdate);
                continue;
            }
            newMessagesList.add(serverMessageDM);
        }
        if (ListUtils.isEmpty(newMessagesList)) {
            return;
        }
        for (MessageDM messageDM : newMessagesList) {
            messageDM.setDependencies(this.domain, this.platform);
            messageDM.conversationLocalId = this.localId;
            messageDM.shouldShowAgentNameForConversation = this.showAgentName;
            if (messageDM instanceof UserMessageDM) {
                ((UserMessageDM)messageDM).setState(UserMessageState.SENT);
            } else if (messageDM instanceof ScreenshotMessageDM) {
                ((ScreenshotMessageDM)messageDM).setState(UserMessageState.SENT);
            }
            messageDM.addObserver(this);
        }
        if (isConversationDMInMemory) {
            this.sortMessageDMs(newMessagesList);
            this.isInBetweenBotExecution = this.evaluateBotExecutionState(newMessagesList, this.isInBetweenBotExecution);
            this.messageDMs.addAll((Collection<MessageDM>)newMessagesList);
            for (MessageDM messageDM : newMessagesList) {
                if (messageDM instanceof AdminImageAttachmentMessageDM) {
                    ((AdminImageAttachmentMessageDM)messageDM).downloadThumbnailImage(this.platform);
                }
                this.updateAcceptedRequestForReopenMessageDMs(messageDM);
            }
        } else {
            this.messageDMs.addAll((Collection<MessageDM>)newMessagesList);
        }
        conversationUpdate.newMessageDMs.addAll(newMessagesList);
        this.evaluateBotControlMessages(newMessagesList);
    }

    public void clearMessageUpdates(ConversationUpdate conversationUpdate) {
        for (int i = 0; i < conversationUpdate.localIdsForResolvedRequestIds.size(); ++i) {
            this.platform.getNetworkRequestDAO().deletePendingRequestId(this.getRouteForSendingMessage(), conversationUpdate.localIdsForResolvedRequestIds.remove(i));
        }
        conversationUpdate.updatedMessageDMs.clear();
        conversationUpdate.newMessageDMs.clear();
    }

    public boolean containsAtleastOneUserMessage() {
        if (this.isInPreIssueMode()) {
            ArrayList<MessageDM> uiMessageDMs = new ArrayList<MessageDM>();
            for (MessageDM messageDM : this.messageDMs) {
                if (!messageDM.isUISupportedMessage()) continue;
                if (messageDM instanceof UserMessageDM) {
                    return true;
                }
                uiMessageDMs.add(messageDM);
                if (uiMessageDMs.size() <= 3) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    void setListener(ConversationDMListener conversationDMListener) {
        this.conversationDMListener = conversationDMListener;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        if (!StringUtils.isEmpty(createdAt)) {
            this.createdAt = createdAt;
        }
    }

    public long getEpochCreatedAtTime() {
        return this.epochCreatedAtTime;
    }

    public void setEpochCreatedAtTime(long epochCreatedAtTime) {
        this.epochCreatedAtTime = epochCreatedAtTime;
    }
}

