/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.ListUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.util.HSListObserver;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.PaginationCursor;
import com.helpshift.conversation.activeconversation.ViewableConversation;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.loaders.ConversationHistoryLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConversationHistoryDM
extends ViewableConversation {
    public static final Long CONVERSATION_HISTORY_DM_IDENTIFIER = -1L;
    private List<ConversationDM> conversationDMs;

    public ConversationHistoryDM(Platform platform, Domain domain, UserDM userDM, ConversationHistoryLoader conversationsLoader) {
        super(platform, domain, userDM, conversationsLoader);
    }

    @Override
    public synchronized void init() {
        this.conversationDMs = this.conversationLoader.fetchInitialConversations();
        for (ConversationDM conversationDM : this.conversationDMs) {
            conversationDM.setDependencies(this.platform, this.domain, this.userDM);
            conversationDM.updateStateBasedOnMessages();
        }
    }

    @Override
    public Long getIdentifier() {
        return CONVERSATION_HISTORY_DM_IDENTIFIER;
    }

    @Override
    public boolean shouldOpen() {
        return true;
    }

    @Override
    public synchronized ConversationDM getActiveConversation() {
        return this.conversationDMs.get(this.conversationDMs.size() - 1);
    }

    @Override
    public synchronized void initializeConversationsForUI() {
        long activeConversationLocalID = this.getActiveConversation().localId;
        for (ConversationDM conversationDM : this.conversationDMs) {
            boolean isActive = conversationDM.localId.equals(activeConversationLocalID);
            conversationDM.initializeMessagesForUI(isActive);
        }
    }

    @Override
    public synchronized void registerMessagesObserver(HSListObserver<MessageDM> observer) {
        for (ConversationDM conversationDM : this.conversationDMs) {
            conversationDM.messageDMs.setObserver(observer);
            conversationDM.registerMessagesObserver();
        }
    }

    @Override
    public synchronized void onNewConversationStarted(ConversationDM conversationDM) {
        conversationDM.setListener(this);
        this.conversationDMs.add(conversationDM);
    }

    @Override
    public synchronized List<ConversationDM> getAllConversations() {
        return new ArrayList<ConversationDM>(this.conversationDMs);
    }

    @Override
    public synchronized void prependConversations(List<ConversationDM> conversations) {
        HashMap<Long, ConversationDM> localLookUpConversationMap = new HashMap<Long, ConversationDM>();
        for (ConversationDM conversationDM : this.conversationDMs) {
            localLookUpConversationMap.put(conversationDM.localId, conversationDM);
        }
        int inputListSize = conversations.size();
        ArrayList<ConversationDM> prependConversationsList = new ArrayList<ConversationDM>();
        for (int index = 0; index < inputListSize; ++index) {
            ConversationDM inputConversation = conversations.get(index);
            ConversationDM localConversationDM = (ConversationDM)localLookUpConversationMap.get(inputConversation.localId);
            if (localConversationDM != null) {
                localConversationDM.messageDMs.prependItems(inputConversation.messageDMs);
                continue;
            }
            prependConversationsList.add(inputConversation);
        }
        if (!ListUtils.isEmpty(prependConversationsList)) {
            this.conversationDMs.addAll(0, prependConversationsList);
        }
    }

    @Override
    public synchronized PaginationCursor getPaginationCursor() {
        if (!ListUtils.isEmpty(this.conversationDMs)) {
            ConversationDM firstConversation = this.conversationDMs.get(0);
            return this.buildPaginationCursor(firstConversation);
        }
        return null;
    }
}

