/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.util.HSListObserver;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.PaginationCursor;
import com.helpshift.conversation.activeconversation.ViewableConversation;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.loaders.SingleConversationLoader;
import java.util.Collections;
import java.util.List;

public class SingleConversationDM
extends ViewableConversation {
    private ConversationDM conversationDM;

    public SingleConversationDM(Platform platform, Domain domain, UserDM userDM, SingleConversationLoader singleConversationLoader) {
        super(platform, domain, userDM, singleConversationLoader);
    }

    @Override
    public synchronized void init() {
        List<ConversationDM> conversationDMs = this.conversationLoader.fetchInitialConversations();
        this.conversationDM = conversationDMs.get(0);
        this.conversationDM.setDependencies(this.platform, this.domain, this.userDM);
    }

    @Override
    public Long getIdentifier() {
        return this.conversationDM.localId;
    }

    @Override
    public boolean shouldOpen() {
        return this.conversationDM.shouldOpen();
    }

    @Override
    public ConversationDM getActiveConversation() {
        return this.conversationDM;
    }

    @Override
    public void initializeConversationsForUI() {
        this.conversationDM.initializeMessagesForUI(true);
    }

    @Override
    public void registerMessagesObserver(HSListObserver<MessageDM> observer) {
        this.conversationDM.messageDMs.setObserver(observer);
        this.conversationDM.registerMessagesObserver();
    }

    @Override
    public void onNewConversationStarted(ConversationDM conversationDM) {
    }

    @Override
    public List<ConversationDM> getAllConversations() {
        return Collections.singletonList(this.conversationDM);
    }

    @Override
    public void prependConversations(List<ConversationDM> conversations) {
        int inputListSize = conversations.size();
        for (int index = 0; index < inputListSize; ++index) {
            ConversationDM inputConversation = conversations.get(index);
            if (!this.conversationDM.localId.equals(inputConversation.localId)) continue;
            this.conversationDM.messageDMs.prependItems(inputConversation.messageDMs);
        }
    }

    @Override
    public PaginationCursor getPaginationCursor() {
        return this.buildPaginationCursor(this.conversationDM);
    }
}

