/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.util.HSListObserver;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.ConversationDMListener;
import com.helpshift.conversation.activeconversation.ConversationUpdate;
import com.helpshift.conversation.activeconversation.LiveUpdateDM;
import com.helpshift.conversation.activeconversation.PaginationCursor;
import com.helpshift.conversation.activeconversation.UIConversation;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.dto.IssueState;
import com.helpshift.conversation.loaders.ConversationsLoader;
import com.helpshift.conversation.viewmodel.ConversationVMCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ViewableConversation
implements ConversationDMListener,
LiveUpdateDM.TypingIndicatorListener,
ConversationsLoader.LoadMoreConversationsCallback {
    protected ConversationsLoader conversationLoader;
    protected Platform platform;
    protected Domain domain;
    protected UserDM userDM;
    protected LiveUpdateDM liveUpdateDM;
    private ConversationVMCallback conversationVMCallback;
    private SDKConfigurationDM sdkConfigurationDM;
    private AtomicBoolean isLoadMoreInProgress = new AtomicBoolean(false);

    public ViewableConversation(Platform platform, Domain domain, UserDM userDM, ConversationsLoader conversationLoader) {
        this.platform = platform;
        this.domain = domain;
        this.userDM = userDM;
        this.conversationLoader = conversationLoader;
        this.sdkConfigurationDM = domain.getSDKConfigurationDM();
    }

    public void setLiveUpdateDM(LiveUpdateDM liveUpdateDM) {
        this.liveUpdateDM = liveUpdateDM;
    }

    public boolean isVisibleOnUI() {
        return this.conversationVMCallback != null && this.conversationVMCallback.isVisibleOnUI();
    }

    public boolean isConversationVMAttached() {
        return this.conversationVMCallback != null;
    }

    public void onScreenshotMessageClicked(ScreenshotMessageDM messageDM) {
        messageDM.handleClick(this.conversationVMCallback);
    }

    public void onAdminAttachmentMessageClicked(AttachmentMessageDM message) {
        switch (message.messageType) {
            case ADMIN_IMAGE_ATTACHMENT: {
                AdminImageAttachmentMessageDM imageAttachmentMessageDM = (AdminImageAttachmentMessageDM)message;
                imageAttachmentMessageDM.handleClick(this.conversationVMCallback);
                break;
            }
            case ADMIN_ATTACHMENT: {
                AdminAttachmentMessageDM attachmentMessageDM = (AdminAttachmentMessageDM)message;
                attachmentMessageDM.handleClick(this.conversationVMCallback);
            }
        }
    }

    public void mergePreIssue(ConversationDM serverConversation, ConversationUpdate conversationUpdate) {
        IssueState newState;
        ConversationDM activeConversation = this.getActiveConversation();
        IssueState oldState = activeConversation.state;
        activeConversation.mergePreIssue(serverConversation, true, conversationUpdate);
        if (this.conversationVMCallback != null) {
            this.conversationVMCallback.onConversationInboxPollSuccess();
        }
        if ((newState = activeConversation.state) != oldState) {
            activeConversation.refreshConversationOnIssueStateUpdate();
            this.onIssueStatusChange(newState);
        }
    }

    public void mergeIssue(ConversationDM serverConversation, ConversationUpdate conversationUpdate) {
        IssueState newState;
        ConversationDM activeConversation = this.getActiveConversation();
        IssueState oldState = activeConversation.state;
        String oldIssueType = activeConversation.issueType;
        activeConversation.mergeIssue(serverConversation, true, conversationUpdate);
        if (this.conversationVMCallback != null) {
            this.conversationVMCallback.onConversationInboxPollSuccess();
        }
        if ("preissue".equals(oldIssueType) && "issue".equals(activeConversation.issueType)) {
            this.startLiveUpdates();
        }
        if ((newState = activeConversation.state) != oldState) {
            boolean hasConvertedFromPreIssue;
            activeConversation.refreshConversationOnIssueStateUpdate();
            boolean isIssueStillInProgress = activeConversation.isInProgressState(newState) && activeConversation.isInProgressState(oldState);
            boolean bl = hasConvertedFromPreIssue = oldState == IssueState.COMPLETED_ISSUE_CREATED;
            if (hasConvertedFromPreIssue || !isIssueStillInProgress) {
                this.onIssueStatusChange(newState);
            }
        }
    }

    public boolean checkForReopen(int conversationViewState, String activeConversationId, boolean isActiveConversationInPreIssueMode) {
        ConversationDM activeConversationDM = this.getActiveConversation();
        boolean isIssueStatusChange = activeConversationDM.checkForReOpen(conversationViewState, activeConversationId, isActiveConversationInPreIssueMode);
        if (isIssueStatusChange) {
            activeConversationDM.refreshConversationOnIssueStateUpdate();
            this.onIssueStatusChange(activeConversationDM.state);
        }
        return isIssueStatusChange;
    }

    public boolean isActiveConversationEqual(ConversationDM conversationDM) {
        if (conversationDM == null) {
            return false;
        }
        ConversationDM activeConversationDM = this.getActiveConversation();
        if (activeConversationDM == null) {
            return false;
        }
        if (!StringUtils.isEmpty(activeConversationDM.serverId)) {
            return activeConversationDM.serverId.equals(conversationDM.serverId);
        }
        if (!StringUtils.isEmpty(activeConversationDM.preConversationServerId)) {
            return activeConversationDM.preConversationServerId.equals(conversationDM.preConversationServerId);
        }
        return false;
    }

    public void handlePreIssueCreationSuccess() {
        if (this.conversationVMCallback != null) {
            this.conversationVMCallback.handlePreIssueCreationSuccess();
        }
    }

    @Override
    public void onIssueStatusChange(IssueState issueState) {
        if (this.conversationVMCallback != null) {
            this.conversationVMCallback.onIssueStatusChange(issueState);
        }
    }

    public void startLiveUpdates() {
        ConversationDM activeConversation = this.getActiveConversation();
        if (this.liveUpdateDM != null && !activeConversation.isInPreIssueMode() && this.sdkConfigurationDM.shouldEnableTypingIndicator()) {
            this.liveUpdateDM.registerListener(this, activeConversation.serverId);
        }
    }

    public void stopLiveUpdates() {
        if (this.liveUpdateDM != null) {
            this.liveUpdateDM.unregisterListener();
        }
    }

    public boolean isAgentTyping() {
        return this.liveUpdateDM != null && this.liveUpdateDM.isAgentTyping() && this.sdkConfigurationDM.shouldEnableTypingIndicator();
    }

    @Override
    public void onAgentTypingUpdate(boolean isAgentTyping) {
        if (this.conversationVMCallback != null) {
            this.conversationVMCallback.onAgentTypingUpdate(isAgentTyping);
        }
    }

    public ConversationVMCallback getConversationVMCallback() {
        return this.conversationVMCallback;
    }

    public void setConversationVMCallback(ConversationVMCallback conversationVMCallback) {
        this.conversationVMCallback = conversationVMCallback;
        this.getActiveConversation().setListener(this);
    }

    public void unregisterConversationVMCallback() {
        this.conversationVMCallback = null;
        this.getActiveConversation().setListener(null);
    }

    public abstract void init();

    public abstract Long getIdentifier();

    public abstract boolean shouldOpen();

    public abstract ConversationDM getActiveConversation();

    public abstract void initializeConversationsForUI();

    public abstract void registerMessagesObserver(HSListObserver<MessageDM> var1);

    public abstract void onNewConversationStarted(ConversationDM var1);

    public abstract List<ConversationDM> getAllConversations();

    public abstract void prependConversations(List<ConversationDM> var1);

    public abstract PaginationCursor getPaginationCursor();

    public boolean hasMoreMessages() {
        return this.conversationLoader.hasMoreMessages();
    }

    public List<UIConversation> getUIConversations() {
        List<ConversationDM> conversationDMList = this.getAllConversations();
        ArrayList<UIConversation> result = new ArrayList<UIConversation>();
        if (ListUtils.isEmpty(conversationDMList)) {
            return result;
        }
        int size = conversationDMList.size();
        for (int index = 0; index < size; ++index) {
            ConversationDM conversationDM = conversationDMList.get(index);
            UIConversation uiConversation = new UIConversation(conversationDM.localId, index, conversationDM.getCreatedAt(), conversationDM.publishId, conversationDM.isInPreIssueMode(), conversationDM.state, conversationDM.isRedacted);
            result.add(uiConversation);
        }
        return result;
    }

    public void loadMoreMessages() {
        if (this.isLoadMoreInProgress.compareAndSet(false, true)) {
            this.conversationLoader.loadMoreConversations(this.getPaginationCursor(), this);
        }
    }

    @Override
    public void onSuccess(List<ConversationDM> conversations, boolean hasOlderMessages) {
        if (this.conversationVMCallback != null) {
            this.conversationVMCallback.onHistoryLoadingSuccess();
        }
        if (ListUtils.isEmpty(conversations)) {
            this.isLoadMoreInProgress.set(false);
            if (this.conversationVMCallback != null) {
                this.conversationVMCallback.prependConversations(new ArrayList<ConversationDM>(), hasOlderMessages);
            }
            return;
        }
        for (ConversationDM conversationDM : conversations) {
            conversationDM.setDependencies(this.platform, this.domain, this.userDM);
            boolean isActiveConversation = this.isActiveConversationEqual(conversationDM);
            boolean isMessageClickEnable = isActiveConversation && this.getActiveConversation().shouldEnableMessagesClick();
            conversationDM.initializeMessageListForUI(conversationDM.messageDMs, isMessageClickEnable);
        }
        this.prependConversations(conversations);
        if (this.conversationVMCallback != null) {
            this.conversationVMCallback.prependConversations(conversations, hasOlderMessages);
        }
        this.isLoadMoreInProgress.set(false);
    }

    @Override
    public void onError() {
        this.isLoadMoreInProgress.set(false);
        if (this.conversationVMCallback != null) {
            this.conversationVMCallback.onHistoryLoadingError();
        }
    }

    @Override
    public void loading() {
        this.isLoadMoreInProgress.set(false);
        if (this.conversationVMCallback != null) {
            this.conversationVMCallback.onHistoryLoadingStarted();
        }
    }

    protected PaginationCursor buildPaginationCursor(ConversationDM conversationDM) {
        if (conversationDM == null) {
            return null;
        }
        String conversationCursor = conversationDM.getCreatedAt();
        String messageCursor = ListUtils.isEmpty(conversationDM.messageDMs) ? conversationCursor : ((MessageDM)conversationDM.messageDMs.get(0)).getCreatedAt();
        return new PaginationCursor(conversationCursor, messageCursor);
    }
}

