/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.network.AuthDataProvider;
import com.helpshift.conversation.activeconversation.message.AttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.viewmodel.ConversationVMCallback;
import com.helpshift.downloader.SupportDownloadStateChangeListener;
import com.helpshift.downloader.SupportDownloader;

public class AdminAttachmentMessageDM
extends AttachmentMessageDM {
    public AdminGenericAttachmentState state;
    int downloadProgress = 0;

    public AdminAttachmentMessageDM(String serverId, String body, String createdAt, long epochCreatedAt, String authorName, int size, String contentType, String attachmentUrl, String fileName, boolean isSecureAttachment) {
        super(body, createdAt, epochCreatedAt, authorName, size, contentType, attachmentUrl, fileName, true, isSecureAttachment, MessageType.ADMIN_ATTACHMENT);
        this.serverId = serverId;
        this.updateState();
    }

    public void updateState() {
        this.state = this.checkAndGetFilePath() != null ? AdminGenericAttachmentState.DOWNLOADED : AdminGenericAttachmentState.DOWNLOAD_NOT_STARTED;
    }

    public String getDownloadProgressAndFileSize() {
        String downloadProgressSize = this.getDownloadedProgressSize();
        if (!StringUtils.isEmpty(downloadProgressSize)) {
            return downloadProgressSize + "/" + this.getFormattedFileSize();
        }
        return this.getFormattedFileSize();
    }

    public String getDownloadedProgressSize() {
        double downloadedBytes;
        String downloadedProgressSize = null;
        if (this.state == AdminGenericAttachmentState.DOWNLOADING && this.downloadProgress > 0 && (downloadedBytes = (double)(this.size * this.downloadProgress) / 100.0) < (double)this.size) {
            downloadedProgressSize = this.getFormattedFileSize(downloadedBytes);
        }
        return downloadedProgressSize;
    }

    public boolean isWriteStoragePermissionRequired() {
        return this.state == AdminGenericAttachmentState.DOWNLOAD_NOT_STARTED;
    }

    void setState(AdminGenericAttachmentState state) {
        this.state = state;
        this.notifyUpdated();
    }

    public void handleClick(ConversationVMCallback callback) {
        if (this.state == AdminGenericAttachmentState.DOWNLOADED) {
            if (callback != null) {
                callback.launchAttachment(this.checkAndGetFilePath(), this.contentType);
            }
        } else if (this.state == AdminGenericAttachmentState.DOWNLOAD_NOT_STARTED) {
            this.setState(AdminGenericAttachmentState.DOWNLOADING);
            this.platform.getDownloader().startDownload(this.attachmentUrl, this.isSecureAttachment, SupportDownloader.StorageDirType.EXTERNAL_ONLY, new AuthDataProvider(this.domain, this.platform, this.attachmentUrl), new SupportDownloadStateChangeListener(){

                @Override
                public void onFailure(String url) {
                    AdminAttachmentMessageDM.this.setState(AdminGenericAttachmentState.DOWNLOAD_NOT_STARTED);
                }

                @Override
                public void onSuccess(String url, String filePath) {
                    AdminAttachmentMessageDM.this.filePath = filePath;
                    AdminAttachmentMessageDM.this.platform.getConversationDAO().insertOrUpdateMessage(AdminAttachmentMessageDM.this);
                    AdminAttachmentMessageDM.this.setState(AdminGenericAttachmentState.DOWNLOADED);
                }

                @Override
                public void onProgressChange(String url, int progress) {
                    AdminAttachmentMessageDM.this.downloadProgress = progress;
                    AdminAttachmentMessageDM.this.notifyUpdated();
                }
            });
        }
    }

    public String checkAndGetFilePath() {
        if (!this.doesFilePathExistAndCanRead(this.filePath)) {
            this.filePath = null;
            this.state = AdminGenericAttachmentState.DOWNLOAD_NOT_STARTED;
        }
        return this.filePath;
    }

    @Override
    public boolean isUISupportedMessage() {
        return true;
    }

    public static enum AdminGenericAttachmentState {
        DOWNLOAD_NOT_STARTED,
        DOWNLOADING,
        DOWNLOADED;

    }
}

