/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.network.AuthDataProvider;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.activeconversation.message.ImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.viewmodel.ConversationVMCallback;
import com.helpshift.downloader.SupportDownloadStateChangeListener;
import com.helpshift.downloader.SupportDownloader;

public class AdminImageAttachmentMessageDM
extends ImageAttachmentMessageDM {
    public AdminImageAttachmentState state;
    private int downloadProgress;

    public AdminImageAttachmentMessageDM(String serverId, String body, String createdAt, long epochCreatedAt, String authorName, String attachmentUrl, String fileName, String thumbnailUrl, String contentType, boolean isSecureAttachment, int size) {
        super(body, createdAt, epochCreatedAt, authorName, attachmentUrl, fileName, thumbnailUrl, contentType, size, true, isSecureAttachment, MessageType.ADMIN_IMAGE_ATTACHMENT);
        this.serverId = serverId;
        this.updateState();
    }

    public void updateState() {
        this.state = this.checkAndGetFilePath() != null ? AdminImageAttachmentState.IMAGE_DOWNLOADED : (this.checkAndGetThumbnailFilePath() != null ? AdminImageAttachmentState.THUMBNAIL_DOWNLOADED : AdminImageAttachmentState.DOWNLOAD_NOT_STARTED);
    }

    public String getDownloadProgressAndFileSize() {
        String downloadProgressSize = this.getDownloadedProgressSize();
        if (!StringUtils.isEmpty(downloadProgressSize)) {
            return downloadProgressSize + "/" + this.getFormattedFileSize();
        }
        return this.getFormattedFileSize();
    }

    public String getDownloadedProgressSize() {
        double downloadedBytes;
        String downloadedFileSize = null;
        if (this.state == AdminImageAttachmentState.IMAGE_DOWNLOADING && this.downloadProgress > 0 && (downloadedBytes = (double)(this.size * this.downloadProgress) / 100.0) < (double)this.size) {
            downloadedFileSize = this.getFormattedFileSize(downloadedBytes);
        }
        return downloadedFileSize;
    }

    public String checkAndGetThumbnailFilePath() {
        if (!this.doesFilePathExistAndCanRead(this.thumbnailFilePath)) {
            this.state = AdminImageAttachmentState.DOWNLOAD_NOT_STARTED;
            this.thumbnailFilePath = null;
        }
        return this.thumbnailFilePath;
    }

    public String checkAndGetFilePath() {
        if (!this.doesFilePathExistAndCanRead(this.filePath)) {
            if (this.checkAndGetThumbnailFilePath() != null) {
                this.state = AdminImageAttachmentState.THUMBNAIL_DOWNLOADED;
            }
            this.filePath = null;
        }
        return this.filePath;
    }

    public void setState(AdminImageAttachmentState state) {
        this.state = state;
        this.notifyUpdated();
    }

    public void downloadThumbnailImage(final Platform platform) {
        if (this.state == AdminImageAttachmentState.DOWNLOAD_NOT_STARTED) {
            this.setState(AdminImageAttachmentState.THUMBNAIL_DOWNLOADING);
            platform.getDownloader().startDownload(this.thumbnailUrl, this.isSecureAttachment, SupportDownloader.StorageDirType.EXTERNAL_OR_INTERNAL, new AuthDataProvider(this.domain, platform, this.attachmentUrl), new SupportDownloadStateChangeListener(){

                @Override
                public void onFailure(String url) {
                    AdminImageAttachmentMessageDM.this.setState(AdminImageAttachmentState.DOWNLOAD_NOT_STARTED);
                }

                @Override
                public void onSuccess(String url, String filePath) {
                    AdminImageAttachmentMessageDM.this.thumbnailFilePath = filePath;
                    platform.getConversationDAO().insertOrUpdateMessage(AdminImageAttachmentMessageDM.this);
                    AdminImageAttachmentMessageDM.this.setState(AdminImageAttachmentState.THUMBNAIL_DOWNLOADED);
                }

                @Override
                public void onProgressChange(String url, int progress) {
                }
            });
        }
    }

    public void handleClick(ConversationVMCallback conversationVMCallback) {
        if (this.state == AdminImageAttachmentState.IMAGE_DOWNLOADED) {
            if (conversationVMCallback != null) {
                conversationVMCallback.launchAttachment(this.checkAndGetFilePath(), this.contentType);
            }
        } else if (this.state == AdminImageAttachmentState.DOWNLOAD_NOT_STARTED || this.state == AdminImageAttachmentState.THUMBNAIL_DOWNLOADING || this.state == AdminImageAttachmentState.THUMBNAIL_DOWNLOADED) {
            this.setState(AdminImageAttachmentState.IMAGE_DOWNLOADING);
            this.platform.getDownloader().startDownload(this.attachmentUrl, this.isSecureAttachment, SupportDownloader.StorageDirType.EXTERNAL_ONLY, new AuthDataProvider(this.domain, this.platform, this.attachmentUrl), new SupportDownloadStateChangeListener(){

                @Override
                public void onFailure(String url) {
                    AdminImageAttachmentMessageDM.this.setState(AdminImageAttachmentState.THUMBNAIL_DOWNLOADED);
                }

                @Override
                public void onSuccess(String url, String filePath) {
                    AdminImageAttachmentMessageDM.this.filePath = filePath;
                    AdminImageAttachmentMessageDM.this.platform.getConversationDAO().insertOrUpdateMessage(AdminImageAttachmentMessageDM.this);
                    AdminImageAttachmentMessageDM.this.setState(AdminImageAttachmentState.IMAGE_DOWNLOADED);
                }

                @Override
                public void onProgressChange(String url, int progress) {
                    AdminImageAttachmentMessageDM.this.downloadProgress = progress;
                    AdminImageAttachmentMessageDM.this.notifyUpdated();
                }
            });
        }
    }

    @Override
    public boolean isUISupportedMessage() {
        return true;
    }

    public static enum AdminImageAttachmentState {
        DOWNLOAD_NOT_STARTED,
        THUMBNAIL_DOWNLOADING,
        THUMBNAIL_DOWNLOADED,
        IMAGE_DOWNLOADING,
        IMAGE_DOWNLOADED;

    }
}

