/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.domain.network.AuthenticationFailureNetwork;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardAgainstConversationArchivalNetwork;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.IdempotentNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.domain.network.UserPreConditionsFailedNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;
import com.helpshift.conversation.activeconversation.ConversationServerInfo;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import java.util.Map;

public abstract class AutoRetriableMessageDM
extends MessageDM {
    private int syncStatus;

    AutoRetriableMessageDM(String body, String createdAt, long epochCreatedAt, String authorName, boolean isAdminMessage, MessageType messageType, int syncStatus) {
        super(body, createdAt, epochCreatedAt, authorName, isAdminMessage, messageType);
        this.syncStatus = syncStatus;
    }

    private void updateSyncStatusIntoMemoryAndDB(int newSyncStatus) {
        if (this.syncStatus == newSyncStatus) {
            return;
        }
        this.syncStatus = newSyncStatus;
        this.platform.getConversationDAO().insertOrUpdateMessage(this);
    }

    @Override
    public void merge(MessageDM serverMessageDM) {
        super.merge(serverMessageDM);
        if (serverMessageDM instanceof AutoRetriableMessageDM) {
            this.syncStatus = ((AutoRetriableMessageDM)serverMessageDM).syncStatus;
        }
    }

    public int getSyncStatus() {
        return this.syncStatus;
    }

    Response makeNetworkRequest(String route, Map<String, String> body) {
        Network sendMessageNetwork = new POSTNetwork(route, this.domain, this.platform);
        sendMessageNetwork = new IdempotentNetwork(sendMessageNetwork, this.platform, this.getIdempotentPolicy(), route, String.valueOf(this.localId));
        sendMessageNetwork = new TSCorrectedNetwork(sendMessageNetwork, this.platform);
        sendMessageNetwork = new AuthenticationFailureNetwork(sendMessageNetwork);
        sendMessageNetwork = new UserPreConditionsFailedNetwork(sendMessageNetwork);
        sendMessageNetwork = new GuardAgainstConversationArchivalNetwork(sendMessageNetwork);
        sendMessageNetwork = new FailedAPICallNetworkDecorator(sendMessageNetwork);
        sendMessageNetwork = new GuardOKNetwork(sendMessageNetwork);
        try {
            return sendMessageNetwork.makeRequest(new RequestData(body));
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.NON_RETRIABLE || e.exceptionType == NetworkException.USER_PRE_CONDITION_FAILED) {
                this.updateSyncStatusIntoMemoryAndDB(3);
            } else {
                this.updateSyncStatusIntoMemoryAndDB(1);
            }
            throw e;
        }
    }

    public boolean isRetriable() {
        return this.syncStatus == 1;
    }

    public abstract void send(UserDM var1, ConversationServerInfo var2);
}

