/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.conversation.activeconversation.ConversationServerInfo;
import com.helpshift.conversation.activeconversation.message.AutoRetriableMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import java.util.HashMap;

public class ConfirmationRejectedMessageDM
extends AutoRetriableMessageDM {
    public ConfirmationRejectedMessageDM(String body, String createdAt, long epochCreatedAt, String authorName, int syncStatus) {
        super(body, createdAt, epochCreatedAt, authorName, false, MessageType.CONFIRMATION_REJECTED, syncStatus);
    }

    @Override
    public void send(UserDM userDM, ConversationServerInfo conversationServerInfo) {
        String conversationServerId = conversationServerInfo.getIssueId();
        if (StringUtils.isEmpty(conversationServerId)) {
            throw new UnsupportedOperationException("ConfirmationRejectedMessageDM send called with conversation in pre issue mode.");
        }
        HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(userDM);
        data.put("body", this.body);
        data.put("type", "ncr");
        data.put("refers", "");
        try {
            Response response = this.makeNetworkRequest(this.getIssueSendMessageRoute(conversationServerInfo), data);
            ResponseParser responseParser = this.platform.getResponseParser();
            ConfirmationRejectedMessageDM responseMessageDM = responseParser.parseConfirmationRejectedMessageDM(response.responseString);
            this.merge(responseMessageDM);
            this.serverId = responseMessageDM.serverId;
            this.authorId = responseMessageDM.authorId;
            this.notifyUpdated();
            this.platform.getConversationDAO().insertOrUpdateMessage(this);
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.INVALID_AUTH_TOKEN || e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
                this.domain.getAuthenticationFailureDM().notifyAuthenticationFailure(userDM, e.exceptionType);
            }
            throw e;
        }
    }

    @Override
    public boolean isUISupportedMessage() {
        return true;
    }
}

