/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.IdempotentNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.conversation.activeconversation.ConversationServerInfo;
import com.helpshift.conversation.activeconversation.message.AdminMessageDM;
import com.helpshift.conversation.activeconversation.message.FAQListMessageWithOptionInputDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import java.util.HashMap;
import java.util.List;

public class FAQListMessageDM
extends AdminMessageDM {
    public List<FAQ> faqs;
    public boolean isSuggestionsReadEventSent = false;
    public String suggestionsReadFAQPublishId = "";

    FAQListMessageDM(String serverId, String body, String createdAt, long epochCreatedAt, String authorName, List<FAQ> faqs, MessageType messageType) {
        super(serverId, body, createdAt, epochCreatedAt, authorName, messageType);
        this.faqs = faqs;
    }

    public FAQListMessageDM(String serverId, String body, String createdAt, long epochCreatedAt, String authorName, List<FAQ> faqs) {
        super(serverId, body, createdAt, epochCreatedAt, authorName, MessageType.FAQ_LIST);
        this.faqs = faqs;
    }

    public FAQListMessageDM(String serverId, String body, String createdAt, long epochCreatedAt, String authorName, List<FAQ> faqs, boolean isSuggestionsReadEventSent, String suggestionsReadFAQPublishId) {
        super(serverId, body, createdAt, epochCreatedAt, authorName, MessageType.FAQ_LIST);
        this.faqs = faqs;
        this.isSuggestionsReadEventSent = isSuggestionsReadEventSent;
        this.suggestionsReadFAQPublishId = suggestionsReadFAQPublishId;
    }

    public FAQListMessageDM(FAQListMessageWithOptionInputDM messageDM) {
        super(messageDM.serverId, messageDM.body, messageDM.getCreatedAt(), messageDM.getEpochCreatedAtTime(), messageDM.authorName, MessageType.FAQ_LIST);
        this.faqs = messageDM.faqs;
        this.shouldShowAgentNameForConversation = messageDM.shouldShowAgentNameForConversation;
        this.conversationLocalId = messageDM.conversationLocalId;
    }

    @Override
    public void merge(MessageDM serverMessageDM) {
        super.merge(serverMessageDM);
        if (serverMessageDM instanceof FAQListMessageDM) {
            FAQListMessageDM serverMessage = (FAQListMessageDM)serverMessageDM;
            this.faqs = serverMessage.faqs;
        }
    }

    public void handleSuggestionClick(ConversationServerInfo conversationServerInfo, UserDM userDM, String questionServerId, String questionPublishId) {
        if (!StringUtils.isEmpty(this.suggestionsReadFAQPublishId)) {
            return;
        }
        if (StringUtils.isEmpty(this.suggestionsReadFAQPublishId)) {
            this.suggestionsReadFAQPublishId = questionPublishId;
            this.platform.getConversationDAO().insertOrUpdateMessage(this);
        }
        if (this.isSuggestionsReadEventPending()) {
            this.sendSuggestionReadEvent(conversationServerInfo, userDM);
        }
    }

    public void sendSuggestionReadEvent(ConversationServerInfo conversationServerInfo, UserDM userDM) {
        if (StringUtils.isEmpty(this.suggestionsReadFAQPublishId)) {
            return;
        }
        HashMap<String, String> body = NetworkDataRequestUtil.getUserRequestData(userDM);
        if (conversationServerInfo.isInPreIssueMode()) {
            body.put("preissue_id", conversationServerInfo.getPreIssueId());
        } else {
            body.put("issue_id", conversationServerInfo.getIssueId());
        }
        body.put("message_id", this.serverId);
        body.put("faq_publish_id", this.suggestionsReadFAQPublishId);
        String route = "/faqs_suggestion_read/";
        Network network = new POSTNetwork(route, this.domain, this.platform);
        network = new IdempotentNetwork(network, this.platform, this.getIdempotentPolicy(), route, this.serverId);
        network = new TSCorrectedNetwork(network, this.platform);
        network = new FailedAPICallNetworkDecorator(network);
        network = new GuardOKNetwork(network);
        try {
            network.makeRequest(new RequestData(body));
            this.markSuggestionsReadEventAsSent();
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.NON_RETRIABLE) {
                this.markSuggestionsReadEventAsSent();
            }
            throw e;
        }
    }

    public boolean isSuggestionsReadEventPending() {
        return !this.isSuggestionsReadEventSent;
    }

    private void markSuggestionsReadEventAsSent() {
        this.isSuggestionsReadEventSent = true;
        this.platform.getConversationDAO().insertOrUpdateMessage(this);
    }

    public static final class FAQ {
        public final String title;
        public final String publishId;
        public final String language;

        public FAQ(String title, String publishId, String language) {
            this.title = title;
            this.publishId = publishId;
            this.language = language;
        }
    }
}

