/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.activeconversation.ConversationServerInfo;
import com.helpshift.conversation.activeconversation.message.FAQListMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import java.util.ArrayList;
import java.util.List;

public class FAQListMessageWithOptionInputDM
extends FAQListMessageDM {
    public static final String KEY_SUGGESTIONS_READ_FAQ_PREFIX = "read_faq_";
    public OptionInput input;
    private ArrayList<String> readFAQs;

    public FAQListMessageWithOptionInputDM(String serverId, String body, String createdAt, long epochCreatedAt, String authorName, List<FAQListMessageDM.FAQ> faqs, String botInfo, boolean required, String inputLabel, String skipLabel, List<OptionInput.Option> options) {
        super(serverId, body, createdAt, epochCreatedAt, authorName, faqs, MessageType.FAQ_LIST_WITH_OPTION_INPUT);
        this.input = new OptionInput(botInfo, required, inputLabel, skipLabel, options, OptionInput.Type.PILL);
    }

    public FAQListMessageWithOptionInputDM(String serverId, String body, String createdAt, long epochCreatedAt, String authorName, List<FAQListMessageDM.FAQ> faqs, String botInfo, boolean required, String inputLabel, String skipLabel, List<OptionInput.Option> options, boolean isSuggestionsReadEventSent, String suggestionsReadFAQPublishId) {
        super(serverId, body, createdAt, epochCreatedAt, authorName, faqs, MessageType.FAQ_LIST_WITH_OPTION_INPUT);
        this.input = new OptionInput(botInfo, required, inputLabel, skipLabel, options, OptionInput.Type.PILL);
        this.isSuggestionsReadEventSent = isSuggestionsReadEventSent;
        this.suggestionsReadFAQPublishId = suggestionsReadFAQPublishId;
    }

    @Override
    public void setDependencies(Domain domain, Platform platform) {
        super.setDependencies(domain, platform);
        this.populateReadFAQs();
    }

    @Override
    public void merge(MessageDM serverMessageDM) {
        super.merge(serverMessageDM);
        if (serverMessageDM instanceof FAQListMessageWithOptionInputDM) {
            this.input = ((FAQListMessageWithOptionInputDM)serverMessageDM).input;
        }
    }

    @Override
    public void handleSuggestionClick(ConversationServerInfo conversationServerInfo, UserDM userDM, String questionServerId, String questionPublishId) {
        if (this.readFAQs.size() < 10) {
            this.readFAQs.add(questionServerId);
            this.platform.getKVStore().setSerializable(KEY_SUGGESTIONS_READ_FAQ_PREFIX + this.serverId, this.readFAQs);
        }
        super.handleSuggestionClick(conversationServerInfo, userDM, questionServerId, questionPublishId);
    }

    private void populateReadFAQs() {
        if (this.readFAQs == null) {
            this.readFAQs = new ArrayList();
            Object readFAQsObject = this.platform.getKVStore().getSerializable(KEY_SUGGESTIONS_READ_FAQ_PREFIX + this.serverId);
            if (readFAQsObject instanceof ArrayList) {
                this.readFAQs = (ArrayList)readFAQsObject;
            }
        }
    }
}

