/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.conversation.activeconversation.ConversationServerInfo;
import com.helpshift.conversation.activeconversation.message.AutoRetriableMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import java.util.HashMap;

public class FollowupRejectedMessageDM
extends AutoRetriableMessageDM {
    public static final int REASON_CONVERSATION_FILING = 1;
    public static final int REASON_OPEN_ISSUE = 2;
    public static final int REASON_MESSAGE_FILING = 3;
    public static final int REASON_OPEN_PRE_ISSUE = 4;
    public String referredMessageId;
    public int reason;
    public String openConversationId;

    public FollowupRejectedMessageDM(String body, String createdAt, long epochCreatedAt, String authorName, String referredMessageId, int syncStatus) {
        super(body, createdAt, epochCreatedAt, authorName, false, MessageType.FOLLOWUP_REJECTED, syncStatus);
        this.referredMessageId = referredMessageId;
    }

    @Override
    public void merge(MessageDM serverMessageDM) {
        super.merge(serverMessageDM);
        if (serverMessageDM instanceof FollowupRejectedMessageDM) {
            FollowupRejectedMessageDM message = (FollowupRejectedMessageDM)serverMessageDM;
            this.referredMessageId = message.referredMessageId;
        }
    }

    @Override
    public void send(UserDM userDM, ConversationServerInfo conversationServerInfo) {
        String conversationServerId = conversationServerInfo.getIssueId();
        if (StringUtils.isEmpty(conversationServerId)) {
            throw new UnsupportedOperationException("FollowupRejectedMessageDM send called with conversation in pre issue mode.");
        }
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("reason", this.reason);
        if (this.openConversationId != null) {
            metaData.put("open_issue_id", String.valueOf(this.openConversationId));
        }
        String metaString = this.platform.getJsonifier().jsonify(metaData);
        HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(userDM);
        data.put("body", "Rejected the follow-up");
        data.put("type", "rj");
        data.put("refers", this.referredMessageId);
        data.put("message_meta", metaString);
        try {
            Response response = this.makeNetworkRequest(this.getIssueSendMessageRoute(conversationServerInfo), data);
            ResponseParser responseParser = this.platform.getResponseParser();
            FollowupRejectedMessageDM followupRejectedMessage = responseParser.parseFollowupRejectedMessage(response.responseString);
            this.merge(followupRejectedMessage);
            this.authorId = followupRejectedMessage.authorId;
            this.serverId = followupRejectedMessage.serverId;
            this.platform.getConversationDAO().insertOrUpdateMessage(this);
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.INVALID_AUTH_TOKEN || e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
                this.domain.getAuthenticationFailureDM().notifyAuthenticationFailure(userDM, e.exceptionType);
            }
            throw e;
        }
    }

    @Override
    public boolean isUISupportedMessage() {
        return false;
    }
}

