/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.idempotent.IdempotentPolicy;
import com.helpshift.common.domain.idempotent.SuccessOrNonRetriableStatusCodeIdempotentPolicy;
import com.helpshift.common.domain.network.AuthenticationFailureNetwork;
import com.helpshift.common.domain.network.GuardAgainstConversationArchivalNetwork;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.IdempotentNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.domain.network.UserPreConditionsFailedNetwork;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.common.util.HSSimpleDateFormat;
import com.helpshift.conversation.activeconversation.ConversationServerInfo;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.UIViewState;
import com.helpshift.localeprovider.domainmodel.LocaleProviderDM;
import com.helpshift.util.HSLogger;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Observable;

public abstract class MessageDM
extends Observable {
    public static final int DELIVERY_STATE_UNREAD = 0;
    public static final int DELIVERY_STATE_READ = 1;
    public static final int DELIVERY_STATE_SENT = 2;
    private static final String TAG = "Helpshift_MessageDM";
    public final boolean isAdminMessage;
    public final MessageType messageType;
    private final UIViewState uiViewState;
    public String serverId;
    public String body;
    public String authorId;
    public String authorName;
    public Long conversationLocalId;
    public Long localId;
    public String readAt;
    public String seenAtMessageCursor;
    public int deliveryState;
    public boolean isMessageSeenSynced;
    public boolean shouldShowAgentNameForConversation;
    public String createdRequestId;
    public boolean isRedacted;
    protected Domain domain;
    protected Platform platform;
    private String createdAt;
    private long epochCreatedAtTime;

    MessageDM(String body, String createdAt, long epochCreatedAtTime, String authorName, boolean isAdminMessage, MessageType messageType) {
        this.body = body;
        this.createdAt = createdAt;
        this.epochCreatedAtTime = epochCreatedAtTime;
        this.authorName = authorName;
        this.isAdminMessage = isAdminMessage;
        this.messageType = messageType;
        this.uiViewState = new UIViewState();
    }

    public void setDependencies(Domain domain, Platform platform) {
        this.domain = domain;
        this.platform = platform;
    }

    public String getSubText() {
        Date outputDate;
        LocaleProviderDM localeProviderDM = this.domain.getLocaleProviderDM();
        Locale locale = localeProviderDM.getCurrentLocale();
        try {
            HSSimpleDateFormat storageTimeFormat = HSDateFormatSpec.getDateFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", locale, "GMT");
            outputDate = storageTimeFormat.parse(this.getCreatedAt());
        }
        catch (ParseException e) {
            outputDate = new Date();
            HSLogger.d(TAG, "getSubText : ParseException", e);
        }
        String displayPattern = this.platform.getDevice().is24HourFormat() ? "H:mm" : "h:mm a";
        String formattedDate = HSDateFormatSpec.getDateFormatter(displayPattern, locale).format(outputDate);
        String authorName = this.getDisplayedAuthorName();
        String subText = !StringUtils.isEmpty(authorName) ? authorName + ", " + formattedDate : formattedDate;
        return subText;
    }

    public String getAccessbilityMessageTime() {
        Locale locale = this.domain.getLocaleProviderDM().getCurrentLocale();
        Date messageCreateAtDate = new Date(this.getEpochCreatedAtTime());
        String displayPattern = this.platform.getDevice().is24HourFormat() ? "H:mm" : "h:mm a";
        String formattedTime = HSDateFormatSpec.getDateFormatter(displayPattern, locale).format(messageCreateAtDate);
        String formattedDate = HSDateFormatSpec.getDateFormatter("EEEE, MMMM dd, yyyy", locale).format(messageCreateAtDate);
        return formattedTime + " " + formattedDate;
    }

    public String getDisplayedAuthorName() {
        String resultAuthorName = null;
        if (this.isAdminMessage && this.shouldShowAgentNameForConversation && this.domain.getSDKConfigurationDM().getBoolean("showAgentName")) {
            resultAuthorName = StringUtils.isEmpty(this.authorName) ? null : this.authorName.trim();
        }
        return resultAuthorName;
    }

    void notifyUpdated() {
        this.setChanged();
        this.notifyObservers();
    }

    public void mergeAndNotify(MessageDM messageDM) {
        this.merge(messageDM);
        this.notifyUpdated();
    }

    public void merge(MessageDM serverMessageDM) {
        this.body = serverMessageDM.body;
        this.createdAt = serverMessageDM.getCreatedAt();
        this.epochCreatedAtTime = serverMessageDM.getEpochCreatedAtTime();
        this.authorName = serverMessageDM.authorName;
        if (StringUtils.isEmpty(this.serverId)) {
            this.serverId = serverMessageDM.serverId;
        }
    }

    public abstract boolean isUISupportedMessage();

    Network getSendMessageNetwork(String route) {
        Network sendMessageNetwork = new POSTNetwork(route, this.domain, this.platform);
        sendMessageNetwork = new IdempotentNetwork(sendMessageNetwork, this.platform, this.getIdempotentPolicy(), route, String.valueOf(this.localId));
        sendMessageNetwork = new TSCorrectedNetwork(sendMessageNetwork, this.platform);
        sendMessageNetwork = new UserPreConditionsFailedNetwork(sendMessageNetwork);
        sendMessageNetwork = new AuthenticationFailureNetwork(sendMessageNetwork);
        sendMessageNetwork = new GuardAgainstConversationArchivalNetwork(sendMessageNetwork);
        return new GuardOKNetwork(sendMessageNetwork);
    }

    String getPreIssueSendMessageRoute(ConversationServerInfo conversationServerInfo) {
        return "/preissues/" + conversationServerInfo.getPreIssueId() + "/messages/";
    }

    String getIssueSendMessageRoute(ConversationServerInfo conversationServerInfo) {
        return "/issues/" + conversationServerInfo.getIssueId() + "/messages/";
    }

    public UIViewState getUiViewState() {
        return this.uiViewState;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        if (!StringUtils.isEmpty(createdAt)) {
            this.createdAt = createdAt;
        }
    }

    public long getEpochCreatedAtTime() {
        return this.epochCreatedAtTime;
    }

    public void setEpochCreatedAtTime(long epochCreatedAtTime) {
        this.epochCreatedAtTime = epochCreatedAtTime;
    }

    protected IdempotentPolicy getIdempotentPolicy() {
        return new SuccessOrNonRetriableStatusCodeIdempotentPolicy();
    }
}

