/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.network.AuthDataProvider;
import com.helpshift.common.domain.network.AuthenticationFailureNetwork;
import com.helpshift.common.domain.network.GuardAgainstConversationArchivalNetwork;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.IdempotentNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.domain.network.UploadNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;
import com.helpshift.conversation.activeconversation.ConversationServerInfo;
import com.helpshift.conversation.activeconversation.message.ImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.UserMessageState;
import com.helpshift.conversation.viewmodel.ConversationVMCallback;
import com.helpshift.downloader.SupportDownloadStateChangeListener;
import com.helpshift.downloader.SupportDownloader;
import java.util.HashMap;
import java.util.UUID;

public class ScreenshotMessageDM
extends ImageAttachmentMessageDM {
    public String refersMessageId;
    public UserMessageState state;

    public ScreenshotMessageDM(String body, String createdAt, long epochCreatedAt, String authorName, String contentType, String thumbnailUrl, String fileName, String imageUrl, int size, boolean isSecureAttachment) {
        super(body, createdAt, epochCreatedAt, authorName, imageUrl, fileName, thumbnailUrl, contentType, size, false, isSecureAttachment, MessageType.SCREENSHOT);
    }

    public void setRefersMessageId(String refersMessageId) {
        if (refersMessageId == null) {
            refersMessageId = "localRscMessage_" + UUID.randomUUID().toString();
        }
        this.refersMessageId = refersMessageId;
    }

    public void handleClick(ConversationVMCallback callback) {
        if (this.state == UserMessageState.SENT && callback != null) {
            callback.launchScreenshotAttachment(this.getFilePath(), this.contentType);
        }
    }

    public void uploadImage(UserDM userDM, ConversationServerInfo conversationServerInfo, boolean shouldCompressImage) {
        String conversationServerId = conversationServerInfo.getIssueId();
        if (StringUtils.isEmpty(conversationServerId)) {
            throw new UnsupportedOperationException("ScreenshotMessageDM send called with conversation in pre issue mode.");
        }
        if (this.getFilePath() == null) {
            return;
        }
        if (shouldCompressImage) {
            this.filePath = this.platform.compressAndStoreScreenshot(this.getFilePath(), this.refersMessageId);
            this.platform.getConversationDAO().insertOrUpdateMessage(this);
        }
        this.setState(UserMessageState.SENDING);
        HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(userDM);
        data.put("body", "Screenshot sent");
        data.put("type", "sc");
        data.put("refers", this.refersMessageId);
        data.put("screenshot", this.getFilePath());
        data.put("originalFileName", this.fileName);
        try {
            String route = this.getIssueSendMessageRoute(conversationServerInfo);
            Network network = new UploadNetwork(route, this.domain, this.platform);
            network = new IdempotentNetwork(network, this.platform, this.getIdempotentPolicy(), route, String.valueOf(this.localId));
            network = new AuthenticationFailureNetwork(network);
            network = new GuardAgainstConversationArchivalNetwork(network);
            RequestData requestData = new RequestData(data);
            Response response = new GuardOKNetwork(network).makeRequest(requestData);
            ScreenshotMessageDM screenshotMessageDM = this.platform.getResponseParser().parseScreenshotMessageDM(response.responseString);
            this.serverId = screenshotMessageDM.serverId;
            this.authorId = screenshotMessageDM.authorId;
            this.merge(screenshotMessageDM);
            this.setState(UserMessageState.SENT);
            this.platform.getConversationDAO().insertOrUpdateMessage(this);
            this.notifyUpdated();
            HashMap<String, Object> analyticsData = new HashMap<String, Object>();
            analyticsData.put("id", conversationServerId);
            analyticsData.put("body", screenshotMessageDM.attachmentUrl);
            analyticsData.put("type", "url");
            this.domain.getAnalyticsEventDM().pushEvent(AnalyticsEventType.MESSAGE_ADDED, analyticsData);
            this.domain.getDelegate().userRepliedToConversation("User sent a screenshot");
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.INVALID_AUTH_TOKEN || e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
                this.domain.getAuthenticationFailureDM().notifyAuthenticationFailure(userDM, e.exceptionType);
            }
            if (StringUtils.isEmpty(this.serverId)) {
                this.setState(UserMessageState.UNSENT_RETRYABLE);
            }
            throw RootAPIException.wrap(e);
        }
    }

    public void setState(UserMessageState state) {
        this.state = state;
        this.notifyUpdated();
    }

    public void updateState(boolean isClickable) {
        if (this.serverId == null) {
            if (this.state == UserMessageState.SENDING) {
                return;
            }
            if (isClickable) {
                this.setState(UserMessageState.UNSENT_RETRYABLE);
            } else {
                this.setState(UserMessageState.UNSENT_NOT_RETRYABLE);
            }
        } else {
            this.setState(UserMessageState.SENT);
        }
    }

    public String getFilePath() {
        if (!this.doesFilePathExistAndCanRead(this.filePath)) {
            this.filePath = null;
        }
        return this.filePath;
    }

    public void checkAndReDownloadImageIfNotExist(final Platform platform) {
        if (this.state == UserMessageState.SENT && !this.doesFilePathExistAndCanRead(this.getFilePath())) {
            platform.getDownloader().startDownload(this.attachmentUrl, this.isSecureAttachment, SupportDownloader.StorageDirType.INTERNAL_ONLY, new AuthDataProvider(this.domain, platform, this.attachmentUrl), new SupportDownloadStateChangeListener(){

                @Override
                public void onFailure(String url) {
                }

                @Override
                public void onSuccess(String url, String filePath) {
                    ScreenshotMessageDM.this.filePath = filePath;
                    platform.getConversationDAO().insertOrUpdateMessage(ScreenshotMessageDM.this);
                    ScreenshotMessageDM.this.notifyUpdated();
                }

                @Override
                public void onProgressChange(String url, int progress) {
                }
            });
        }
    }

    @Override
    public boolean isUISupportedMessage() {
        return true;
    }
}

