/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.conversation.activeconversation.ConversationServerInfo;
import com.helpshift.conversation.activeconversation.message.AutoRetriableMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import java.util.HashMap;

public class UserBotControlMessageDM
extends AutoRetriableMessageDM {
    public String actionType;
    public String reason;
    public String botInfo;
    public String refersMessageId;

    public UserBotControlMessageDM(String body, String createdAt, long epochCreatedAt, String authorName, String actionType, String reason, String botInfo, String refersMessageId, int syncState) {
        super(body, createdAt, epochCreatedAt, authorName, false, MessageType.USER_BOT_CONTROL, syncState);
        this.actionType = actionType;
        this.reason = reason;
        this.botInfo = botInfo;
        this.refersMessageId = refersMessageId;
    }

    @Override
    public void merge(MessageDM serverMessageDM) {
        super.merge(serverMessageDM);
        if (serverMessageDM instanceof UserBotControlMessageDM) {
            UserBotControlMessageDM serverMessage = (UserBotControlMessageDM)serverMessageDM;
            this.actionType = serverMessage.actionType;
            this.reason = serverMessage.reason;
            this.botInfo = serverMessage.botInfo;
            this.refersMessageId = serverMessage.refersMessageId;
        }
    }

    @Override
    public void send(UserDM userDM, ConversationServerInfo conversationServerInfo) {
        Response response;
        HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(userDM);
        data.put("origin", "mobile");
        data.put("type", this.actionType);
        data.put("chatbot_cancelled_reason", this.reason);
        data.put("body", this.body);
        data.put("chatbot_info", this.botInfo);
        data.put("refers", this.refersMessageId);
        String route = conversationServerInfo.isInPreIssueMode() ? this.getPreIssueSendMessageRoute(conversationServerInfo) : this.getIssueSendMessageRoute(conversationServerInfo);
        try {
            response = this.makeNetworkRequest(route, data);
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED || e.exceptionType == NetworkException.INVALID_AUTH_TOKEN) {
                this.domain.getAuthenticationFailureDM().notifyAuthenticationFailure(userDM, e.exceptionType);
            }
            throw e;
        }
        ResponseParser responseParser = this.platform.getResponseParser();
        UserBotControlMessageDM responseMessageDM = (UserBotControlMessageDM)responseParser.parseBotControlMessage(response.responseString, false);
        this.merge(responseMessageDM);
        this.serverId = responseMessageDM.serverId;
        this.platform.getConversationDAO().insertOrUpdateMessage(this);
    }

    @Override
    public boolean isUISupportedMessage() {
        return false;
    }
}

