/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;
import com.helpshift.conversation.activeconversation.ConversationServerInfo;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.UserMessageState;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class UserMessageDM
extends MessageDM {
    private UserMessageState state;

    public UserMessageDM(String body, String createdAt, long epochCreatedAt, String authorName) {
        super(body, createdAt, epochCreatedAt, authorName, false, MessageType.USER_TEXT);
    }

    public UserMessageDM(String body, String createdAt, long epochCreatedAt, String authorName, MessageType messageType) {
        super(body, createdAt, epochCreatedAt, authorName, false, messageType);
    }

    protected Map<String, String> getData() throws ParseException {
        return new HashMap<String, String>();
    }

    protected String getMessageTypeForRequest() {
        return "txt";
    }

    public String getReferredMessageId() {
        return "";
    }

    public void send(UserDM userDM, ConversationServerInfo conversationServerInfo) {
        if (this.state == UserMessageState.SENDING || this.state == UserMessageState.SENT || this.state == UserMessageState.UNSENT_NOT_RETRYABLE) {
            return;
        }
        this.setState(UserMessageState.SENDING);
        String route = conversationServerInfo.isInPreIssueMode() ? this.getPreIssueSendMessageRoute(conversationServerInfo) : this.getIssueSendMessageRoute(conversationServerInfo);
        try {
            Map<String, String> data = this.getData();
            data.putAll(NetworkDataRequestUtil.getUserRequestData(userDM));
            data.put("body", this.body);
            data.put("type", this.getMessageTypeForRequest());
            data.put("refers", this.getReferredMessageId());
            RequestData requestData = new RequestData(data);
            Response response = this.getSendMessageNetwork(route).makeRequest(requestData);
            UserMessageDM responseMessageDM = this.parseResponse(response);
            this.state = UserMessageState.SENT;
            this.merge(responseMessageDM);
            this.serverId = responseMessageDM.serverId;
            this.platform.getConversationDAO().insertOrUpdateMessage(this);
            this.authorId = responseMessageDM.authorId;
            this.notifyUpdated();
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.INVALID_AUTH_TOKEN || e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
                this.setStateAsUnsentRetryable();
                this.domain.getAuthenticationFailureDM().notifyAuthenticationFailure(userDM, e.exceptionType);
            } else if (e.exceptionType != NetworkException.CONVERSATION_ARCHIVED && e.exceptionType != NetworkException.USER_PRE_CONDITION_FAILED) {
                this.setStateAsUnsentRetryable();
            }
            throw RootAPIException.wrap(e);
        }
        catch (ParseException e) {
            this.setStateAsUnsentRetryable();
            throw RootAPIException.wrap(e);
        }
        finally {
            this.domain.getDelegate().userRepliedToConversation(this.body);
            if (!conversationServerInfo.isInPreIssueMode()) {
                HashMap<String, Object> analyticsData = new HashMap<String, Object>();
                analyticsData.put("id", conversationServerInfo.getIssueId());
                analyticsData.put("body", this.body);
                analyticsData.put("type", "txt");
                this.domain.getAnalyticsEventDM().pushEvent(AnalyticsEventType.MESSAGE_ADDED, analyticsData);
            }
        }
    }

    protected UserMessageDM parseResponse(Response response) {
        return this.platform.getResponseParser().parseReadableUserMessage(response.responseString);
    }

    private void setStateAsUnsentRetryable() {
        if (StringUtils.isEmpty(this.serverId)) {
            this.setState(UserMessageState.UNSENT_RETRYABLE);
        }
    }

    public void updateState(boolean isClickable) {
        if (StringUtils.isEmpty(this.serverId)) {
            if (this.state == UserMessageState.SENDING) {
                return;
            }
            if (isClickable) {
                this.setState(UserMessageState.UNSENT_RETRYABLE);
            } else {
                this.setState(UserMessageState.UNSENT_NOT_RETRYABLE);
            }
        } else {
            this.setState(UserMessageState.SENT);
        }
    }

    public UserMessageState getState() {
        return this.state;
    }

    public void setState(UserMessageState newState) {
        UserMessageState oldState = this.state;
        this.state = newState;
        if (oldState != this.state) {
            this.notifyUpdated();
        }
    }

    @Override
    public boolean isUISupportedMessage() {
        return true;
    }
}

