/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.OptionInputMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageDM;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserResponseMessageForOptionInput
extends UserMessageDM {
    public String botInfo;
    public boolean skipped;
    public String optionData;
    public MessageType referredMessageType;
    private String referredMessageId;

    public UserResponseMessageForOptionInput(String body, String createdAt, long epochCreatedAt, String authorName, String botInfo, boolean skipped, String optionData, String referredMessageId, MessageType referredMessageType) {
        super(body, createdAt, epochCreatedAt, authorName, MessageType.USER_RESP_FOR_OPTION_INPUT);
        this.botInfo = botInfo;
        this.skipped = skipped;
        this.optionData = optionData;
        this.referredMessageId = referredMessageId;
        this.referredMessageType = referredMessageType;
    }

    public UserResponseMessageForOptionInput(String body, String createdAt, long epochCreatedAt, String authorName, OptionInputMessageDM messageDM, boolean skipped) {
        super(body, createdAt, epochCreatedAt, authorName, MessageType.USER_RESP_FOR_OPTION_INPUT);
        this.botInfo = messageDM.input.botInfo;
        this.skipped = skipped;
        this.optionData = this.getSelectedOptionData(messageDM.input.options);
        this.referredMessageId = messageDM.serverId;
        this.referredMessageType = messageDM.referredMessageType;
    }

    @Override
    public void merge(MessageDM serverMessageDM) {
        super.merge(serverMessageDM);
        if (serverMessageDM instanceof UserResponseMessageForOptionInput) {
            UserResponseMessageForOptionInput message = (UserResponseMessageForOptionInput)serverMessageDM;
            this.botInfo = message.botInfo;
            this.skipped = message.skipped;
            this.optionData = message.optionData;
            this.referredMessageId = message.referredMessageId;
            this.referredMessageType = message.referredMessageType;
        }
    }

    @Override
    protected Map<String, String> getData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("chatbot_info", this.botInfo);
        data.put("skipped", String.valueOf(this.skipped));
        if (!this.skipped) {
            data.put("option_data", this.optionData);
        }
        if (this.referredMessageType == MessageType.FAQ_LIST_WITH_OPTION_INPUT) {
            ArrayList<String> readFAQs = new ArrayList();
            Object readFAQsObject = this.platform.getKVStore().getSerializable("read_faq_" + this.referredMessageId);
            if (readFAQsObject instanceof ArrayList) {
                readFAQs = (List)readFAQsObject;
            }
            data.put("read_faqs", this.platform.getJsonifier().jsonifyListToJsonArray(readFAQs).toString());
        }
        return data;
    }

    @Override
    protected String getMessageTypeForRequest() {
        switch (this.referredMessageType) {
            case ADMIN_TEXT_WITH_OPTION_INPUT: {
                return "rsp_txt_msg_with_option_input";
            }
            case FAQ_LIST_WITH_OPTION_INPUT: {
                return "rsp_faq_list_msg_with_option_input";
            }
        }
        return super.getMessageTypeForRequest();
    }

    @Override
    public String getReferredMessageId() {
        return this.referredMessageId;
    }

    private String getSelectedOptionData(List<OptionInput.Option> options) {
        for (OptionInput.Option option : options) {
            if (!option.title.equals(this.body)) continue;
            return option.jsonData;
        }
        return "{}";
    }

    @Override
    protected UserMessageDM parseResponse(Response response) {
        ResponseParser responseParser = this.platform.getResponseParser();
        return responseParser.parseResponseMessageForOptionInput(response.responseString);
    }
}

