/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message;

import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.common.util.HSSimpleDateFormat;
import com.helpshift.conversation.activeconversation.message.AdminMessageWithTextInputDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.UserMessageDM;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class UserResponseMessageForTextInputDM
extends UserMessageDM {
    public final boolean isMessageEmpty;
    public int keyboard;
    public String botInfo;
    public boolean skipped;
    public long dateInMillis;
    public String timeZoneId;
    private String referredMessageId;

    public UserResponseMessageForTextInputDM(String body, String createdAt, long epochCreatedAt, String authorName, int keyboard, String botInfo, boolean skipped, String referredMessageId, boolean isMessageEmpty) {
        super(body, createdAt, epochCreatedAt, authorName, MessageType.USER_RESP_FOR_TEXT_INPUT);
        this.keyboard = keyboard;
        this.botInfo = botInfo;
        this.skipped = skipped;
        this.referredMessageId = referredMessageId;
        this.isMessageEmpty = isMessageEmpty;
    }

    public UserResponseMessageForTextInputDM(String body, String createdAt, long epochCreatedAt, String authorName, AdminMessageWithTextInputDM messageDM, boolean isSkipped) {
        super(body, createdAt, epochCreatedAt, authorName, MessageType.USER_RESP_FOR_TEXT_INPUT);
        this.keyboard = messageDM.input.keyboard;
        this.botInfo = messageDM.input.botInfo;
        this.skipped = isSkipped;
        this.referredMessageId = messageDM.serverId;
        this.isMessageEmpty = messageDM.isMessageEmpty;
    }

    @Override
    public void merge(MessageDM serverMessageDM) {
        super.merge(serverMessageDM);
        if (serverMessageDM instanceof UserResponseMessageForTextInputDM) {
            UserResponseMessageForTextInputDM serverMessage = (UserResponseMessageForTextInputDM)serverMessageDM;
            this.keyboard = serverMessage.keyboard;
            this.botInfo = serverMessage.botInfo;
            this.skipped = serverMessage.skipped;
            this.referredMessageId = serverMessage.referredMessageId;
            this.dateInMillis = serverMessage.dateInMillis;
            this.timeZoneId = serverMessage.timeZoneId;
        }
    }

    @Override
    protected String getMessageTypeForRequest() {
        switch (this.keyboard) {
            case 1: {
                if (this.isMessageEmpty) {
                    return "rsp_empty_msg_with_txt_input";
                }
                return "rsp_txt_msg_with_txt_input";
            }
            case 2: {
                return "rsp_txt_msg_with_email_input";
            }
            case 3: {
                return "rsp_txt_msg_with_numeric_input";
            }
            case 4: {
                return "rsp_txt_msg_with_dt_input";
            }
        }
        return super.getMessageTypeForRequest();
    }

    @Override
    public String getReferredMessageId() {
        return this.referredMessageId;
    }

    @Override
    protected Map<String, String> getData() throws ParseException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("chatbot_info", this.botInfo);
        data.put("skipped", String.valueOf(this.skipped));
        if (this.keyboard == 4 && !this.skipped) {
            Locale locale = this.domain.getLocaleProviderDM().getCurrentLocale();
            HSSimpleDateFormat dateFormat = HSDateFormatSpec.getDateFormatter("EEEE, MMMM dd, yyyy", locale);
            Date date = dateFormat.parse(this.body.trim());
            HashMap<String, Object> metaData = new HashMap<String, Object>();
            this.dateInMillis = date.getTime();
            this.timeZoneId = this.platform.getDevice().getTimeZoneId();
            metaData.put("dt", this.dateInMillis);
            metaData.put("timezone", this.timeZoneId);
            String metaDataStr = this.platform.getJsonifier().jsonify(metaData);
            data.put("message_meta", metaDataStr);
        }
        return data;
    }

    @Override
    protected UserMessageDM parseResponse(Response response) {
        ResponseParser responseParser = this.platform.getResponseParser();
        return responseParser.parseResponseMessageForTextInput(response.responseString);
    }
}

