/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message.input;

import android.support.annotation.NonNull;
import com.helpshift.conversation.activeconversation.message.input.Input;
import java.util.List;

public class OptionInput
extends Input {
    public final List<Option> options;
    public final Type type;

    public OptionInput(String botInfo, boolean required, String inputLabel, String skipLabel, List<Option> options, Type type) {
        super(botInfo, required, inputLabel, skipLabel);
        this.options = options;
        this.type = type;
    }

    public static enum Type {
        PILL("pill"),
        PICKER("picker");

        private final String optionInputType;

        private Type(String type) {
            this.optionInputType = type;
        }

        @NonNull
        public String toString() {
            return this.optionInputType;
        }

        public static Type getType(String typeString, int optionsCount) {
            if ("pill".equals(typeString)) {
                return PILL;
            }
            if ("picker".equals(typeString)) {
                return PICKER;
            }
            if (optionsCount <= 5) {
                return PILL;
            }
            return PICKER;
        }
    }

    public static class Option {
        public final String title;
        public final String jsonData;

        public Option(String title, String jsonData) {
            this.title = title;
            this.jsonData = jsonData;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Option)) {
                return false;
            }
            Option val = (Option)obj;
            return val.title.equals(this.title) && val.jsonData.equals(this.jsonData);
        }
    }
}

