/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.activeconversation.message.input;

import com.helpshift.common.domain.Domain;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.common.util.HSSimpleDateFormat;
import com.helpshift.conversation.activeconversation.message.input.Input;
import com.helpshift.util.HSPattern;
import java.text.ParseException;
import java.util.Locale;

public class TextInput
extends Input {
    public final String placeholder;
    public final int keyboard;
    private Domain domain;

    public TextInput(String botInfo, boolean required, String inputLabel, String skipLabel, String placeholder, int keyboard) {
        super(botInfo, required, inputLabel, skipLabel);
        this.placeholder = placeholder;
        this.keyboard = keyboard;
    }

    public void setDependencies(Domain domain) {
        this.domain = domain;
    }

    public boolean validate(String reply) {
        switch (this.keyboard) {
            case 2: {
                return HSPattern.isValidEmail(reply);
            }
            case 3: {
                return HSPattern.isPositiveNumber(reply);
            }
            case 4: {
                try {
                    Locale locale = this.domain.getLocaleProviderDM().getCurrentLocale();
                    HSSimpleDateFormat dateFormat = HSDateFormatSpec.getDateFormatter("EEEE, MMMM dd, yyyy", locale);
                    dateFormat.parse(reply.trim());
                    return true;
                }
                catch (ParseException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public static interface Keyboard {
        public static final int TEXT = 1;
        public static final int EMAIL = 2;
        public static final int NUMERIC = 3;
        public static final int DATE = 4;
    }
}

