/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.domainmodel;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.AuthenticationFailureNetwork;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;
import com.helpshift.conversation.dto.ConversationHistory;
import java.util.HashMap;

public class ConversationHistoryRemoteDataFetcher {
    private Platform platform;
    private Domain domain;
    private UserDM userDM;

    public ConversationHistoryRemoteDataFetcher(Platform platform, Domain domain, UserDM userDM) {
        this.platform = platform;
        this.domain = domain;
        this.userDM = userDM;
    }

    private Network buildFetchNetwork() {
        Network network = new POSTNetwork("/conversations/history/", this.domain, this.platform);
        network = new AuthenticationFailureNetwork(network);
        network = new FailedAPICallNetworkDecorator(network);
        network = new TSCorrectedNetwork(network, this.platform);
        network = new GuardOKNetwork(network);
        return network;
    }

    private RequestData buildRequestData(String cursor) {
        HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(this.userDM);
        data.put("cursor", cursor);
        return new RequestData(data);
    }

    public ConversationHistory fetchConversations(String cursor) throws RootAPIException {
        Network network = this.buildFetchNetwork();
        RequestData requestData = this.buildRequestData(cursor);
        Response response = network.makeRequest(requestData);
        return this.platform.getResponseParser().parseConversationHistory(response.responseString);
    }
}

