/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.conversation.domainmodel;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.ConversationUtil;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.ConversationUpdate;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.dto.IssueState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConversationHistoryRemoteDataMerger {
    private Platform platform;
    private Domain domain;
    private UserDM userDM;

    public ConversationHistoryRemoteDataMerger(Platform platform, Domain domain, UserDM userDM) {
        this.platform = platform;
        this.domain = domain;
        this.userDM = userDM;
    }

    public void merge(List<ConversationDM> conversationDMList) {
        if (ListUtils.isEmpty(conversationDMList)) {
            return;
        }
        HashSet<ConversationDM> convToUpdate = new HashSet<ConversationDM>();
        HashMap<Long, ConversationUpdate> conversationUpdateMap = new HashMap<Long, ConversationUpdate>();
        HashSet<ConversationDM> newConvToInsert = new HashSet<ConversationDM>();
        if (conversationDMList.size() > 1) {
            ConversationUtil.sortConversationsBasedOnCreatedAt(conversationDMList);
        }
        List<ConversationDM> localConversations = this.platform.getConversationDAO().readConversationsWithoutMessages(this.userDM.getLocalId());
        ArrayList<ConversationDM> listOfConversationToInsert = new ArrayList<ConversationDM>();
        HashMap<String, ConversationDM> localConversationsLookup = new HashMap<String, ConversationDM>();
        HashMap<String, ConversationDM> localPreConversationsLookupByPreIssueId = new HashMap<String, ConversationDM>();
        for (ConversationDM localConversation : localConversations) {
            if (!StringUtils.isEmpty(localConversation.serverId)) {
                localConversationsLookup.put(localConversation.serverId, localConversation);
                continue;
            }
            if (StringUtils.isEmpty(localConversation.preConversationServerId)) continue;
            localPreConversationsLookupByPreIssueId.put(localConversation.preConversationServerId, localConversation);
        }
        for (ConversationDM serverConversation : conversationDMList) {
            IssueState state;
            String serverConversationId = serverConversation.serverId;
            String serverPreConversationId = serverConversation.preConversationServerId;
            ConversationDM localConversationDM = null;
            if (localConversationsLookup.containsKey(serverConversationId)) {
                localConversationDM = (ConversationDM)localConversationsLookup.get(serverConversationId);
            } else if (localPreConversationsLookupByPreIssueId.containsKey(serverPreConversationId)) {
                localConversationDM = (ConversationDM)localPreConversationsLookupByPreIssueId.get(serverPreConversationId);
            }
            if (localConversationDM != null) {
                localConversationDM.setDependencies(this.platform, this.domain, this.userDM);
                ConversationUpdate conversationUpdate = conversationUpdateMap.containsKey(localConversationDM.localId) ? (ConversationUpdate)conversationUpdateMap.get(localConversationDM.localId) : new ConversationUpdate();
                if (serverConversation.isInPreIssueMode()) {
                    if (localConversationDM.isInPreIssueMode()) {
                        localConversationDM.mergePreIssue(serverConversation, false, conversationUpdate);
                    } else {
                        localConversationDM.mergeMessageFromConversationHistory(serverConversation.messageDMs, conversationUpdate);
                    }
                } else {
                    localConversationDM.mergeIssue(serverConversation, false, conversationUpdate);
                }
                convToUpdate.add(localConversationDM);
                conversationUpdateMap.put(localConversationDM.localId, conversationUpdate);
                continue;
            }
            if (serverConversation.isInPreIssueMode()) {
                serverConversation.lastUserActivityTime = System.currentTimeMillis();
                if (serverConversation.state == IssueState.RESOLUTION_REQUESTED) {
                    serverConversation.state = IssueState.RESOLUTION_ACCEPTED;
                }
            }
            if ((state = serverConversation.state) != null && (state == IssueState.RESOLUTION_ACCEPTED || state == IssueState.RESOLUTION_REJECTED || state == IssueState.REJECTED || state == IssueState.ARCHIVED)) {
                serverConversation.isStartNewConversationClicked = true;
            }
            if (state != null && serverConversation.isRedacted && serverConversation.state == IssueState.RESOLUTION_REQUESTED) {
                serverConversation.isStartNewConversationClicked = true;
                serverConversation.state = IssueState.RESOLUTION_ACCEPTED;
            }
            listOfConversationToInsert.add(serverConversation);
        }
        if (listOfConversationToInsert.size() <= 1) {
            newConvToInsert.addAll(listOfConversationToInsert);
            this.putConversations(convToUpdate, newConvToInsert, conversationUpdateMap);
            return;
        }
        ArrayList copyOfConvToInsert = new ArrayList(listOfConversationToInsert);
        block2: for (int i = copyOfConvToInsert.size() - 1; i >= 0; --i) {
            ConversationDM newConversation = (ConversationDM)copyOfConvToInsert.get(i);
            if (newConversation.isInPreIssueMode()) continue;
            for (int j = i - 1; j >= 0; --j) {
                ConversationDM associatedPreIssue = (ConversationDM)copyOfConvToInsert.get(j);
                if (StringUtils.isEmpty(newConversation.preConversationServerId) || !newConversation.preConversationServerId.equals(associatedPreIssue.preConversationServerId) || !newConversation.serverId.equals(associatedPreIssue.serverId)) continue;
                newConversation.messageDMs.addAll((Collection<MessageDM>)associatedPreIssue.messageDMs);
                listOfConversationToInsert.remove(j);
                continue block2;
            }
        }
        newConvToInsert.addAll(listOfConversationToInsert);
        this.putConversations(convToUpdate, newConvToInsert, conversationUpdateMap);
    }

    void putConversations(Set<ConversationDM> convToUpdate, Set<ConversationDM> newConvToInsert, Map<Long, ConversationUpdate> conversationUpdateMap) {
        for (ConversationDM conversation : convToUpdate) {
            conversation.setDependencies(this.platform, this.domain, this.userDM);
        }
        for (ConversationDM conversation : newConvToInsert) {
            conversation.setDependencies(this.platform, this.domain, this.userDM);
        }
        this.platform.getConversationDAO().updateConversations(new ArrayList<ConversationDM>(convToUpdate), conversationUpdateMap);
        this.platform.getConversationDAO().insertConversations(new ArrayList<ConversationDM>(newConvToInsert));
    }
}

